/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlComparer;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoveInlineLayoutComponentReferences
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (reportSpec == null) {
            return reportSpec;
        }
        Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification20._report);
        if (report == null) {
            return reportSpec;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        if (layouts == null) {
            return reportSpec;
        }
        this.removeInline(layouts, layouts, upgradeSession);
        XmlUtils.writeIntermediateDocument(reportSpec, "v5_layoutComponentRefsInlineRemover", upgradeSession.getConfiguration());
        return reportSpec;
    }

    private void removeInline(Element elem, final Element layouts, final UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            DomWalker.bottomUpWalkElements(elem, new DomWalker.Examiner(){

                @Override
                public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                    try {
                        String elemName = XmlUtils.getName(elem);
                        if ("_inlinedLayoutComponentRef".equals(elemName)) {
                            if (RemoveInlineLayoutComponentReferences.this.canLayoutComponentRefBeRestored(elem, layouts, upgradeSession)) {
                                RemoveInlineLayoutComponentReferences.this.restoreLayoutComponentRef(elem, upgradeSession);
                            } else {
                                RemoveInlineLayoutComponentReferences.this.removeInliningTags(elem, upgradeSession);
                            }
                        }
                        return DomWalker.SearchOrder.proceed;
                    }
                    catch (UpgradeException e) {
                        throw new XmlException(e);
                    }
                }
            });
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void restoreLayoutComponentRef(Element inlinedLayoutComponentRef, UpgradeSessionContext upgradeSession) {
        Document doc = inlinedLayoutComponentRef.getOwnerDocument();
        String name = inlinedLayoutComponentRef.getAttribute(ReportSpecification20._refLayoutElement);
        Element layoutComponentRef = XmlUtils.createElement(doc, ReportSpecification20._layoutComponentRef);
        layoutComponentRef.setAttribute(ReportSpecification20._refLayoutElement, name);
        NodeList overrideList = inlinedLayoutComponentRef.getElementsByTagName("_inlinedLayoutComponentOverride");
        int nbOverrides = overrideList.getLength();
        if (nbOverrides > 0) {
            Element overrides = XmlUtils.createElement(doc, ReportSpecification20._layoutComponentOverrides);
            layoutComponentRef.appendChild(overrides);
            for (int i = 0; i < nbOverrides; ++i) {
                Element inlinedOverride = (Element)overrideList.item(i);
                String overrideName = inlinedOverride.getAttribute(ReportSpecification20._refLayoutElement);
                Element layoutComponentOverride = XmlUtils.createElement(doc, ReportSpecification20._layoutComponentOverride);
                layoutComponentOverride.setAttribute(ReportSpecification20._refLayoutElement, overrideName);
                overrides.appendChild(layoutComponentOverride);
                Node overrideContent = inlinedOverride.getFirstChild();
                while (overrideContent != null) {
                    Node nextSibling = overrideContent.getNextSibling();
                    layoutComponentOverride.appendChild(overrideContent);
                    overrideContent = nextSibling;
                }
            }
        }
        Element parent = XmlUtils.getParentElement(inlinedLayoutComponentRef);
        XmlUtils.writeIntermediateDocument(layoutComponentRef, "layoutComponentRef", upgradeSession.getConfiguration());
        parent.replaceChild(layoutComponentRef, inlinedLayoutComponentRef);
    }

    private boolean canLayoutComponentRefBeRestored(Element inlinedRef, Element layouts, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            XmlUtils.writeIntermediateDocument(inlinedRef, "canLayoutComponentRefBeRestored_inlinedRef", upgradeSession.getConfiguration());
            Element inlinedBody = XmlUtils.getChildElement(inlinedRef);
            if (inlinedBody == null) {
                return false;
            }
            String name = inlinedRef.getAttribute(ReportSpecification20._refLayoutElement);
            Element referencedElement = XmlUtils.getElementWithAttributeValue(layouts, ReportSpecification20._name, name);
            if (referencedElement == null) {
                return false;
            }
            boolean ok = this.undoOverrides(inlinedBody = (Element)inlinedBody.cloneNode(true), layouts);
            if (!ok) {
                return false;
            }
            this.restoreNames(inlinedBody);
            XmlUtils.writeIntermediateDocument(inlinedBody, "canLayoutComponentRefBeRestored_inlinedBody_after_restoration", upgradeSession.getConfiguration());
            XmlComparer xmlCompareTool = upgradeSession.getXmlComparer();
            boolean result = xmlCompareTool.areNodesSame(referencedElement, inlinedBody);
            return result;
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private boolean undoOverrides(Element inlinedBody, Element layouts) throws UpgradeException {
        if (inlinedBody == null) {
            return true;
        }
        String localName = XmlUtils.getName(inlinedBody);
        if ("_inlinedLayoutComponentOverride".equals(localName)) {
            String name = inlinedBody.getAttribute(ReportSpecification20._refLayoutElement);
            Element referencedElement = XmlUtils.getElementWithAttributeValue(layouts, ReportSpecification20._name, name);
            if (referencedElement == null) {
                return false;
            }
            Element referencedElementClone = (Element)referencedElement.cloneNode(true);
            Element parent = XmlUtils.getParentElement(inlinedBody);
            parent.replaceChild(referencedElementClone, inlinedBody);
        } else {
            for (Node child = inlinedBody.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element childElement;
                boolean ok;
                if (!(child instanceof Element) || (ok = this.undoOverrides(childElement = (Element)child, layouts))) continue;
                return ok;
            }
        }
        return true;
    }

    private void restoreNames(Element elem) {
        if (elem == null) {
            return;
        }
        if (elem.hasAttribute("_originalName")) {
            String name = elem.getAttribute("_originalName");
            elem.setAttribute(ReportSpecification20._name, name);
            elem.removeAttribute("_originalName");
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.restoreNames(childElement);
        }
    }

    private Element replaceWithChild(Element elem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            Element parent = (Element)elem.getParentNode();
            Element child = XmlUtils.getChildElement(elem);
            Element sibling = XmlUtils.getNextSiblingElement(child);
            if (sibling != null) {
                throw new UpgradeException("Too many child elements");
            }
            if (child == null) {
                upgradeSession.getXmlDeleteTool().deleteNode(elem);
            } else {
                parent.insertBefore(child, elem);
                upgradeSession.getXmlDeleteTool().deleteNode(elem);
            }
            return child;
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private void removeInliningTags(Element elem, final UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            DomWalker.bottomUpWalkElements(elem, new DomWalker.Examiner(){

                @Override
                public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                    try {
                        elem.removeAttribute("_originalName");
                        String name = XmlUtils.getName(elem);
                        if (name.equals("_inlinedLayoutComponentOverride") || name.equals("_inlinedLayoutComponentRef")) {
                            Element parent = XmlUtils.getParentElement(elem);
                            Element msgLocation = RemoveInlineLayoutComponentReferences.this.replaceWithChild(elem, upgradeSession);
                            if (msgLocation == null) {
                                msgLocation = parent;
                            }
                            if (name.equals("_inlinedLayoutComponentRef")) {
                                String refName = elem.getAttribute(ReportSpecification20._refLayoutElement);
                                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_LAYOUT_COMPONENT_REF_EXPANDED(refName);
                                upgradeSession.getUpgradeNotes().addUpgradeNote(msgLocation, 2, msg, true);
                            }
                            return DomWalker.SearchOrder.siblingsOnly;
                        }
                        return DomWalker.SearchOrder.proceed;
                    }
                    catch (UpgradeException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof XmlException) {
                            throw (XmlException)cause;
                        }
                        throw new XmlException(e);
                    }
                }
            });
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }
}

