/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticReportExpressions;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportExpressionCleaner {
    private static final String falseExpression = "1=0";
    private static final String reportLocaleExpression = "ReportLocale()";
    private static final String emptyStringExpression = "''";

    public Document cleanReportExpressions(Document v4Spec, Locale expressionLocale, UpgradeSessionContext upgradeSession) throws UpgradeException {
        List<Element> expressions = BalticReportExpressions.getReportExpressions(v4Spec);
        for (Element expression : expressions) {
            this.cleanReportExpression(expression, expressionLocale, upgradeSession);
        }
        return v4Spec;
    }

    private void cleanReportExpression(Element expressionElement, Locale locale, UpgradeSessionContext upgradeSession) throws UpgradeException {
        boolean invalidExpression = false;
        String oldExpression = XmlUtils.getText(expressionElement);
        String newExpression = null;
        String parserErrorMessage = null;
        String variableName = null;
        try {
            CrxParser parser = new CrxParser(new StringReader(oldExpression), locale, upgradeSession.getTranslatedMessages());
            parser.start();
        }
        catch (CrxParserException ex) {
            parserErrorMessage = ex.getLocalizedMessage();
            invalidExpression = true;
        }
        if (invalidExpression) {
            Element parentElement = (Element)expressionElement.getParentNode();
            String parentElementName = XmlUtils.getName(parentElement);
            if (parentElementName.equals("variable")) {
                RspecUpgradeMessage formattedMsg = RspecUpgradeMessage.RSU_UPG_CRX_PARSER_ERROR_2(oldExpression, parserErrorMessage);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)parentElement, 0, formattedMsg);
                variableName = parentElement.getAttribute("name");
                String variableType = parentElement.getAttribute("type");
                newExpression = variableType.equals("boolean") ? falseExpression : (variableType.equals("locale") ? reportLocaleExpression : emptyStringExpression);
            } else {
                newExpression = emptyStringExpression;
            }
        }
        if (newExpression != null) {
            XmlUtils.setText(expressionElement, newExpression);
            RspecUpgradeMessage message = null;
            message = variableName != null ? RspecUpgradeMessage.RSU_SPC_VARIABLE_EXPRESSION_CHANGED(variableName, oldExpression, newExpression, parserErrorMessage) : RspecUpgradeMessage.RSU_SPC_REPORT_EXPRESSION_CHANGED(oldExpression, newExpression, parserErrorMessage);
            upgradeSession.getUpgradeNotes().addUpgradeNote(expressionElement, 1, message, true);
        }
    }
}

