/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetSortOrder
implements UpgradePipelineElement {
    private HashMap<String, BalticQueryInfo> balticQueryInfoMap = new HashMap();

    private void loadBalticQueryInfoMap(Element report) throws UpgradeException {
        DomWalker.Examiner queryExaminer = new DomWalker.Examiner(){

            @Override
            public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                if (XmlUtils.getName(elem).equals("BIQuery")) {
                    try {
                        BalticQueryInfo query = new BalticQueryInfo(elem);
                        SetSortOrder.this.balticQueryInfoMap.put(query.getName(), query);
                    }
                    catch (UpgradeException e) {
                        XmlException.throwNestedException(e);
                    }
                }
                return DomWalker.SearchOrder.proceed;
            }
        };
        Element querySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        if (querySet != null) {
            try {
                DomWalker.walkChildrenElements(querySet, queryExaminer);
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
            }
        }
    }

    BalticQueryInfo getCachedBalticQueryInfo(Element aBIQuery) {
        return this.balticQueryInfoMap.get(aBIQuery.getAttribute("name"));
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element burst;
        if (origSpec == null) {
            return origSpec;
        }
        Element report = XmlUtils.getFirstChildElementByName(origSpec, ReportSpecification20._report);
        if (report == null) {
            return origSpec;
        }
        this.loadBalticQueryInfoMap(report);
        SortItemExaminer examiner = new SortItemExaminer();
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        if (layouts != null) {
            try {
                DomWalker.topDownWalkElements(layouts, examiner);
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
            }
        }
        if ((burst = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._burst)) != null) {
            try {
                DomWalker.topDownWalkElements(burst, examiner);
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
            }
        }
        XmlUtils.writeIntermediateDocument(origSpec, "setSortOrder", upgradeSession.getConfiguration());
        return origSpec;
    }

    private class SortItemExaminer
    implements DomWalker.Examiner {
        private SortItemExaminer() {
        }

        private void deleteDuplicateSortItem(Element sortItem) throws XmlException {
            final String refDataItem = sortItem.getAttribute(ReportSpecification20._refDataItem);
            class DuplicateExaminer
            implements DomWalker.Examiner {
                DuplicateExaminer() {
                }

                @Override
                public DomWalker.SearchOrder examine(Element elem) throws XmlException {
                    String siblingRefDataItem;
                    String elemName = XmlUtils.getName(elem);
                    if (elemName.equals(ReportSpecification20._sortItem) && (siblingRefDataItem = elem.getAttribute(ReportSpecification20._refDataItem)).equals(refDataItem)) {
                        XmlUtils.delete(elem);
                    }
                    return DomWalker.SearchOrder.proceed;
                }
            }
            DomWalker.walkFollowingSiblingElements(sortItem, new DuplicateExaminer());
        }

        private String getBalticQueryName(Element sortItem) {
            Element refQueryElem = BeringQueryFinder.findRefQueryElement(sortItem);
            String queryName = refQueryElem.hasAttribute("originalRefQuery") ? refQueryElem.getAttribute("originalRefQuery") : refQueryElem.getAttribute(ReportSpecification20._refQuery);
            return queryName;
        }

        private Element getBalticQueryElement(Element sortItem) {
            String queryName = this.getBalticQueryName(sortItem);
            return BalticQueryFinder.findQueryElement(sortItem.getOwnerDocument(), queryName);
        }

        private String getBalticItemSortOrder(Element sortItem) throws XmlException, UpgradeException {
            String sortItemName = sortItem.getAttribute(ReportSpecification20._refDataItem);
            Element aBalticQueryElement = this.getBalticQueryElement(sortItem);
            BalticQueryInfo balticQuery = SetSortOrder.this.getCachedBalticQueryInfo(aBalticQueryElement);
            return balticQuery.getItemSortOrder(sortItemName);
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String elemName = XmlUtils.getName(elem);
            if (!elemName.equals(ReportSpecification20._sortItem)) {
                return DomWalker.SearchOrder.proceed;
            }
            this.deleteDuplicateSortItem(elem);
            String sortOrder = elem.getAttribute(ReportSpecification20._sortOrder);
            if (sortOrder.length() == 0) {
                try {
                    sortOrder = this.getBalticItemSortOrder(elem);
                }
                catch (UpgradeException e) {
                    XmlException.throwNestedException(e);
                }
            }
            if (sortOrder.equals("none")) {
                XmlUtils.delete(elem);
            } else {
                elem.setAttribute(ReportSpecification20._sortOrder, sortOrder);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }

    static class BalticQueryInfo {
        private String name;
        private String autoSortValue;
        private boolean isSummaryQuery;
        private Element cubeElement;
        private HashMap<String, String> itemSortOrder = new HashMap();
        Collection<Element> tabularModels;

        private String extractQueryAutoSortValue(Element aBIQueryElement) {
            Element autoSortElement = XmlUtils.getFirstChildElementByName(aBIQueryElement, "autoSort");
            if (null == autoSortElement) {
                return "minimal";
            }
            return autoSortElement.getAttribute("enable");
        }

        private void initializeItemSortOrderMap(Element cubeElem) throws UpgradeException {
            if (null == cubeElem) {
                return;
            }
            BalticQueryItemSortExaminer itemExaminer = new BalticQueryItemSortExaminer(this.tabularModels, cubeElem, this.autoSortValue, this.isSummaryQuery, this.itemSortOrder);
            try {
                DomWalker.topDownWalkElements(cubeElem, itemExaminer);
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getAutoSortValue() {
            return this.autoSortValue;
        }

        public boolean isSummaryQuery() {
            return this.isSummaryQuery;
        }

        public Element getCubeElement() {
            return this.cubeElement;
        }

        public String getItemSortOrder(String itemName) throws UpgradeException {
            if (!this.itemSortOrder.containsKey(itemName)) {
                throw new UpgradeInternalErrorException("There are no entries for item '" + itemName + "' in the itemSort map.");
            }
            return this.itemSortOrder.get(itemName);
        }

        public BalticQueryInfo(Element aBIQuery) throws UpgradeException {
            this.name = aBIQuery.getAttribute("name");
            this.autoSortValue = this.extractQueryAutoSortValue(aBIQuery);
            this.isSummaryQuery = BalticQueryFinder.isSummaryQuery(aBIQuery);
            this.cubeElement = BalticQueryFinder.findCube(aBIQuery.getOwnerDocument(), aBIQuery);
            this.tabularModels = BalticQueryFinder.findTabularModels(aBIQuery.getOwnerDocument(), this.name);
            this.initializeItemSortOrderMap(this.cubeElement);
        }
    }

    static class BalticQueryItemSortExaminer
    implements DomWalker.Examiner {
        private Collection<Element> tabularModels;
        private Element cubeElement;
        private String queryAutoSortValue;
        private boolean isSummaryQuery;
        private Map<String, String> itemSortOrder;

        private boolean isItem(Element elem) {
            String elemName = XmlUtils.getName(elem);
            return elemName.equals("item") || elemName.equals("dataItem");
        }

        private String getItemName(Element elem) throws UpgradeInternalErrorException {
            String elemName = XmlUtils.getName(elem);
            String itemName = null;
            if (elemName.equals("item")) {
                itemName = elem.hasAttribute("alias") ? elem.getAttribute("alias") : elem.getAttribute("refItem");
            } else if (elemName.equals("dataItem")) {
                itemName = elem.getAttribute("name");
            } else {
                throw new UpgradeInternalErrorException("Invalid element name: '" + elemName + "'.  Element must be either 'item' or 'dataItem'.");
            }
            return itemName;
        }

        private String getRefItemName(Element elem) throws UpgradeInternalErrorException {
            String elemName = XmlUtils.getName(elem);
            String itemName = null;
            if (elemName.equals("item")) {
                itemName = elem.getAttribute("refItem");
            } else if (elemName.equals("dataItem")) {
                itemName = elem.getAttribute("name");
            } else {
                throw new UpgradeInternalErrorException("Invalid element name: '" + elemName + "'.  Element must be either 'item' or 'dataItem'.");
            }
            return itemName;
        }

        private Vector<String> getLevelNamesForAutoSort(String autoSortValue, Element cube, Element balticItem) {
            Element balticFactList;
            if (!autoSortValue.equals("minimal") && !autoSortValue.equals("true")) {
                return new Vector<String>();
            }
            Element dimension = BalticQueryFinder.getDimensionOfItem(balticItem);
            if (dimension == null) {
                return new Vector<String>();
            }
            Vector<String> balticLevelNames = BalticQueryFinder.findLevelNamesOfDimension(dimension);
            if (autoSortValue.equals("minimal") && (balticFactList = XmlUtils.getFirstChildElementByName(cube, "factList")) == null && !balticLevelNames.isEmpty()) {
                balticLevelNames.remove(balticLevelNames.lastElement());
            }
            return balticLevelNames;
        }

        private boolean isAutoSortApplied(String queryAutoSort, Element cube, Element balticItem) {
            String key;
            String levelName;
            Element itemParent;
            String itemParentName;
            Vector<String> balticLevelNames = this.getLevelNamesForAutoSort(queryAutoSort, cube, balticItem);
            boolean wasBalticSorting = false;
            if (balticItem != null && (itemParentName = XmlUtils.getName(itemParent = (Element)balticItem.getParentNode())).equals("level") && balticLevelNames.contains(levelName = itemParent.getAttribute("name")) && (key = balticItem.getAttribute("key")).equals("true")) {
                wasBalticSorting = true;
            }
            return wasBalticSorting;
        }

        private Element getTabularModelDataItem(String dataItemName) {
            Element dataItem = null;
            Iterator<Element> iter = this.tabularModels.iterator();
            while (dataItem == null && iter.hasNext()) {
                Element tabularModel = iter.next();
                dataItem = XmlUtils.getFirstChildElementByNameWithAttributeValue(tabularModel, "dataItem", "name", dataItemName);
            }
            return dataItem;
        }

        private String extractTabularModelItemSortOrder(String dataItemName) {
            Element dataItem = this.getTabularModelDataItem(dataItemName);
            String sortOrder = null;
            if (dataItem != null && dataItem.hasAttribute("sort")) {
                sortOrder = dataItem.getAttribute("sort");
            }
            return sortOrder;
        }

        private String extractItemAutoSortValue(Element item) {
            boolean sortAscending;
            if (this.queryAutoSortValue.equals("false")) {
                return null;
            }
            if (this.queryAutoSortValue.equals("minimal") && this.isSummaryQuery) {
                return null;
            }
            String sortValue = null;
            if ((this.queryAutoSortValue.equals("minimal") || this.queryAutoSortValue.equals("true")) && (sortAscending = this.isAutoSortApplied(this.queryAutoSortValue, this.cubeElement, item))) {
                sortValue = "ascending";
            }
            return sortValue;
        }

        private String extractItemSortOrder(Element elem) throws UpgradeException {
            String sortOrder = "none";
            if (elem.hasAttribute("sort")) {
                sortOrder = elem.getAttribute("sort");
            } else {
                String refItemName = this.getRefItemName(elem);
                String tabularSortValue = this.extractTabularModelItemSortOrder(refItemName);
                if (tabularSortValue != null) {
                    sortOrder = tabularSortValue;
                } else {
                    String itemAutoSortValue = this.extractItemAutoSortValue(elem);
                    if (itemAutoSortValue != null) {
                        sortOrder = itemAutoSortValue;
                    }
                }
            }
            return sortOrder;
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            try {
                if (this.isItem(elem)) {
                    String itemName = this.getItemName(elem);
                    String sortOrder = this.extractItemSortOrder(elem);
                    this.itemSortOrder.put(itemName, sortOrder);
                }
            }
            catch (UpgradeException e) {
                XmlException.throwNestedException(e);
            }
            return DomWalker.SearchOrder.proceed;
        }

        public BalticQueryItemSortExaminer(Collection<Element> theTabularModels, Element theCubeElem, String theQueryAutoSortValue, boolean theIsSummaryQuery, Map<String, String> theItemSortOrder) {
            this.tabularModels = theTabularModels;
            this.cubeElement = theCubeElem;
            this.queryAutoSortValue = theQueryAutoSortValue;
            this.isSummaryQuery = theIsSummaryQuery;
            this.itemSortOrder = theItemSortOrder;
        }
    }
}

