/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UndefinedNameInExpression
implements UpgradePipelineElement {
    private Locale expressionLocale;

    public UndefinedNameInExpression(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
    }

    private String getCrxExpression(Element reportExpression) throws UpgradeException {
        if (!ReportSpecification20._reportExpression.equals(reportExpression.getLocalName())) {
            throw new UpgradeInternalErrorException("reportExpression element expected, not " + reportExpression.getLocalName());
        }
        return XmlUtils.getText(reportExpression);
    }

    private void logExpressionError(Element reportExpression, MessageTemplate msgTemplate, UpgradeSessionContext upgradeSession) throws UpgradeException {
        upgradeSession.getUpgradeNotes().addUpgradeNote((Node)reportExpression, 0, msgTemplate);
    }

    private Element checkQueryExists(String queryName, Element reportExpression, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Document reportSpecification = XmlUtils.getOwnerDoc(reportExpression);
        Element queryElement = BeringQueryFinder.findQueryElement(reportSpecification, queryName);
        if (queryElement != null) {
            return queryElement;
        }
        this.logExpressionError(reportExpression, RspecUpgradeMessage.RSU_SPC_QUERY_NOT_FOUND_IN_EXPRESSION(queryName, this.getCrxExpression(reportExpression)), upgradeSession);
        return queryElement;
    }

    private void checkFullNameDefined(NameExpression name, Element reportExpression, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String queryName = name.getQueryName();
        Element queryElement = this.checkQueryExists(queryName, reportExpression, upgradeSession);
        if (queryElement == null) {
            return;
        }
        if (BeringQueryFinder.queryContainsDataItem(queryElement, name)) {
            return;
        }
        this.logExpressionError(reportExpression, RspecUpgradeMessage.RSU_SPC_DATA_ITEM_NOT_IN_QUERY_FOR_EXPRESSION(name.toString(this.expressionLocale), this.getCrxExpression(reportExpression)), upgradeSession);
    }

    private void checkIfDataItemDefinedInAnyQuery(NameExpression name, Element reportExpression, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Document reportSpec = XmlUtils.getOwnerDoc(reportExpression);
        String reportNamespaceUri = this.getReportNamespace(reportSpec);
        NodeList queryElements = XmlUtils.getOwnerDoc(reportExpression).getElementsByTagNameNS(reportNamespaceUri, ReportSpecification20._query);
        int nbQueries = queryElements.getLength();
        for (int i = 0; i < nbQueries; ++i) {
            Element query = (Element)queryElements.item(i);
            if (!BeringQueryFinder.queryContainsDataItem(query, name)) continue;
            return;
        }
        this.logExpressionError(reportExpression, RspecUpgradeMessage.RSU_SPC_DATA_ITEM_NOT_IN_ANY_QUERY_FOR_EXPRESSION(name.toString(this.expressionLocale), this.getCrxExpression(reportExpression)), upgradeSession);
    }

    private void checkNameDefined(NameExpression name, Element reportExpression, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String queryName = name.getQueryName();
        if (queryName != null) {
            this.checkFullNameDefined(name, reportExpression, upgradeSession);
        } else {
            this.checkIfDataItemDefinedInAnyQuery(name, reportExpression, upgradeSession);
        }
    }

    private void checkExpression(Element reportExpression, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            String expressionString = this.getCrxExpression(reportExpression);
            StringReader expressionReader = new StringReader(expressionString);
            CrxParser parser = upgradeSession.createCrxParser(expressionReader, this.expressionLocale);
            IExpression parseTree = parser.start();
            Set<NameExpression> names = GetNames.getNames(parseTree);
            for (NameExpression name : names) {
                this.checkNameDefined(name, reportExpression, upgradeSession);
            }
        }
        catch (CrxParserException e) {
            throw new UpgradeInternalErrorException(e);
        }
    }

    private void checkExpressions(NodeList reportExpressions, UpgradeSessionContext upgradeSession) throws UpgradeException {
        int nbExpressions = reportExpressions.getLength();
        for (int i = 0; i < nbExpressions; ++i) {
            Element reportExpression = (Element)reportExpressions.item(i);
            this.checkExpression(reportExpression, upgradeSession);
        }
    }

    private String getReportNamespace(Document reportSpec) {
        Element root = XmlUtils.getRoot(reportSpec);
        String namespace = root.getNamespaceURI();
        return namespace;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String namespace = this.getReportNamespace(origSpec);
        NodeList reportExpressionList = origSpec.getElementsByTagNameNS(namespace, ReportSpecification20._reportExpression);
        this.checkExpressions(reportExpressionList, upgradeSession);
        return origSpec;
    }
}

