/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.io.XslTransformerImpl;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.AliasMap;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.AliasMapping;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.AsOfTimeAdjuster;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticBurstElementCleanup;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticCleanupXmlAttributes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticConditionalStyleCleaner;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticSharedQueryAnnotater;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticTextItemRefVariableCleaner;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticToBeringXsl;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticValidation;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.CrosstabInvalidDrillParameterFixup;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.CrosstabSharedQueryFixup;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.DanglingReferenceConditionalStyleCases;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.DanglingReferenceDetector;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.DataFormatUpgrader;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.DuplicateDataItemRemoverBaltic;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.DuplicateNameDetector;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.DuplicateRefVariableValueFixer;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.FunctionReplacement;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.InlineLayoutComponentReferences;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.InvalidLayoutComponentReferenceRemover;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.InvalidVariableReferenceDetector;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.LayoutComponentRefFixups;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.LayoutElementMandatory;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.MasterDetailInfo;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.NestedSectionedQuery;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.PageBreakTextOption;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.ParamExpressionFixup;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.PropertyListAdjuster;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.QueryExpressionParseCheck;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.RemoveInlineLayoutComponentReferences;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.ReportExpressionCleaner;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.SetSortOrder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.TextBoxRangeDefaultSelections;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.UndefinedNameInExpression;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.UnusedBrokenVariableRemover;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.VariableDemultiplexer;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import com.qfw.V4toV5.V4toV5QuerySet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Upgrade10to20
implements UpgradePipelineElement {
    private Locale expressionLocale;

    @Override
    public Document upgrade(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            XmlUtils.writeIntermediateDocument(v4Spec, "original_v4", upgradeSession.getConfiguration());
            Document v5MasterDetail = null;
            Document v5Spec = null;
            this.expressionLocale = this.getExpressionLocale(v4Spec, upgradeSession);
            BalticValidation validator = new BalticValidation(this.expressionLocale);
            v4Spec = validator.upgrade(v4Spec, upgradeSession);
            v4Spec = this.v4Preprocess(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "preprocessed_v4", upgradeSession.getConfiguration());
            BalticBurstElementCleanup balticBursting = new BalticBurstElementCleanup();
            v4Spec = balticBursting.upgrade(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "balticBursting", upgradeSession.getConfiguration());
            DuplicateNameDetector duplicateNameDetector = new DuplicateNameDetector();
            v4Spec = duplicateNameDetector.fixup(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4AfterDuplicateNameCleanup", upgradeSession.getConfiguration());
            UpgradePipelineElement cleaner = new BalticTextItemRefVariableCleaner();
            v4Spec = ((BalticTextItemRefVariableCleaner)cleaner).upgrade(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4TextItemRefVariableCleaner", upgradeSession.getConfiguration());
            cleaner = new BalticConditionalStyleCleaner(upgradeSession.getTranslatedMessages(), this.expressionLocale);
            v4Spec = ((BalticConditionalStyleCleaner)cleaner).upgrade(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4ConditionalStyle", upgradeSession.getConfiguration());
            ReportExpressionCleaner expressionCleaner = new ReportExpressionCleaner();
            v4Spec = expressionCleaner.cleanReportExpressions(v4Spec, this.expressionLocale, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4AfterReportExpressionsCleanup", upgradeSession.getConfiguration());
            QueryExpressionParseCheck expressionCheck = new QueryExpressionParseCheck(this.expressionLocale);
            v4Spec = expressionCheck.upgrade(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4AfterQueryExpressionsCheck", upgradeSession.getConfiguration());
            ParamExpressionFixup fixer = new ParamExpressionFixup(this.expressionLocale);
            v4Spec = fixer.upgrade(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "ParamExpressionFixup", upgradeSession.getConfiguration());
            v4Spec = this.layoutComponentRefFixups(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4_layoutComponentRefFixup", upgradeSession.getConfiguration());
            v4Spec = this.generateV5Queries(v4Spec, upgradeSession);
            AliasMap aliasMap = new AliasMap(v4Spec);
            v4Spec = this.replaceFunctions(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4_function_replacement", upgradeSession.getConfiguration());
            v4Spec = this.aliasMap(v4Spec, aliasMap, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4_alias_mapping", upgradeSession.getConfiguration());
            MasterDetailInfo mdDataGenerator = new MasterDetailInfo(this.expressionLocale);
            v5MasterDetail = mdDataGenerator.getMasterDetailInfo(v4Spec, upgradeSession);
            Node mdInfo = v5MasterDetail.getFirstChild();
            Node v4MasterDetailInfo = v4Spec.importNode(mdInfo, true);
            Element v4Report = this.getRootElement(v4Spec);
            v4Report.appendChild(v4MasterDetailInfo);
            XmlUtils.writeIntermediateDocument(v4Spec, "v4_master_detail", upgradeSession.getConfiguration());
            BalticCleanupXmlAttributes v4CleanupXMLAttributes = new BalticCleanupXmlAttributes();
            v4Spec = v4CleanupXMLAttributes.upgrade(v4Spec, upgradeSession);
            v5Spec = this.generateV5(v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "generated_v5", upgradeSession.getConfiguration());
            DuplicateDataItemRemoverBaltic dupRemover = new DuplicateDataItemRemoverBaltic();
            v5Spec = dupRemover.upgrade(v5Spec, upgradeSession);
            LayoutElementMandatory layoutElementManditoryUpgrader = new LayoutElementMandatory();
            layoutElementManditoryUpgrader.upgrade(v5Spec, upgradeSession);
            v5Spec = this.setSortOrder(v5Spec, upgradeSession);
            v5Spec = this.containerDataFormat(v5Spec, upgradeSession);
            v5Spec = this.customChartLabelRemoval(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5_customChartLabelRemoval", upgradeSession.getConfiguration());
            UpgradePipelineElement upgrader = new DanglingReferenceConditionalStyleCases(this.expressionLocale);
            v5Spec = upgrader.upgrade(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5AfterDanglingReferenceConditionalStyleCases", upgradeSession.getConfiguration());
            v5Spec = this.danglingReferenceDetector(aliasMap, v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5_dangling_reference_detection", upgradeSession.getConfiguration());
            v5Spec = this.demultiplexVariables(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v4Spec, "v5_variable_demultiplexing", upgradeSession.getConfiguration());
            v5Spec = this.removeInvalidLayoutComponentRefs(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5AfterInvalidLayoutComponentRefRemoval", upgradeSession.getConfiguration());
            v5Spec = this.inlineLayoutComponentReferences(v5Spec, upgradeSession);
            v5Spec = this.asOfTimeFixup(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5_asOfTime_adjusted", upgradeSession.getConfiguration());
            v5Spec = this.crosstabFixup(v5Spec, v4Spec, upgradeSession);
            upgrader = new NestedSectionedQuery();
            v5Spec = upgrader.upgrade(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5_NestedSectionedQuery", upgradeSession.getConfiguration());
            upgrader = new TextBoxRangeDefaultSelections();
            v5Spec = upgrader.upgrade(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, upgrader.getClass().toString(), upgradeSession.getConfiguration());
            v5Spec = this.propertyListAdjuster(v5Spec, v4Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5_property_list_adjusted", upgradeSession.getConfiguration());
            PageBreakTextOption pageBreakTextOption = new PageBreakTextOption();
            v5Spec = pageBreakTextOption.applyOption(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5AfterPageBreakTextOption", upgradeSession.getConfiguration());
            v5Spec = this.invalidVariableReferenceDetector(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5_invalidVariableReferences", upgradeSession.getConfiguration());
            UndefinedNameInExpression upgraderPipelineElement = new UndefinedNameInExpression(this.expressionLocale);
            v5Spec = upgraderPipelineElement.upgrade(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, upgraderPipelineElement.getClass().getName(), upgradeSession.getConfiguration());
            UnusedBrokenVariableRemover varRemover = new UnusedBrokenVariableRemover();
            v5Spec = varRemover.upgrade(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5AfterUnusedVariableRemoval", upgradeSession.getConfiguration());
            DuplicateRefVariableValueFixer fixer2 = new DuplicateRefVariableValueFixer();
            v5Spec = fixer2.upgrade(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5DuplicateRefVariableValue", upgradeSession.getConfiguration());
            v5Spec = this.removeInlineLayoutComponentReferences(v5Spec, upgradeSession);
            v5Spec = this.v5Postprocess(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5_postprocessing", upgradeSession.getConfiguration());
            return v5Spec;
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
    }

    private Document replaceFunctions(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        FunctionReplacement functionReplacer = new FunctionReplacement(this.expressionLocale);
        Document result = functionReplacer.upgradeFunctions(v4Spec, upgradeSession);
        return result;
    }

    private Document demultiplexVariables(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        VariableDemultiplexer demultiplexer = new VariableDemultiplexer(this.expressionLocale);
        Document result = demultiplexer.demultiplexVariables(v4Spec, upgradeSession);
        return result;
    }

    private Document aliasMap(Document v4Spec, AliasMap aliasMap, UpgradeSessionContext upgradeSession) throws UpgradeException {
        AliasMapping mapper = new AliasMapping(this.expressionLocale, upgradeSession.getConfiguration());
        Document result = mapper.mapDataItems(v4Spec, aliasMap, upgradeSession);
        return result;
    }

    protected Document generateV5Queries(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        BalticSharedQueryAnnotater annotater = new BalticSharedQueryAnnotater();
        v4Spec = annotater.upgrade(v4Spec, upgradeSession);
        String language = "en";
        Locale locale = upgradeSession.getTranslatedMessages().getLocale();
        if (locale != null) {
            language = locale.getLanguage();
        }
        Set<String> sharedQueries = this.extractSharedQueries(v4Spec);
        V4toV5QuerySet qsUpgrader = new V4toV5QuerySet();
        Document v5Queries = qsUpgrader.doConversionV4toV5(v4Spec, sharedQueries, language);
        XmlUtils.writeIntermediateDocument(v5Queries, "v5QueriesWithSharedResultSet", upgradeSession.getConfiguration());
        Element ret = XmlUtils.getFirstChildElementByName(v5Queries, "ret");
        if (ret == null) {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_QUERYSET_UPGRADE_FAILED("");
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v4Spec, 0, msg);
            return v4Spec;
        }
        this.logQueryFrameworkErrors(v4Spec, upgradeSession, ret);
        this.importV5Queries(v4Spec, ret);
        XmlUtils.writeIntermediateDocument(v4Spec, "v4_with_v5_queries", upgradeSession.getConfiguration());
        return v4Spec;
    }

    private Set<String> extractSharedQueries(Document v4Spec) {
        HashSet<String> sharedQueries = new HashSet<String>();
        if (v4Spec == null) {
            return sharedQueries;
        }
        Element report = XmlUtils.getFirstChildElementByName(v4Spec, "report");
        if (report == null) {
            return sharedQueries;
        }
        Element querySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        if (querySet == null) {
            return sharedQueries;
        }
        NodeList queryNodes = XmlUtils.getElementsWithAttribute(querySet, ReportSpecification50._shareResultSet);
        int nbQueries = queryNodes.getLength();
        for (int i = 0; i < nbQueries; ++i) {
            Element queryElement = (Element)queryNodes.item(i);
            String queryName = queryElement.getAttribute("name");
            sharedQueries.add(queryName);
            queryElement.removeAttribute(ReportSpecification50._shareResultSet);
        }
        return sharedQueries;
    }

    private void importV5Queries(Document v4Spec, Element retElement) throws DOMException {
        Node clonedQueries = v4Spec.importNode(retElement, true);
        Element report = this.getRootElement(v4Spec);
        report.appendChild(clonedQueries);
    }

    private void logQueryFrameworkErrors(Document v4Spec, UpgradeSessionContext upgradeSession, Element retElement) throws UpgradeException {
        Element exceptionsElement = XmlUtils.getFirstChildElementByName(retElement, "Exceptions");
        if (exceptionsElement != null) {
            NodeList exceptionNodeList = exceptionsElement.getElementsByTagName("Exception");
            int nbExceptions = exceptionNodeList.getLength();
            for (int i = 0; i < nbExceptions; ++i) {
                Element exception = (Element)exceptionNodeList.item(i);
                String exceptionText = XmlUtils.getText(exception);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v4Spec, 0, exceptionText);
            }
        }
    }

    private Document layoutComponentRefFixups(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        LayoutComponentRefFixups fixupHeuristics = new LayoutComponentRefFixups();
        v4Spec = fixupHeuristics.layoutComponentRefFixups(v4Spec, upgradeSession);
        return v4Spec;
    }

    private Document removeInvalidLayoutComponentRefs(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        InvalidLayoutComponentReferenceRemover refRemover = new InvalidLayoutComponentReferenceRemover();
        v5Spec = refRemover.fix(v5Spec, upgradeSession);
        return v5Spec;
    }

    private Document inlineLayoutComponentReferences(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        InlineLayoutComponentReferences inliner = new InlineLayoutComponentReferences();
        v5Spec = inliner.upgrade(v5Spec, upgradeSession);
        return v5Spec;
    }

    private Document removeInlineLayoutComponentReferences(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        RemoveInlineLayoutComponentReferences inliner = new RemoveInlineLayoutComponentReferences();
        v5Spec = inliner.upgrade(v5Spec, upgradeSession);
        return v5Spec;
    }

    private Document propertyListAdjuster(Document v5, Document v4, UpgradeSessionContext upgradeSession) throws UpgradeException, XmlException {
        PropertyListAdjuster adjuster = new PropertyListAdjuster(this.expressionLocale, v4);
        adjuster.adjustPropertyLists(v5, upgradeSession);
        return v5;
    }

    private Document v4Preprocess(Document v4In, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            Document v4Out = XslTransformerImpl.singleXsltTransformation(v4In, "RSUpgradeBaltic.xsl", upgradeSession.getConfiguration());
            return v4Out;
        }
        catch (Exception ex) {
            UpgradeException.throwNestedException(ex);
            throw new UpgradeException(ex);
        }
    }

    void addLogIdentifier(int logId, Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element v4ReportElement = XmlUtils.getFirstChildElementByName(v4Spec, "report");
        Element logIdentifierElement = v4Spec.createElement("logIdentifier");
        logIdentifierElement.setAttribute("logId", Integer.toString(logId));
        v4ReportElement.appendChild(logIdentifierElement);
        XmlUtils.writeIntermediateDocument(v4Spec, "v4_log_registered", upgradeSession.getConfiguration());
    }

    Document generateV5(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        int logId = LogMap.registerLog(upgradeSession.getLog());
        try {
            Document v5Spec;
            this.addLogIdentifier(logId, v4Spec, upgradeSession);
            BalticToBeringXsl xslUpgrader = new BalticToBeringXsl();
            Document document = v5Spec = xslUpgrader.upgrade(v4Spec, upgradeSession);
            return document;
        }
        catch (UpgradeException e) {
            throw e;
        }
        catch (Exception ex) {
            UpgradeException.throwNestedException(ex);
            throw new UpgradeException(ex);
        }
        finally {
            LogMap.deregisterLog(logId);
        }
    }

    private Document asOfTimeFixup(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        AsOfTimeAdjuster adjuster = new AsOfTimeAdjuster(this.expressionLocale);
        Document v5 = adjuster.upgrade(v5Spec, upgradeSession);
        return v5;
    }

    private Document crosstabFixup(Document v5Spec, Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException, XmlException {
        CrosstabSharedQueryFixup fixer = new CrosstabSharedQueryFixup();
        v5Spec = fixer.fixup(v5Spec);
        XmlUtils.writeIntermediateDocument(v5Spec, "v5_CrosstabSharedQueryFixup", upgradeSession.getConfiguration());
        CrosstabInvalidDrillParameterFixup fixer2 = new CrosstabInvalidDrillParameterFixup();
        v5Spec = fixer2.fixup(v5Spec, v4Spec, upgradeSession);
        XmlUtils.writeIntermediateDocument(v5Spec, "v5_CrosstabInvalidDrillParameterFixup", upgradeSession.getConfiguration());
        return v5Spec;
    }

    private Document danglingReferenceDetector(AliasMap aliasMap, Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        DanglingReferenceDetector fixer = new DanglingReferenceDetector(this.expressionLocale);
        Document v5 = fixer.fixup(aliasMap, v5Spec, upgradeSession);
        return v5;
    }

    private Document invalidVariableReferenceDetector(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        InvalidVariableReferenceDetector fixer = new InvalidVariableReferenceDetector();
        Document v5 = fixer.detectAndFix(v5Spec, upgradeSession);
        return v5;
    }

    private Document setSortOrder(Document bering, UpgradeSessionContext upgradeSession) throws UpgradeException {
        SetSortOrder upgrader = new SetSortOrder();
        bering = upgrader.upgrade(bering, upgradeSession);
        XmlUtils.writeIntermediateDocument(bering, "v5_setSortOrder", upgradeSession.getConfiguration());
        return bering;
    }

    private Document containerDataFormat(Document spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        DataFormatUpgrader upgrader = new DataFormatUpgrader(upgradeSession.getConfiguration());
        spec = upgrader.upgrade(spec, upgradeSession);
        XmlUtils.writeIntermediateDocument(spec, "v5_containerDataFormat", upgradeSession.getConfiguration());
        return spec;
    }

    private Document customChartLabelRemoval(Document spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            spec = XslTransformerImpl.singleXsltTransformation(spec, "RSUpgradeChartLabel.xsl", upgradeSession.getConfiguration());
        }
        catch (Exception ex) {
            UpgradeException.throwNestedException(ex);
        }
        return spec;
    }

    private Document v5Postprocess(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            v5Spec = XslTransformerImpl.singleXsltTransformation(v5Spec, "RSUpgradePostProcessing.xsl", upgradeSession.getConfiguration());
        }
        catch (Exception ex) {
            UpgradeException.throwNestedException(ex);
        }
        return v5Spec;
    }

    private Element getRootElement(Document doc) {
        return XmlUtils.getRoot(doc);
    }

    private Locale getExpressionLocale(Document v4, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Locale locale;
        Element report = XmlUtils.getRoot(v4);
        String langAttribute = report.getAttribute("xml:lang");
        if (langAttribute == null) {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_ATTRIBUTE_NOT_FOUND("xml:lang");
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)report, 1, msg);
            locale = Locale.ENGLISH;
        } else {
            String language = null;
            String country = "";
            if (langAttribute.length() <= 3) {
                language = langAttribute;
            } else {
                language = langAttribute.substring(0, 2);
                country = langAttribute.substring(3);
            }
            try {
                locale = new Locale(language, country);
            }
            catch (Exception ex) {
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_LOCALE_INVALID("xml:lang");
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)report, 1, msg);
                locale = Locale.ENGLISH;
            }
        }
        return locale;
    }
}

