/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._120to130;

import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification120;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WritingModeMove
implements UpgradePipelineElement {
    private static final String NS_PREFIX = "ns";
    private static final Pattern writingModeTbRlPattern = Pattern.compile("writing-mode:\\s*tb-rl\\s*[;]*", 34);
    private static final Pattern writingModePattern = Pattern.compile("writing-mode:", 34);

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        XPathFactory fc = XPathFactory.newInstance();
        XPath xp = fc.newXPath();
        xp.setNamespaceContext(new NSResolver());
        try {
            XPathExpression xpElementCSS = xp.compile("//ns:listColumnBody/ns:style/ns:CSS|//ns:listColumnTitle/ns:style/ns:CSS|//ns:rowCell/ns:style/ns:CSS|//ns:crosstabSpacer/ns:style/ns:CSS|//ns:crosstabNodeMember/ns:style/ns:CSS|//ns:crosstabFactCell/ns:style/ns:CSS|//ns:crosstabIntersections/ns:style/ns:CSS|//ns:crosstabCorner/ns:style/ns:CSS|//ns:repeaterTableCell/ns:style/ns:CSS|//ns:tableCell/ns:style/ns:CSS");
            XPathExpression xpTextItem = xp.compile("../../ns:contents/ns:textItem");
            XPathExpression xpStyle = xp.compile("./ns:style");
            XPathExpression xpCSS = xp.compile("./ns:CSS");
            XPathExpression xpChildren = xp.compile("./*");
            NodeList nodeList = (NodeList)xpElementCSS.evaluate(origSpec.getDocumentElement(), XPathConstants.NODESET);
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Matcher mc;
                Element cellCSS = (Element)nodeList.item(index);
                String value = cellCSS.getAttributeNS(null, ReportSpecification120._value);
                if (value == null || !(mc = writingModeTbRlPattern.matcher(value)).find()) continue;
                String newValue = mc.replaceAll("");
                NodeList contents = (NodeList)xpTextItem.evaluate(cellCSS, XPathConstants.NODESET);
                if (newValue.isEmpty() && cellCSS.getParentNode() != null) {
                    Element styleElem = (Element)cellCSS.getParentNode();
                    styleElem.removeChild(cellCSS);
                    NodeList children = (NodeList)xpChildren.evaluate(styleElem, XPathConstants.NODESET);
                    if (children.getLength() == 0 && styleElem.getParentNode() != null) {
                        styleElem.getParentNode().removeChild(styleElem);
                    }
                } else {
                    cellCSS.setAttributeNS(null, ReportSpecification120._value, newValue);
                }
                for (int nChild = 0; nChild < contents.getLength(); ++nChild) {
                    String cssValue;
                    Element css;
                    Element child = (Element)contents.item(nChild);
                    Element style = (Element)xpStyle.evaluate(child, XPathConstants.NODE);
                    if (style == null) {
                        style = origSpec.createElementNS(ReportSpecification120.targetNamespace, ReportSpecification120._style);
                        child.appendChild(style);
                    }
                    if ((css = (Element)xpCSS.evaluate(style, XPathConstants.NODE)) == null) {
                        css = origSpec.createElementNS(ReportSpecification120.targetNamespace, ReportSpecification120._CSS);
                        style.appendChild(css);
                    }
                    if ((cssValue = css.getAttributeNS(null, ReportSpecification120._value)) != null && !cssValue.isEmpty()) {
                        Matcher wm = writingModePattern.matcher(cssValue);
                        if (!wm.find()) {
                            cssValue = cssValue + ";writing-mode:tb-rl";
                        }
                    } else {
                        cssValue = "writing-mode:tb-rl";
                    }
                    css.setAttributeNS(null, ReportSpecification120._value, cssValue);
                }
            }
        }
        catch (XPathExpressionException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }

    private static class NSResolver
    implements NamespaceContext {
        private NSResolver() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return ReportSpecification120.targetNamespace;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return WritingModeMove.NS_PREFIX;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

