/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._13xto140;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification131;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification140;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConvertModQueryToQuery
implements UpgradePipelineElement {
    private static Set<String> sortListElements = new HashSet<String>();
    private static Set<String> sortListDataItemElements = new HashSet<String>();
    private UpgradeSessionContext upgradeSession = null;
    private Map<String, List<Element>> refQueryElements = null;

    private void convertModQueryToQuery(Element modQuery) throws UpgradeException, XmlException {
        Element query = this.convertModQuery(modQuery);
        this.convertMetadataPath(query, modQuery);
        this.convertModDataItems(query, modQuery);
        this.convertModFilters(query, modQuery);
        this.convertModDetailSortList(query, modQuery);
        this.convertXMLAttributes(query, modQuery);
        XmlUtils.delete(modQuery);
    }

    private Element convertModQuery(Element modQuery) {
        Element query = XmlUtils.createSiblingElement(modQuery, ReportSpecification140._query);
        XmlUtils.copyAttribute(ReportSpecification140._name, query, modQuery);
        if (XmlUtils.hasAttribute(modQuery, ReportSpecification131._autoSummary)) {
            Element selection = XmlUtils.createChildElement(query, ReportSpecification140._selection);
            XmlUtils.copyAttribute(ReportSpecification131._autoSummary, selection, modQuery);
        }
        return query;
    }

    private void convertMetadataPath(Element query, Element modQuery) {
        Element source = XmlUtils.createChildElement(query, ReportSpecification140._source);
        Element metadataPath = XmlUtils.getFirstChildElementByName(modQuery, ReportSpecification131._metadataPath);
        if (metadataPath != null) {
            source.appendChild(metadataPath);
            XmlUtils.addAttributeIfMissing(metadataPath, ReportSpecification140._type, ReportSpecification140._module);
        } else {
            XmlUtils.createChildElement(source, ReportSpecification140._model);
        }
    }

    private void convertModDataItems(Element query, Element modQuery) throws UpgradeException {
        Element modDataItems = XmlUtils.getFirstChildElementByName(modQuery, ReportSpecification131._modDataItems);
        if (modDataItems != null) {
            Element selection = XmlUtils.findOrAddChildElement(query, query.getNamespaceURI(), ReportSpecification140._selection);
            NodeList modDataItemList = null;
            modDataItemList = modDataItems.getElementsByTagName(ReportSpecification131._modDataItem);
            if (modDataItemList != null) {
                for (int i = 0; i < modDataItemList.getLength(); ++i) {
                    Element modDataItem = null;
                    modDataItem = (Element)modDataItemList.item(i);
                    if (modDataItem == null) continue;
                    this.convertModDataItem(selection, modDataItem);
                }
            }
        }
    }

    private void convertModDataItem(Element selection, Element modDataItem) throws UpgradeException {
        Element modDefinition = XmlUtils.getFirstChildElementByName(modDataItem, ReportSpecification131._modDefinition);
        if (modDefinition != null) {
            Element dataItem = null;
            Element definitionEle = XmlUtils.getChildElement(modDefinition);
            String definition = definitionEle.getTagName();
            if (ReportSpecification131._modMeasure.equals(definition)) {
                dataItem = XmlUtils.createChildElement(selection, ReportSpecification140._dataItem);
                XmlUtils.copyAttribute(ReportSpecification131._name, dataItem, modDataItem);
                this.convertXMLAttributes(dataItem, modDataItem);
                this.convertModMeasure(dataItem, definitionEle);
            } else if (ReportSpecification131._modListSummary.equals(definition)) {
                dataItem = XmlUtils.createChildElement(selection, ReportSpecification140._dataItemListSummary);
                XmlUtils.copyAttribute(ReportSpecification131._name, dataItem, modDataItem);
                this.convertXMLAttributes(dataItem, modDataItem);
                this.convertModListSummary(dataItem, definitionEle);
            } else if (ReportSpecification131._modEdgeSummary.equals(definition)) {
                dataItem = XmlUtils.createChildElement(selection, ReportSpecification140._dataItemEdgeSummary);
                XmlUtils.copyAttribute(ReportSpecification131._name, dataItem, modDataItem);
                this.convertXMLAttributes(dataItem, modDataItem);
                this.convertModEdgeSummary(dataItem, definitionEle);
            } else {
                dataItem = this.convertModSetDefinition(selection, definitionEle, modDataItem);
            }
        }
    }

    private Element convertModSetDefinition(Element selection, Element modSetDefinition, Element modDataItem) throws UpgradeException {
        Element dataItem = null;
        String modSetDefinitionTag = modSetDefinition.getTagName();
        if (ReportSpecification131._modAttribute.equals(modSetDefinitionTag)) {
            dataItem = XmlUtils.createChildElement(selection, ReportSpecification140._dataItem);
            XmlUtils.copyAttribute(ReportSpecification131._name, dataItem, modDataItem);
            this.convertXMLAttributes(dataItem, modDataItem);
            this.convertModAttribute(dataItem, modSetDefinition);
        } else if (ReportSpecification131._modSort.equals(modSetDefinitionTag)) {
            this.convertModSort(selection, modSetDefinition, modDataItem);
        } else {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_MODDATAITEM_IGNORED(modSetDefinitionTag);
            this.upgradeSession.getUpgradeNotes().addUpgradeNote(selection, 0, msg, true);
        }
        return dataItem;
    }

    private void convertModMeasure(Element dataItem, Element modMeasure) throws UpgradeException {
        String refModelItem = modMeasure.getAttribute(ReportSpecification131._refModelItem);
        Element expression = XmlUtils.createChildElement(dataItem, ReportSpecification140._expression);
        this.setRefModelItem(expression, refModelItem);
        this.convertRollup(dataItem, modMeasure, ReportSpecification131._detailRollup, ReportSpecification140._aggregate, ReportSpecification140._automatic);
        this.convertRollup(dataItem, modMeasure, ReportSpecification131._groupRollup, ReportSpecification140._rollupAggregate, ReportSpecification140._automatic);
    }

    private void setRefModelItem(Element expression, String modRefModelItem) {
        String[] parts = modRefModelItem.split("\\.");
        StringJoiner joiner = new StringJoiner("].[", "[", "]");
        for (String part : parts) {
            int start = 0;
            int end = part.length();
            if (part.charAt(0) == '[') {
                ++start;
            }
            if (part.charAt(end - 1) == ']') {
                --end;
            }
            if (start <= end) {
                part = part.substring(start, end);
            }
            joiner.add(part);
        }
        XmlUtils.setText(expression, joiner.toString());
    }

    private void convertModListSummary(Element dataItemListSummary, Element modListSummary) throws UpgradeException {
        String refDataItem = modListSummary.getAttribute(ReportSpecification131._refDataItem);
        XmlUtils.addAttributeIfMissing(dataItemListSummary, ReportSpecification140._refDataItem, refDataItem);
        this.convertRollup(dataItemListSummary, modListSummary, ReportSpecification131._groupRollup, ReportSpecification140._aggregateMethod, ReportSpecification140._aggregate, ReportSpecification131._aggregate);
    }

    private void convertModEdgeSummary(Element dataItemEdgeSummary, Element modEdgeSummary) throws UpgradeException {
        String refDataItem = modEdgeSummary.getAttribute(ReportSpecification131._refDataItem);
        XmlUtils.addAttributeIfMissing(dataItemEdgeSummary, ReportSpecification140._refDataItem, refDataItem);
        ArrayList<String> exclude = new ArrayList<String>();
        exclude.add(ReportSpecification131._calculated);
        exclude.add(ReportSpecification131._countDistinct);
        this.convertRollup(dataItemEdgeSummary, modEdgeSummary, ReportSpecification131._groupRollup, ReportSpecification140._aggregateMethod, ReportSpecification140._aggregate, ReportSpecification131._aggregate, exclude);
    }

    private void convertModAttribute(Element dataItem, Element modAttribute) throws UpgradeException {
        if (modAttribute.hasAttribute(ReportSpecification131._show)) {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_SHOW_IGNORED(dataItem.getAttribute(ReportSpecification140._name));
            this.upgradeSession.getUpgradeNotes().addUpgradeNote(dataItem, 0, msg, true);
        }
        String refModelItem = modAttribute.getAttribute(ReportSpecification131._refModelItem);
        Element expression = XmlUtils.createChildElement(dataItem, ReportSpecification140._expression);
        this.setRefModelItem(expression, refModelItem);
        dataItem.setAttribute(ReportSpecification140._rollupAggregate, ReportSpecification140._none);
        dataItem.setAttribute(ReportSpecification140._aggregate, ReportSpecification140._none);
    }

    private void convertModFilters(Element query, Element modQuery) throws UpgradeException {
        Element modFilters = XmlUtils.getFirstChildElementByName(modQuery, ReportSpecification131._modFilters);
        if (modFilters != null) {
            NodeList modFilterList = null;
            modFilterList = modFilters.getElementsByTagName(ReportSpecification131._modFilter);
            if (modFilterList != null) {
                for (int i = 0; i < modFilterList.getLength(); ++i) {
                    Element modFilter = null;
                    modFilter = (Element)modFilterList.item(i);
                    if (modFilter == null) continue;
                    this.convertModFilter(query, modFilter);
                }
            }
        }
    }

    private void convertModFilter(Element query, Element modFilter) throws UpgradeException {
        Element detailFilters = XmlUtils.findOrAddChildElement(query, query.getNamespaceURI(), ReportSpecification140._detailFilters);
        Element detailFilter = XmlUtils.createChildElement(detailFilters, ReportSpecification140._detailFilter);
        XmlUtils.copyAttributes(detailFilter, modFilter);
        String refDataItem = this.convertModFilterDefinition(detailFilter, modFilter, query);
        this.setPostAutoAggregation(detailFilter, query.getAttribute(ReportSpecification140._name), refDataItem);
        this.convertXMLAttributes(detailFilter, modFilter);
    }

    private void setPostAutoAggregation(Element detailFilter, String refQuery, String refDataItem) {
        Element report = detailFilter.getOwnerDocument().getDocumentElement();
        List<Element> elements = this.getRefQueryLayout(report).get(refQuery);
        detailFilter.setAttribute(ReportSpecification140._postAutoAggregation, this.findRefDataItem(elements, refDataItem) ? ReportSpecification140._true : ReportSpecification140._false);
    }

    private boolean findRefDataItem(List<Element> elements, String refDataItem) {
        if (refDataItem != null) {
            for (Element element : elements) {
                if (!this.findRefDataItem(element, refDataItem)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean findRefDataItem(Element element, String refDataItem) {
        Element child = XmlUtils.getFirstChildElement(element);
        while (child != null) {
            if (!child.hasAttribute(ReportSpecification140._refQuery) && this.findRefDataItem(child, refDataItem)) {
                return true;
            }
            if (refDataItem.equals(child.getAttribute(ReportSpecification140._refDataItem))) {
                return true;
            }
            child = XmlUtils.getNextSiblingElement(child);
        }
        return false;
    }

    private String convertModFilterDefinition(Element detailFilter, Element modFilter, Element query) throws UpgradeException {
        String refDataItem = null;
        Element filterDefinition = XmlUtils.createChildElement(detailFilter, ReportSpecification140._filterDefinition);
        Element modFilterDefinition = XmlUtils.getFirstChildElementByName(modFilter, ReportSpecification131._modFilterDefinition);
        Element definition = XmlUtils.getChildElement(modFilterDefinition);
        String definitionTag = definition.getTagName();
        if (ReportSpecification131._modFilterFacets.equals(definitionTag)) {
            refDataItem = this.convertModFilterFacets(filterDefinition, definition, query);
        } else if (ReportSpecification131._modFilterCompare.equals(definitionTag)) {
            refDataItem = this.convertModFilterCompare(filterDefinition, definition, query);
        } else if (ReportSpecification131._modFilterRange.equals(definitionTag)) {
            refDataItem = this.convertModFilterRange(filterDefinition, definition, query);
        } else if (ReportSpecification131._modFilterNulls.equals(definitionTag)) {
            refDataItem = this.convertModFilterNulls(filterDefinition, definition, query);
        } else {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_MODFILTER_IGNORED(definitionTag);
            this.upgradeSession.getUpgradeNotes().addUpgradeNote(query, 0, msg, true);
            detailFilter.removeChild(filterDefinition);
        }
        return refDataItem;
    }

    private String convertModFilterFacets(Element filterDefinition, Element modFilterFacets, Element query) throws UpgradeException {
        Element filterInValues = XmlUtils.createChildElement(filterDefinition, ReportSpecification140._filterInValues);
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(ReportSpecification140._refDataItem);
        attributes.add(ReportSpecification140._includeNulls);
        attributes.add(ReportSpecification140._parameterized);
        attributes.add(ReportSpecification140._parameterName);
        XmlUtils.copyAttributes(attributes, filterInValues, modFilterFacets);
        Attr out = modFilterFacets.getAttributeNode(ReportSpecification131._out);
        if (out != null && out.getSpecified()) {
            filterInValues.setAttribute(ReportSpecification140._not, out.getValue());
        }
        this.setDataType(filterInValues, query);
        this.convertModFacetValues(filterInValues, modFilterFacets);
        return filterInValues.getAttribute(ReportSpecification140._refDataItem);
    }

    private String convertModFilterCompare(Element filterDefinition, Element modFilterCompare, Element query) throws UpgradeException {
        String operator = modFilterCompare.getAttribute(ReportSpecification131._operator);
        if (ReportSpecification131._equal.equals(operator) || ReportSpecification131._notEqual.equals(operator)) {
            Element filterInValues = XmlUtils.createChildElement(filterDefinition, ReportSpecification140._filterInValues);
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add(ReportSpecification140._refDataItem);
            attributes.add(ReportSpecification140._includeNulls);
            attributes.add(ReportSpecification140._parameterized);
            attributes.add(ReportSpecification140._parameterName);
            XmlUtils.copyAttributes(attributes, filterInValues, modFilterCompare);
            if (ReportSpecification131._notEqual.equals(operator)) {
                filterInValues.setAttribute(ReportSpecification140._not, ReportSpecification140._true);
            }
            this.setDataType(filterInValues, query);
            Element modFilterValue = XmlUtils.getFirstChildElementByName(modFilterCompare, ReportSpecification131._modFilterValue);
            if (modFilterValue != null) {
                Element filterValues = XmlUtils.createChildElement(filterInValues, ReportSpecification140._filterValues);
                this.createFilterValue(filterValues, modFilterValue, ReportSpecification140._filterValue);
            }
            return filterInValues.getAttribute(ReportSpecification140._refDataItem);
        }
        Element filterCompare = XmlUtils.createChildElement(filterDefinition, ReportSpecification140._filterCompare);
        XmlUtils.copyAttributes(filterCompare, modFilterCompare);
        this.setDataType(filterCompare, query);
        this.convertModFilterValue(filterCompare, modFilterCompare);
        return filterCompare.getAttribute(ReportSpecification140._refDataItem);
    }

    private String convertModFilterRange(Element filterDefinition, Element modFilterRange, Element query) throws UpgradeException {
        Element filterRange = XmlUtils.createChildElement(filterDefinition, ReportSpecification140._filterRange);
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(ReportSpecification140._refDataItem);
        attributes.add(ReportSpecification140._includeNulls);
        attributes.add(ReportSpecification140._parameterized);
        attributes.add(ReportSpecification140._parameterName);
        XmlUtils.copyAttributes(attributes, filterRange, modFilterRange);
        Attr out = modFilterRange.getAttributeNode(ReportSpecification131._out);
        if (out != null && out.getSpecified()) {
            filterRange.setAttribute(ReportSpecification140._not, out.getValue());
        }
        this.setDataType(filterRange, query);
        this.createFilterValue(filterRange, XmlUtils.getFirstChildElementByName(modFilterRange, ReportSpecification131._modFilterFrom), ReportSpecification140._filterFrom);
        this.createFilterValue(filterRange, XmlUtils.getFirstChildElementByName(modFilterRange, ReportSpecification131._modFilterTo), ReportSpecification140._filterTo);
        return filterRange.getAttribute(ReportSpecification140._refDataItem);
    }

    private String convertModFilterNulls(Element filterDefinition, Element modFilterNulls, Element query) throws UpgradeException {
        Element filterNulls = XmlUtils.createChildElement(filterDefinition, ReportSpecification140._filterNulls);
        XmlUtils.copyAttribute(ReportSpecification140._refDataItem, filterNulls, modFilterNulls);
        Attr out = modFilterNulls.getAttributeNode(ReportSpecification131._out);
        if (out != null && out.getSpecified()) {
            filterNulls.setAttribute(ReportSpecification140._not, out.getValue());
        }
        this.setDataType(filterNulls, query);
        return filterNulls.getAttribute(ReportSpecification140._refDataItem);
    }

    private void convertModFacetValues(Element filterInValues, Element modFilterFacets) {
        Element modFacetValues = XmlUtils.getFirstChildElementByName(modFilterFacets, ReportSpecification131._modFacetValues);
        if (modFacetValues != null) {
            Element filterValues = XmlUtils.createChildElement(filterInValues, ReportSpecification140._filterValues);
            NodeList modFacetValueList = null;
            modFacetValueList = modFacetValues.getElementsByTagName(ReportSpecification131._modFacetValue);
            if (modFacetValueList != null) {
                for (int i = 0; i < modFacetValueList.getLength(); ++i) {
                    Element modFacetValue = null;
                    modFacetValue = (Element)modFacetValueList.item(i);
                    if (modFacetValue == null) continue;
                    this.createFilterValue(filterValues, modFacetValue, ReportSpecification140._filterValue);
                }
            }
        }
    }

    private void convertModFilterValue(Element filterCompare, Element modFilterCompare) {
        Element modFilterValue = XmlUtils.getFirstChildElementByName(modFilterCompare, ReportSpecification131._modFilterValue);
        if (modFilterValue != null) {
            this.createFilterValue(filterCompare, modFilterValue, ReportSpecification140._filterValue);
        }
    }

    private void createFilterValue(Element filterCompare, Element modFilterValue, String filterValueTag) {
        if (modFilterValue != null) {
            Element filterValue = XmlUtils.createChildElement(filterCompare, filterValueTag);
            XmlUtils.setText(filterValue, XmlUtils.getText(modFilterValue));
        }
    }

    private void setDataType(Element filterNode, Element query) throws UpgradeException {
        Element xmlAttribute;
        Element xmlAttributes;
        String dataType = null;
        String refDataItem = filterNode.getAttribute(ReportSpecification140._refDataItem);
        Element selection = XmlUtils.getFirstChildElementByName(query, ReportSpecification140._selection);
        Element dataItem = XmlUtils.getFirstChildElementByNameWithAttributeValue(selection, ReportSpecification140._dataItem, ReportSpecification131._name, refDataItem);
        if (dataItem != null && (xmlAttributes = XmlUtils.getFirstChildElementByName(dataItem, ReportSpecification131._XMLAttributes)) != null && (xmlAttribute = XmlUtils.getFirstChildElementByNameWithAttributeValue(xmlAttributes, ReportSpecification131._XMLAttribute, ReportSpecification131._name, "RS_dataType")) != null) {
            String value = xmlAttribute.getAttribute(ReportSpecification131._value);
            int type = -1;
            try {
                type = Integer.parseInt(value);
            }
            catch (NumberFormatException n) {
                type = -1;
            }
            switch (type) {
                case 0: {
                    dataType = "Unsupported";
                    break;
                }
                case 1: {
                    dataType = "integer";
                    break;
                }
                case 2: {
                    dataType = "decimal";
                    break;
                }
                case 3: {
                    dataType = "string";
                    break;
                }
                case 4: {
                    dataType = "dateTime";
                    break;
                }
                case 5: {
                    dataType = "interval";
                    break;
                }
                case 6: {
                    dataType = "Unsupported";
                    break;
                }
                case 7: {
                    dataType = "date";
                    break;
                }
                case 8: {
                    dataType = "time";
                    break;
                }
                case 9: {
                    dataType = "float";
                    break;
                }
            }
        }
        if (dataType == null) {
            dataType = "string";
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DATATYPE_ATTRIBUTE_CREATED();
            this.upgradeSession.getUpgradeNotes().addUpgradeNote(filterNode, 0, msg, true);
        }
        filterNode.setAttribute(ReportSpecification140._dataType, dataType);
    }

    private void convertModDetailSortList(Element query, Element modQuery) throws UpgradeException {
        Element modDetailSortList = XmlUtils.getFirstChildElementByName(modQuery, ReportSpecification131._modDetailSortList);
        if (modDetailSortList != null) {
            NodeList modDetailSorts = null;
            modDetailSorts = modDetailSortList.getElementsByTagName(ReportSpecification131._modDetailSort);
            if (modDetailSorts != null) {
                for (int i = 0; i < modDetailSorts.getLength(); ++i) {
                    Element modDetailSort = null;
                    modDetailSort = (Element)modDetailSorts.item(i);
                    if (modDetailSort == null) continue;
                    this.convertModDetailSort(query, modDetailSort);
                }
            }
        }
    }

    private void convertModSort(Element selection, Element modSort, Element modDataItem) throws UpgradeException {
        RspecUpgradeMessage msg;
        Element modSortBy;
        Element modBaseSet = XmlUtils.getFirstChildElementByName(modSort, ReportSpecification131._modBaseSet);
        Element child = XmlUtils.getChildElement(modBaseSet);
        Element dataItem = this.convertModSetDefinition(selection, child, modDataItem);
        if (dataItem != null) {
            String refDataItem = dataItem.getAttribute(ReportSpecification140._name);
            Element query = (Element)dataItem.getParentNode().getParentNode();
            String refQuery = query.getAttribute(ReportSpecification140._name);
            String sortOrder = null;
            Attr ascending = modSort.getAttributeNode(ReportSpecification131._ascending);
            if (ascending != null && ascending.getSpecified()) {
                sortOrder = ReportSpecification131._true.equals(ascending.getValue()) ? ReportSpecification140._ascending : ReportSpecification140._descending;
            }
            this.createSortItems(dataItem.getOwnerDocument(), refQuery, refDataItem, sortOrder);
        }
        if ((modSortBy = XmlUtils.getFirstChildElementByName(modSort, ReportSpecification131._modSortBy)) != null) {
            msg = RspecUpgradeMessage.RSU_SPC_MODSORTBY_IGNORED(modDataItem.getAttribute(ReportSpecification131._name));
            this.upgradeSession.getUpgradeNotes().addUpgradeNote(dataItem != null ? dataItem : selection, 0, msg, true);
        }
        if (modSort.hasAttribute(ReportSpecification131._nullPosition)) {
            msg = RspecUpgradeMessage.RSU_SPC_NULLPOSITION_IGNORED(modDataItem.getAttribute(ReportSpecification131._name));
            this.upgradeSession.getUpgradeNotes().addUpgradeNote(dataItem != null ? dataItem : selection, 0, msg, true);
        }
    }

    private void convertModDetailSort(Element query, Element modDetailSort) throws UpgradeException {
        String refDataItem = modDetailSort.getAttribute(ReportSpecification131._refDataItem);
        String refQuery = query.getAttribute(ReportSpecification131._name);
        String sortOrder = null;
        Attr ascending = modDetailSort.getAttributeNode(ReportSpecification131._ascending);
        if (ascending != null && ascending.getSpecified()) {
            sortOrder = ReportSpecification131._true.equals(ascending.getValue()) ? ReportSpecification140._ascending : ReportSpecification140._descending;
        }
        this.createSortItems(modDetailSort.getOwnerDocument(), refQuery, refDataItem, sortOrder);
        if (modDetailSort.hasAttribute(ReportSpecification131._nullPosition)) {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DETAIL_NULLPOSITION_IGNORED(refQuery);
            this.upgradeSession.getUpgradeNotes().addUpgradeNote(query, 0, msg, true);
        }
    }

    private void createSortItems(Document document, String refQuery, String refDataItem, String sortOrder) throws UpgradeException {
        Element report = document.getDocumentElement();
        BoolRef refDataItemFound = new BoolRef();
        List<Element> elements = this.getRefQueryLayout(report).get(refQuery);
        for (Element element : elements) {
            refDataItemFound.bool = false;
            if (this.createSortItem(element, refDataItem, sortOrder, refDataItemFound)) continue;
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_SORT_SKIPPED(refQuery, refDataItem);
            this.upgradeSession.getUpgradeNotes().addUpgradeNote(report, 0, msg, true);
        }
    }

    private boolean createSortItem(Element element, String refDataItem, String sortOrder, BoolRef refDataItemFound) {
        String elementTag;
        boolean sortAdded = false;
        Element child = XmlUtils.getFirstChildElement(element);
        while (child != null && !sortAdded) {
            if (!child.hasAttribute(ReportSpecification140._refQuery)) {
                sortAdded = this.createSortItem(child, refDataItem, sortOrder, refDataItemFound);
            }
            if (refDataItem.equals(child.getAttribute(ReportSpecification140._refDataItem))) {
                refDataItemFound.bool = true;
            }
            child = XmlUtils.getNextSiblingElement(child);
        }
        if (!sortAdded && (sortListDataItemElements.contains(elementTag = element.getTagName()) && refDataItem.equals(element.getAttribute(ReportSpecification140._refDataItem)) || sortListElements.contains(elementTag) && refDataItemFound.bool)) {
            this.addSort(element, refDataItem, sortOrder);
            sortAdded = true;
        }
        return sortAdded;
    }

    private void addSort(Element element, String refDataItem, String sortOrder) {
        Element sortList = XmlUtils.findOrAddChildElement(element, element.getNamespaceURI(), ReportSpecification140._sortList);
        Element sortItem = XmlUtils.createChildElement(sortList, ReportSpecification140._sortItem);
        sortItem.setAttribute(ReportSpecification140._refDataItem, refDataItem);
        if (sortOrder != null) {
            sortItem.setAttribute(ReportSpecification140._sortOrder, sortOrder);
        }
    }

    private Map<String, List<Element>> getRefQueryLayout(Element report) {
        if (this.refQueryElements == null) {
            this.populateRefQueryLayout(report);
        }
        return this.refQueryElements;
    }

    private void populateRefQueryLayout(Element report) {
        this.refQueryElements = new HashMap<String, List<Element>>();
        this.populateRefQueryLayoutChildren(report);
    }

    private void populateRefQueryLayoutChildren(Element parent) {
        Element element = XmlUtils.getFirstChildElement(parent);
        while (element != null) {
            String refQuery = element.getAttribute(ReportSpecification131._refQuery);
            if (refQuery.length() > 0) {
                List<Element> elements = this.refQueryElements.get(refQuery);
                if (elements == null) {
                    elements = new ArrayList<Element>();
                    this.refQueryElements.put(refQuery, elements);
                }
                elements.add(element);
            }
            this.populateRefQueryLayoutChildren(element);
            element = XmlUtils.getNextSiblingElement(element);
        }
    }

    private void convertRollup(Element dataItem, Element modMeasure, String rollup, String newRollup, String defaultValue) throws UpgradeException {
        this.convertRollup(dataItem, modMeasure, rollup, newRollup, defaultValue, null, null);
    }

    private void convertRollup(Element dataItem, Element modMeasure, String rollup, String newRollup, String defaultValue, String required) throws UpgradeException {
        this.convertRollup(dataItem, modMeasure, rollup, newRollup, defaultValue, required, null);
    }

    private void convertRollup(Element dataItem, Element modMeasure, String rollup, String newRollup, String defaultValue, String required, List<String> exclude) throws UpgradeException {
        String rollupValue = modMeasure.getAttribute(rollup);
        if (required != null && (rollupValue == null || rollupValue.length() == 0)) {
            rollupValue = required;
        }
        if (rollupValue != null && rollupValue.length() > 0) {
            if (exclude != null && exclude.indexOf(rollupValue) != -1) {
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_GROUPROLLUP_IGNORED(rollupValue);
                this.upgradeSession.getUpgradeNotes().addUpgradeNote(dataItem, 1, msg, true);
            } else {
                if (rollupValue.equals(ReportSpecification131._default)) {
                    rollupValue = defaultValue;
                }
                XmlUtils.addAttributeIfMissing(dataItem, newRollup, rollupValue);
            }
        }
    }

    private void convertXMLAttributes(Element target, Element source) {
        Element xmlAttributes = XmlUtils.getFirstChildElementByName(source, ReportSpecification131._XMLAttributes);
        if (xmlAttributes != null) {
            target.appendChild(xmlAttributes);
        }
    }

    private void convertModQueriesToQueries(Document reportSpec) throws UpgradeException, XmlException {
        if (reportSpec == null) {
            throw new UpgradeInternalErrorException("reportSpec document should not be null.");
        }
        Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification131._report);
        Element queries = null;
        NodeList modQueryList = null;
        if (report != null && (queries = XmlUtils.getFirstChildElementByName(report, ReportSpecification131._queries)) != null && (modQueryList = queries.getElementsByTagName(ReportSpecification131._modQuery)) != null) {
            int modQueryCount = modQueryList.getLength();
            while (modQueryCount > 0) {
                Element modQuery = (Element)modQueryList.item(0);
                this.convertModQueryToQuery(modQuery);
                int newModQueryCount = modQueryList.getLength();
                if (newModQueryCount == modQueryCount) break;
                modQueryCount = newModQueryCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document upgrade(Document reportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            this.upgradeSession = upgradeSession;
            this.convertModQueriesToQueries(reportSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        finally {
            this.upgradeSession = null;
            this.refQueryElements = null;
        }
        return reportSpec;
    }

    static {
        sortListElements.add(ReportSpecification140._appDataDropDownList);
        sortListElements.add(ReportSpecification140._appDataListBox);
        sortListElements.add(ReportSpecification140._appDataDeck);
        sortListElements.add(ReportSpecification140._appDataTabControl);
        sortListElements.add(ReportSpecification140._appDataButtonBar);
        sortListElements.add(ReportSpecification140._appDataToggleButtonBar);
        sortListElements.add(ReportSpecification140._appDataRadioButtonGroup);
        sortListElements.add(ReportSpecification140._appDataCheckboxGroup);
        sortListElements.add(ReportSpecification140._appDataIterator);
        sortListElements.add(ReportSpecification140._appDataDiscreteSlider);
        sortListElements.add(ReportSpecification140._pageSet);
        sortListElements.add(ReportSpecification140._list);
        sortListElements.add(ReportSpecification140._repeaterTable);
        sortListElements.add(ReportSpecification140._repeater);
        sortListElements.add(ReportSpecification140._dataStoreListQuery);
        sortListElements.add(ReportSpecification140._selectValue);
        sortListElements.add(ReportSpecification140._selectWithSearch);
        sortListElements.add(ReportSpecification140._selectWithTree);
        sortListDataItemElements.add(ReportSpecification140._chartNodeMember);
        sortListDataItemElements.add(ReportSpecification140._repeaterGroup);
        sortListDataItemElements.add(ReportSpecification140._pageGroup);
        sortListDataItemElements.add(ReportSpecification140._listGroup);
        sortListDataItemElements.add(ReportSpecification140._burstGroup);
        sortListDataItemElements.add(ReportSpecification140._appListCategoryDataItem);
        sortListDataItemElements.add(ReportSpecification140._crosstabNodeMember);
        sortListDataItemElements.add(ReportSpecification140._dataStoreLevelItem);
        sortListDataItemElements.add(ReportSpecification140._customControlCategoryDataItem);
        sortListDataItemElements.add(ReportSpecification140._vizCategoryDataItem);
    }

    private static class BoolRef {
        public boolean bool;

        private BoolRef() {
        }
    }
}

