/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._20to30;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification30;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import com.qfw.V4toV5.IntraBeringMunConversion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ChangeMuns
implements UpgradePipelineElement {
    IntraBeringMunConversion munConverter = new IntraBeringMunConversion();

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext context) throws UpgradeException {
        NodeList expressions = origSpec.getElementsByTagName(ReportSpecification30._defaultTreeSelection);
        int nbExpressions = expressions.getLength();
        for (int i = 0; i < nbExpressions; ++i) {
            Element expressionElement = (Element)expressions.item(i);
            this.fixExpression(expressionElement, origSpec);
        }
        return origSpec;
    }

    private void fixExpression(Element expressionElement, Document doc) throws UpgradeException {
        try {
            String strOldMun = XmlUtils.getText(expressionElement);
            String strNewMun = this.munConverter.doMUNConversion(strOldMun);
            if (!strOldMun.equals(strNewMun)) {
                XmlUtils.removeChildren(expressionElement);
                Text child = doc.createTextNode(strNewMun);
                expressionElement.appendChild(child);
            }
        }
        catch (Exception e) {
            UpgradeException.throwNestedException(e);
        }
    }
}

