/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._20to30;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.io.XslTransformerImpl;
import com.cognos.rspecupgrade.internal.xml.NamespaceChanger;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.BeringAugmented;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20NovRtm;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import com.qfw.V4toV5.IntraBeringUpgrade;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Upgrade20NovRtmToRtm
implements UpgradePipelineElement {
    private void assertNamespaceIsBeringNovRtm(Document reportSpec) throws UpgradeInternalErrorException {
        Element root = reportSpec.getDocumentElement();
        String actualNamespace = root.getNamespaceURI();
        if (!ReportSpecification20NovRtm.targetNamespace.equals(actualNamespace)) {
            throw new UpgradeInternalErrorException("Report namespace was not Bering Nov RTM as expected but " + actualNamespace);
        }
    }

    @Override
    public Document upgrade(Document v5Spec, UpgradeSessionContext context) throws UpgradeException {
        this.assertNamespaceIsBeringNovRtm(v5Spec);
        v5Spec = this.doUpgrade(v5Spec, context);
        return v5Spec;
    }

    private Document updateQueries(Document oldQuerySetDoc, UpgradeSessionContext upgradeSession) {
        IntraBeringUpgrade qfwUpgrader = new IntraBeringUpgrade();
        Document newQuerySetDoc = qfwUpgrader.doConversionV5(oldQuerySetDoc);
        XmlUtils.writeIntermediateDocument(newQuerySetDoc, "newqueryset", upgradeSession.getConfiguration());
        return newQuerySetDoc;
    }

    private Document changeNamespaceToBering(Document v5Spec) throws UpgradeException {
        NamespaceChanger changer = new NamespaceChanger(ReportSpecification20NovRtm.targetNamespace, ReportSpecification20.targetNamespace);
        return changer.upgrade(v5Spec);
    }

    public Document doUpgrade(Document v5Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element currentReport = XmlUtils.getRoot(v5Spec = this.changeNamespaceToBering(v5Spec));
        Element currentQueries = XmlUtils.getFirstChildElementByName(currentReport, BeringAugmented._queries);
        if (currentQueries == null) {
            return v5Spec;
        }
        Element currentQuery = XmlUtils.getFirstChildElementByName(currentQueries, BeringAugmented._query);
        if (currentQuery == null) {
            return v5Spec;
        }
        try {
            Document annotatedReport = this.annotateLayout(v5Spec, upgradeSession);
            XmlUtils.writeIntermediateDocument(annotatedReport, "annotatedReportLayout", upgradeSession.getConfiguration());
            Document oldQuerySetDoc = this.getQuerySet(annotatedReport, upgradeSession);
            XmlUtils.writeIntermediateDocument(oldQuerySetDoc, "oldqueryset", upgradeSession.getConfiguration());
            Document newQuerySetDoc = null;
            newQuerySetDoc = this.updateQueries(oldQuerySetDoc, upgradeSession);
            NodeList exceptions = newQuerySetDoc.getElementsByTagName("Exception");
            int nbExceptions = exceptions.getLength();
            if (nbExceptions > 0) {
                for (int exceptionNb = 0; exceptionNb < nbExceptions; ++exceptionNb) {
                    Element exception = (Element)exceptions.item(exceptionNb);
                    String exceptionText = XmlUtils.getText(exception);
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_QUERYSET_UPGRADE_FAILED(exceptionText);
                    Element root = XmlUtils.getRoot(v5Spec);
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)root, 0, message);
                }
                return v5Spec;
            }
            Element ret = XmlUtils.getRoot(newQuerySetDoc);
            Element newQuerySet = XmlUtils.getFirstChildElementByName(ret, "querySet");
            Element report = XmlUtils.getRoot(annotatedReport);
            Element oldQueries = XmlUtils.getFirstChildElementByName(report, BeringAugmented._queries);
            Element newQueries = XmlUtils.getFirstChildElementByName(newQuerySet, BeringAugmented._queries);
            newQueries = (Element)annotatedReport.importNode(newQueries, true);
            report.replaceChild(newQueries, oldQueries);
            Element newQRD = XmlUtils.getFirstChildElementByName(newQuerySet, "queryResultDefinitions");
            newQRD = (Element)annotatedReport.importNode(newQRD, true);
            report.appendChild(newQRD);
            XmlUtils.writeIntermediateDocument(annotatedReport, "v5AfterQueryReplacement", upgradeSession.getConfiguration());
            v5Spec = this.upgradeLayout(annotatedReport, upgradeSession);
            XmlUtils.writeIntermediateDocument(v5Spec, "v5AfterLayoutUpgrade", upgradeSession.getConfiguration());
        }
        catch (Exception ex) {
            UpgradeException.throwNestedException(ex);
        }
        return v5Spec;
    }

    private Document annotateLayout(Document v5Spec, UpgradeSessionContext upgradeSession) throws Exception {
        Document annotatedReport = XslTransformerImpl.singleXsltTransformation(v5Spec, "RSUpgradeAnnotateLayout.xsl", upgradeSession.getConfiguration());
        return annotatedReport;
    }

    private Document getQuerySet(Document v5Spec, UpgradeSessionContext upgradeSession) throws Exception {
        Document qrd = XslTransformerImpl.singleXsltTransformation(v5Spec, "RSUpgradeResultSetSqueleton.xsl", upgradeSession.getConfiguration());
        XmlUtils.writeIntermediateDocument(qrd, "v5_queryset", upgradeSession.getConfiguration());
        return qrd;
    }

    private Document upgradeLayout(Document annotatedReport, UpgradeSessionContext upgradeSession) throws Exception {
        Document upgradedReport = XslTransformerImpl.singleXsltTransformation(annotatedReport, "RSUpgradeV5Layout.xsl", upgradeSession.getConfiguration());
        return upgradedReport;
    }
}

