/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._30to40;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification30;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CrosstabIndentation
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            Element layouts = PathWalker.getC8LayoutsElement(origSpec);
            if (layouts == null) {
                return origSpec;
            }
            CrosstabIndentationExaminer examiner = new CrosstabIndentationExaminer(upgradeSession);
            DomWalker.bottomUpWalkElements(layouts, examiner);
        }
        catch (XmlException ex) {
            UpgradeException.throwNestedException(ex);
        }
        return origSpec;
    }

    private static class CrosstabIndentationExaminer
    implements DomWalker.Examiner {
        private static Pattern indentationLengthPattern = null;
        private UpgradeSessionContext upgradeSession;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CrosstabIndentationExaminer(UpgradeSessionContext upgradeSession) throws UpgradeException {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (indentationLengthPattern == null) {
                    indentationLengthPattern = Pattern.compile("\\s*(([^\\p{Lower}\\p{Upper}]+))((\\p{Lower}|\\p{Upper})+)\\s*");
                }
            }
            this.upgradeSession = upgradeSession;
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String elemName = XmlUtils.getName(elem);
            if (elemName.equals(ReportSpecification40._crosstabNodeMember)) {
                boolean hasIndentationLength = elem.hasAttribute(ReportSpecification30._indentationLength);
                boolean hasStartLevel = elem.hasAttribute(ReportSpecification30._indentationStartLevel);
                if (hasIndentationLength || hasStartLevel) {
                    Element indentation = XmlUtils.getOrCreateChildElementByName(elem, ReportSpecification40._indentation);
                    if (!indentation.hasAttribute(ReportSpecification40._type)) {
                        indentation.setAttribute(ReportSpecification40._type, ReportSpecification40._level);
                    }
                    if (hasStartLevel) {
                        String startLevel = elem.getAttribute(ReportSpecification30._indentationStartLevel);
                        try {
                            this.safeSetAttribute(indentation, ReportSpecification40._startLevel, startLevel);
                        }
                        catch (UpgradeException e) {
                            XmlException.throwNestedException(e);
                        }
                        elem.removeAttribute(ReportSpecification30._indentationStartLevel);
                    }
                    if (hasIndentationLength) {
                        String indentationLength = elem.getAttribute(ReportSpecification30._indentationLength);
                        Matcher matcher = indentationLengthPattern.matcher(indentationLength);
                        if (!matcher.matches()) {
                            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_BLARING_INDENTATION_LENGTH_NOT_PARSED(indentationLength);
                            try {
                                this.upgradeSession.getUpgradeNotes().addUpgradeNote(elem, 1, msg, true);
                            }
                            catch (UpgradeException e) {
                                XmlException.throwNestedException(e);
                            }
                        } else {
                            String length = matcher.group(1);
                            String units = matcher.groupCount() < 3 ? "px" : matcher.group(3);
                            try {
                                this.safeSetAttribute(indentation, ReportSpecification40._indentationUnits, units);
                                this.safeSetAttribute(indentation, ReportSpecification40._indentationLength, length);
                            }
                            catch (UpgradeException e) {
                                XmlException.throwNestedException(e);
                            }
                            elem.removeAttribute(ReportSpecification30._indentationLength);
                        }
                    }
                }
            }
            return DomWalker.SearchOrder.proceed;
        }

        private void safeSetAttribute(Element destElem, String attributeName, String newValue) throws UpgradeException {
            if (!destElem.hasAttribute(attributeName)) {
                destElem.setAttribute(attributeName, newValue);
            } else {
                String oldValue = destElem.getAttribute(attributeName);
                if (!newValue.equals(oldValue)) {
                    RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_INDENTATION_ELEMENT_ALREADY_HAS_ATTRIBUTE(attributeName, newValue, oldValue);
                    this.upgradeSession.getUpgradeNotes().addUpgradeNote(destElem, 1, msg, true);
                }
            }
        }
    }
}

