/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._30to40;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RefQueryCheck
implements UpgradePipelineElement {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            RefQueryExaminer examiner = new RefQueryExaminer(origSpec, upgradeSession);
            DomWalker.topDownWalkElements(XmlUtils.getRoot(origSpec), examiner);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        XmlUtils.writeIntermediateDocument(origSpec, "RefQueryCheck", upgradeSession.getConfiguration());
        return origSpec;
    }

    private class RefQueryExaminer
    implements DomWalker.Examiner {
        private Set<String> queryNames;
        private final Document reportSpecification;
        private UpgradeSessionContext upgradeSession;

        RefQueryExaminer(Document aReportSpecification, UpgradeSessionContext upgradeSession) {
            this.upgradeSession = upgradeSession;
            this.reportSpecification = aReportSpecification;
            this.queryNames = this.getQueryNames();
        }

        private void createDummyQuery(Element elem, String queryName) throws UpgradeException {
            Element createdQuery = this.createQuery(queryName);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_REFQUERY_CREATE_QUERY(queryName);
            this.upgradeSession.getUpgradeNotes().addUpgradeNote((Node)createdQuery, 1, message);
            String translatedMessage = this.upgradeSession.getTranslatedMessages().getString(message);
            XmlUtils.insertComment(elem, translatedMessage);
            XmlUtils.insertComment(createdQuery, translatedMessage);
        }

        private void removeRefQuery(Element elem, String queryName) throws UpgradeException {
            elem.removeAttribute(ReportSpecification40._refQuery);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_REFQUERY_REMOVED_QUERY_NONEXISTENT(queryName);
            this.upgradeSession.getUpgradeNotes().addUpgradeNote((Node)elem, 1, message);
        }

        private void fixupMissingQuery(Element elem, String queryName) throws UpgradeException {
            String name = XmlUtils.getName(elem);
            if (name.equals(ReportSpecification40._selectValue)) {
                this.removeRefQuery(elem, queryName);
            } else {
                this.createDummyQuery(elem, queryName);
            }
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            try {
                Object queryName;
                if (elem.hasAttribute(ReportSpecification40._refQuery) && !this.queryNames.contains(queryName = elem.getAttribute(ReportSpecification40._refQuery))) {
                    this.fixupMissingQuery(elem, (String)queryName);
                }
                queryName = DomWalker.SearchOrder.proceed;
                return queryName;
            }
            catch (UpgradeException e) {
                throw new XmlException(e);
            }
        }

        private Set<String> getQueryNames() {
            Element queries;
            HashSet<String> queryNames = new HashSet<String>();
            Element report = XmlUtils.getFirstChildElementByName(this.reportSpecification, ReportSpecification40._report);
            if (report != null && (queries = XmlUtils.getFirstChildElementByName(report, ReportSpecification40._queries)) != null) {
                NodeList queryList = XmlUtils.getChildElementsByName(queries, ReportSpecification40._query);
                int nbQueries = queryList.getLength();
                for (int i = 0; i < nbQueries; ++i) {
                    Element query = (Element)queryList.item(i);
                    if (!query.hasAttribute(ReportSpecification40._name)) continue;
                    String name = query.getAttribute(ReportSpecification40._name);
                    queryNames.add(name);
                }
            }
            return queryNames;
        }

        private Element getOrCreateQueriesElement() {
            Element report = XmlUtils.getFirstChildElementByName(this.reportSpecification, ReportSpecification40._report);
            Element queries = XmlUtils.getOrCreateChildElementByName(report, ReportSpecification40._queries);
            return queries;
        }

        private Element createQuery(String queryName) {
            this.queryNames.add(queryName);
            Element queries = this.getOrCreateQueriesElement();
            Element query = XmlUtils.createChildElement(queries, ReportSpecification40._query);
            query.setAttribute(ReportSpecification40._name, queryName);
            return query;
        }
    }
}

