/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._40to50;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Cognos8FillEffectsUpgrader
implements UpgradePipelineElement {
    private void copyOptionalAttribute(Element fromElem, String fromAttr, Element toElem, String toAttr) {
        if (fromElem.hasAttribute(fromAttr)) {
            String color = fromElem.getAttribute(fromAttr);
            toElem.setAttribute(toAttr, color);
        }
    }

    private void copyOptionalAttribute(Element fromElem, String attrName, Element toElem) {
        this.copyOptionalAttribute(fromElem, attrName, toElem, attrName);
    }

    private Element findOrAddStyleElement(Element fillEffects) {
        Element parentOfFillEffects = (Element)fillEffects.getParentNode();
        String namespace = parentOfFillEffects.getNamespaceURI();
        Element style = XmlUtils.findOrAddChildElement(parentOfFillEffects, namespace, ReportSpecification20._style);
        return style;
    }

    private Element findOrAddGeneratedBackgroundElement(Element style) {
        Element generatedBackground = XmlUtils.findOrAddChildElement(style, style.getNamespaceURI(), ReportSpecification50._generatedBackground);
        return generatedBackground;
    }

    private Element findOrAddFillElement(Element generatedBackground) {
        Element fill = XmlUtils.findOrAddChildElement(generatedBackground, generatedBackground.getNamespaceURI(), ReportSpecification50._fill);
        return fill;
    }

    private Element upgradeChartColor(Element chartColor) {
        Element fillColor = XmlUtils.createElement(chartColor.getOwnerDocument(), ReportSpecification50._fillColor);
        this.copyOptionalAttribute(chartColor, ReportSpecification20._value, fillColor, ReportSpecification50._color);
        return fillColor;
    }

    private String getGradientAngle(String direction) throws UpgradeException {
        String gradientAngle;
        if (direction.equals(ReportSpecification20._right)) {
            gradientAngle = "0";
        } else if (direction.equals(ReportSpecification20._up)) {
            gradientAngle = "90";
        } else if (direction.equals(ReportSpecification20._left)) {
            gradientAngle = "180";
        } else if (direction.equals(ReportSpecification20._down)) {
            gradientAngle = "270";
        } else {
            throw new UpgradeInternalErrorException("Internal Error: unexpected value '" + direction + "' for parameter 'direction'.");
        }
        return gradientAngle;
    }

    private Element createLinearGradient(Element chartGradient) throws UpgradeException {
        Element linearGradient = XmlUtils.createElement(chartGradient.getOwnerDocument(), ReportSpecification50._linearGradient);
        if (chartGradient.hasAttribute(ReportSpecification20._direction)) {
            String direction = chartGradient.getAttribute(ReportSpecification20._direction);
            String gradientAngle = this.getGradientAngle(direction);
            linearGradient.setAttribute(ReportSpecification50._gradientAngle, gradientAngle);
        }
        return linearGradient;
    }

    private Element addGradientColor(Element linearGradient, String position) {
        Element gradientColor = XmlUtils.createChildElement(linearGradient, ReportSpecification50._gradientColor);
        gradientColor.setAttribute(ReportSpecification50._colorPosition, position);
        return gradientColor;
    }

    private void addGradientColors(Element chartGradient, Element linearGradient) {
        Element fromGradientColor = this.addGradientColor(linearGradient, "0");
        this.copyOptionalAttribute(chartGradient, ReportSpecification20._fromColor, fromGradientColor, ReportSpecification50._gradientColor);
        Element toGradientColor = this.addGradientColor(linearGradient, "100");
        this.copyOptionalAttribute(chartGradient, ReportSpecification20._toColor, toGradientColor, ReportSpecification50._gradientColor);
    }

    private Element upgradeChartGradient(Element chartGradient) throws UpgradeException {
        Element linearGradient = this.createLinearGradient(chartGradient);
        this.addGradientColors(chartGradient, linearGradient);
        return linearGradient;
    }

    private Element upgradeChartPattern(Element chartPattern) {
        Element pattern = XmlUtils.createElement(chartPattern.getOwnerDocument(), ReportSpecification50._pattern);
        this.copyOptionalAttribute(chartPattern, ReportSpecification20._foregroundColor, pattern);
        this.copyOptionalAttribute(chartPattern, ReportSpecification20._backgroundColor, pattern);
        this.copyOptionalAttribute(chartPattern, ReportSpecification20._patternType, pattern);
        return pattern;
    }

    private Vector<Element> getFillEffectsElementsToUpgrade(Document reportSpec) throws UpgradeException {
        Element layouts;
        Vector<Element> fillEffectsElements = new Vector<Element>();
        try {
            layouts = PathWalker.getC8LayoutsElement(reportSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        if (layouts == null) {
            return fillEffectsElements;
        }
        FillEffectsExaminer examiner = new FillEffectsExaminer(fillEffectsElements);
        try {
            DomWalker.topDownWalkElements(layouts, examiner);
        }
        catch (XmlException ex) {
            throw new UpgradeException(ex);
        }
        return fillEffectsElements;
    }

    private void upgradeSingleFillEffects(Element fillEffects) throws UpgradeException {
        Element upgradedFillType;
        Element fillType = XmlUtils.getChildElement(fillEffects);
        String fillTypeName = XmlUtils.getName(fillType);
        if (fillTypeName.equals(ReportSpecification20._chartColor)) {
            upgradedFillType = this.upgradeChartColor(fillType);
        } else if (fillTypeName.equals(ReportSpecification20._chartGradient)) {
            upgradedFillType = this.upgradeChartGradient(fillType);
        } else if (fillTypeName.equals(ReportSpecification20._chartPattern)) {
            upgradedFillType = this.upgradeChartPattern(fillType);
        } else {
            throw new UpgradeInternalErrorException("Internal Error: unexpected element '" + fillTypeName + "' as a child of 'fillEffects'.");
        }
        Element style = this.findOrAddStyleElement(fillEffects);
        Element generatedBackground = this.findOrAddGeneratedBackgroundElement(style);
        Element fill = this.findOrAddFillElement(generatedBackground);
        if (XmlUtils.getChildElement(fill) != null) {
            return;
        }
        fill.appendChild(upgradedFillType);
        XmlUtils.delete(fillEffects);
    }

    private void upgradeAllFillEffects(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Vector<Element> fillEffectsElements = this.getFillEffectsElementsToUpgrade(origSpec);
        int nbElements = fillEffectsElements.size();
        for (int i = 0; i < nbElements; ++i) {
            Element fillEffects = fillEffectsElements.get(i);
            this.upgradeSingleFillEffects(fillEffects);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (upgradeSession.getConfiguration().getEnableWorkOrder2628()) {
            this.upgradeAllFillEffects(origSpec, upgradeSession);
            XmlUtils.writeIntermediateDocument(origSpec, "chart_fillEffects", upgradeSession.getConfiguration());
        }
        return origSpec;
    }

    private class FillEffectsExaminer
    implements DomWalker.Examiner {
        Vector<Element> fillEffectsElements;

        public FillEffectsExaminer(Vector<Element> elements) {
            this.fillEffectsElements = elements;
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            String elementName = XmlUtils.getName(elem);
            if (!elementName.equals(ReportSpecification20._fillEffects)) {
                return DomWalker.SearchOrder.proceed;
            }
            Element parent = XmlUtils.getParentElement(elem);
            String parentName = XmlUtils.getName(parent);
            if (parentName.endsWith("Chart")) {
                this.fillEffectsElements.add(elem);
                return DomWalker.SearchOrder.siblingsOnly;
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

