/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification70;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ChangeLayoutAttributeToMeetNewConstraints
implements UpgradePipelineElement {
    private final String elementName;
    private final String attributeName;
    private SchemaModel schemaModel;
    private UpgradeSessionContext upgradeSession;

    ChangeLayoutAttributeToMeetNewConstraints(String anElementName, String anAttributeName) {
        this.elementName = anElementName;
        this.attributeName = anAttributeName;
    }

    ChangeLayoutAttributeToMeetNewConstraints(String anAttributeName) {
        this.attributeName = anAttributeName;
        this.elementName = null;
    }

    private void changeAttributeToLegalValue(Attr attr, String legalValue) throws UpgradeException {
        String oldValue = attr.getValue();
        RspecUpgradeMessage msgText = RspecUpgradeMessage.RSU_SPC_ATTRIBUTE_CHANGED_TO_MEET_NEW_CONSTRAINTS(XmlUtils.getName(attr), oldValue, legalValue);
        this.upgradeSession.getUpgradeNotes().addUpgradeNote((Node)attr, 2, msgText);
        attr.setNodeValue(legalValue);
    }

    private void checkAttribute(Attr attr) throws UpgradeException {
        try {
            ContentModel contentModel = this.schemaModel.getDefiningModel(attr);
            SimpleType type = (SimpleType)contentModel.getType();
            String oldText = attr.getValue();
            String newText = type.verifyAndFix(oldText);
            if (oldText != newText) {
                this.changeAttributeToLegalValue(attr, newText);
            }
        }
        catch (SchemaException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void checkAttribute(Element elem) throws UpgradeException {
        Attr attr = elem.getAttributeNode(this.attributeName);
        if (attr != null) {
            this.checkAttribute(attr);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext anUpgradeSession) throws UpgradeException {
        this.schemaModel = anUpgradeSession.getReportSpecificationSchemaModel(ReportSpecification70.targetNamespace);
        if (this.schemaModel == null) {
            throw new UpgradeInternalErrorException("Unable to find schema model");
        }
        this.upgradeSession = anUpgradeSession;
        try {
            Element layouts = PathWalker.getC8LayoutsElement(origSpec);
            if (layouts == null) {
                return origSpec;
            }
            Examiner examiner = new Examiner();
            DomWalker.topDownWalkElements(layouts, examiner);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }

    private class Examiner
    implements DomWalker.Examiner {
        private Examiner() {
        }

        private boolean isElementToBeChecked(Element elem) {
            if (ChangeLayoutAttributeToMeetNewConstraints.this.elementName == null) {
                return true;
            }
            String tagName = XmlUtils.getName(elem);
            return ChangeLayoutAttributeToMeetNewConstraints.this.elementName.equals(tagName);
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            if (this.isElementToBeChecked(elem)) {
                try {
                    ChangeLayoutAttributeToMeetNewConstraints.this.checkAttribute(elem);
                }
                catch (UpgradeException e) {
                    XmlException.throwNestedException(e);
                }
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

