/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutTool;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification70;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.IUpgradeNotes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CrosstabColumnRepeatEveryPageRemover
implements UpgradePipelineElement {
    private void removeAttribute(Attr repeatEveryPage, UpgradeSessionContext upgradeSession) throws UpgradeException {
        RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CROSSTABCOLUMN_REPEATEVERYPAGE_REMOVED();
        IUpgradeNotes upgradeNotes = upgradeSession.getUpgradeNotes();
        upgradeNotes.addUpgradeNote((Node)repeatEveryPage, 2, message);
        XmlCommentOutTool commentOutTool = upgradeSession.getXmlCommentOutTool();
        try {
            commentOutTool.commentOutNode((Node)repeatEveryPage, message);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void fixNodeMember(Element crosstabNodeMember, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Attr attr = crosstabNodeMember.getAttributeNode(ReportSpecification70._repeatEveryPage);
        if (attr != null) {
            this.removeAttribute(attr, upgradeSession);
        }
    }

    private void fixNodeMembers(Element crosstabNodeMembers, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList nodeMemberList = XmlUtils.getChildElementsByName(crosstabNodeMembers, ReportSpecification70._crosstabNodeMember);
        int nbNodeMemeber = nodeMemberList.getLength();
        for (int i = 0; i < nbNodeMemeber; ++i) {
            Element nodeMember = (Element)nodeMemberList.item(i);
            this.fixNodeMember(nodeMember, upgradeSession);
        }
    }

    private void fixNestedNodes(Element crosstabNestedNodes, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.fixCrosstabNodeListType(crosstabNestedNodes, upgradeSession);
    }

    private void fixCrosstabNodeMemberChildren(Element crosstabNode, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList nodeMembersList = XmlUtils.getChildElementsByName(crosstabNode, ReportSpecification70._crosstabNodeMembers);
        int nbNodeMemebers = nodeMembersList.getLength();
        for (int i = 0; i < nbNodeMemebers; ++i) {
            Element nodeMembers = (Element)nodeMembersList.item(i);
            this.fixNodeMembers(nodeMembers, upgradeSession);
        }
    }

    private void fixCrosstabNestedNodesChildren(Element crosstabNode, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList nestedNodesList = XmlUtils.getChildElementsByName(crosstabNode, ReportSpecification70._crosstabNestedNodes);
        int nbNestedNodes = nestedNodesList.getLength();
        for (int i = 0; i < nbNestedNodes; ++i) {
            Element nestedNodes = (Element)nestedNodesList.item(i);
            this.fixNestedNodes(nestedNodes, upgradeSession);
        }
    }

    private void fixCrosstabNode(Element crosstabNode, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.fixCrosstabNodeMemberChildren(crosstabNode, upgradeSession);
        this.fixCrosstabNestedNodesChildren(crosstabNode, upgradeSession);
    }

    private void fixCrosstabNodeListType(Element crosstabNodeListContainer, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList nodeList = XmlUtils.getChildElementsByName(crosstabNodeListContainer, ReportSpecification70._crosstabNode);
        int nbNodes = nodeList.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Element node = (Element)nodeList.item(i);
            this.fixCrosstabNode(node, upgradeSession);
        }
    }

    private void fixColumn(Element crosstabColumn, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.fixCrosstabNodeListType(crosstabColumn, upgradeSession);
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList crosstabColumnsList = origSpec.getElementsByTagName(ReportSpecification70._crosstabColumns);
        int nbCrosstabColumns = crosstabColumnsList.getLength();
        for (int i = 0; i < nbCrosstabColumns; ++i) {
            Element crosstabColumn = (Element)crosstabColumnsList.item(i);
            this.fixColumn(crosstabColumn, upgradeSession);
        }
        return origSpec;
    }
}

