/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._60to70;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification70;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.IUpgradeNotes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MandatoryRefQuery
implements UpgradePipelineElement {
    private UpgradeSessionContext upgradeSessionContext;

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layouts;
        this.upgradeSessionContext = upgradeSession;
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeInternalErrorException();
        }
        SetRefQuery examiner = new SetRefQuery();
        try {
            DomWalker.topDownWalkElements(layouts, examiner);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return origSpec;
    }

    private class SetRefQuery
    implements DomWalker.Examiner {
        private SetRefQuery() {
        }

        private void logQueryNotFound(Element scopedElement) throws UpgradeException {
            IUpgradeNotes notes = MandatoryRefQuery.this.upgradeSessionContext.getUpgradeNotes();
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_QUERY_SCOPE_NOT_FOUND_FOR_ELEMENT(XmlUtils.getName(scopedElement));
            notes.addUpgradeNote((Node)scopedElement, 0, msg);
        }

        private boolean elementNeedsRefQuery(Element elem) {
            String[] needsQuery = new String[]{ReportSpecification70._threeDComboBaseline, ReportSpecification70._threeDScatterBaseline, ReportSpecification70._pointSizeLegendTitle, ReportSpecification70._pointColorLegendTitle, ReportSpecification70._regionColorLegendTitle, ReportSpecification70._noteContent, ReportSpecification70._pointChartMarker, ReportSpecification70._marker, ReportSpecification70._legendTitle, ReportSpecification70._chartTitle, ReportSpecification70._chartSubTitle, ReportSpecification70._chartFooter, ReportSpecification70._axisTitle, ReportSpecification70._baseline, ReportSpecification70._pointChartBaseline};
            String name = XmlUtils.getName(elem);
            for (int i = 0; i < needsQuery.length; ++i) {
                if (!name.equals(needsQuery[i])) continue;
                return true;
            }
            return false;
        }

        private String getRefQuery(Element scopedElement) throws UpgradeException {
            String dummyQuery = "";
            Element scopingElement = scopedElement;
            while (scopingElement != null && !scopingElement.hasAttribute(ReportSpecification70._refQuery)) {
                scopingElement = XmlUtils.getParentElement(scopingElement);
            }
            if (scopingElement == null) {
                this.logQueryNotFound(scopedElement);
                return "";
            }
            return scopingElement.getAttribute(ReportSpecification70._refQuery);
        }

        private void setRefQuery(Element elem) throws UpgradeException {
            String refQuery = this.getRefQuery(elem);
            elem.setAttribute(ReportSpecification70._refQuery, refQuery);
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            if (this.elementNeedsRefQuery(elem) && !elem.hasAttribute(ReportSpecification70._refQuery)) {
                try {
                    this.setRefQuery(elem);
                }
                catch (UpgradeException e) {
                    XmlException.throwNestedException(e);
                }
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

