/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._minorUpgrade;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.NamespaceChanger;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessagesImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.SchemaVersionUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import com.cognos.rspecupgrade.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MinorNamespaceChange
implements UpgradePipelineElement {
    private String lastCompatibleNamespace = null;
    private String destinationNamespace = null;

    public MinorNamespaceChange(String lastCompatibleNamespace, String destinationNamespace) {
        this.lastCompatibleNamespace = lastCompatibleNamespace;
        this.destinationNamespace = destinationNamespace;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element root = XmlUtils.getRoot(origSpec);
        String origNamespace = root.getNamespaceURI();
        if (Utils.hasString(this.lastCompatibleNamespace) && Utils.hasString(this.destinationNamespace) && SchemaVersionUtils.isCompatibleNamespace(this.lastCompatibleNamespace, origNamespace)) {
            NamespaceChanger changer = new NamespaceChanger(origNamespace, this.destinationNamespace);
            return changer.upgrade(origSpec, upgradeSession);
        }
        MessagesImpl msgs = new MessagesImpl();
        String msg = msgs.getString(RspecUpgradeMessage.RSU_SPC_INTERNAL_ERROR_SEE_ADMIN());
        throw new UpgradeException(msg);
    }
}

