/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification60;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DrillTargetPrompt
implements UpgradePipelineElement {
    private void fixDrillTarget(Element drillTarget) {
        if (drillTarget.hasAttribute(ReportSpecification60._prompt)) {
            return;
        }
        Element drillLink = XmlUtils.getFirstChildElementByName(drillTarget, ReportSpecification60._drillLink);
        if (drillLink == null) {
            drillTarget.setAttribute(ReportSpecification60._prompt, ReportSpecification60._yes);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element root = XmlUtils.getRoot(origSpec);
        String reportNamespace = root.getNamespaceURI();
        NodeList drillTargets = origSpec.getElementsByTagNameNS(reportNamespace, ReportSpecification20._drillTarget);
        int nbTargets = drillTargets.getLength();
        for (int targetNb = 0; targetNb < nbTargets; ++targetNb) {
            this.fixDrillTarget((Element)drillTargets.item(targetNb));
        }
        return origSpec;
    }
}

