/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LayoutNameGenerator
implements UpgradePipelineElement {
    private HashSet<String> namesSet;

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Document result = this.generate(origSpec, upgradeSession);
        XmlUtils.writeIntermediateDocument(result, "v5AfterLayoutNameGeneration", upgradeSession.getConfiguration());
        return result;
    }

    private Document generate(Document v5Spec, UpgradeSessionContext upgradeSession) {
        Element reportElement = XmlUtils.getFirstChildElementByName(v5Spec, ReportSpecification20._report);
        Element layoutsElement = XmlUtils.getFirstChildElementByName(reportElement, ReportSpecification20._layouts);
        if (layoutsElement == null) {
            return v5Spec;
        }
        this.namesSet = new HashSet();
        this.extractElementNames(layoutsElement);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._list, RspecUpgradeMessage.RSU_NM_list(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._crosstab, RspecUpgradeMessage.RSU_NM_crosstab(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._repeaterTable, RspecUpgradeMessage.RSU_NM_repeaterTable(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._repeater, RspecUpgradeMessage.RSU_NM_repeater(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._pieChart, RspecUpgradeMessage.RSU_NM_pieChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._paretoChart, RspecUpgradeMessage.RSU_NM_paretoChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._scatterChart, RspecUpgradeMessage.RSU_NM_scatterChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._polarChart, RspecUpgradeMessage.RSU_NM_polarChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._radarChart, RspecUpgradeMessage.RSU_NM_radarChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._progressiveChart, RspecUpgradeMessage.RSU_NM_progressiveChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._combinationChart, RspecUpgradeMessage.RSU_NM_combinationChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._bubbleChart, RspecUpgradeMessage.RSU_NM_bubbleChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._threeDCombinationChart, RspecUpgradeMessage.RSU_NM_threeDCombinationChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._threeDScatterChart, RspecUpgradeMessage.RSU_NM_threeDScatterChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._gaugeChart, RspecUpgradeMessage.RSU_NM_gaugeChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._mapChart, RspecUpgradeMessage.RSU_NM_mapChart(), upgradeSession);
        this.generateNamesForElementTag(layoutsElement, ReportSpecification20._metricsChart, RspecUpgradeMessage.RSU_NM_metricsChart(), upgradeSession);
        return v5Spec;
    }

    private void extractElementNames(Element anElement) {
        String elementName = anElement.getAttribute(ReportSpecification20._name);
        if (elementName.length() > 0) {
            this.namesSet.add(elementName);
        }
        NodeList childrenNodes = XmlUtils.getChildElements(anElement);
        int nbChildren = childrenNodes.getLength();
        for (int i = 0; i < nbChildren; ++i) {
            Element childElement = (Element)childrenNodes.item(i);
            this.extractElementNames(childElement);
        }
    }

    private void generateNamesForElementTag(Element layoutsElement, String elementTag, MessageTemplate msgTemplate, UpgradeSessionContext upgradeSession) {
        String baseName = upgradeSession.getTranslatedMessages().getString(msgTemplate);
        NodeList elementList = layoutsElement.getElementsByTagName(elementTag);
        int nbElements = elementList.getLength();
        for (int i = 0; i < nbElements; ++i) {
            Element theElement = (Element)elementList.item(i);
            if (theElement.getAttributeNode(ReportSpecification20._name) != null) {
                this.namesSet.add(theElement.getAttribute(ReportSpecification20._name));
                continue;
            }
            String newName = this.makeNewName(this.namesSet, baseName);
            theElement.setAttribute(ReportSpecification20._name, newName);
            this.namesSet.add(newName);
        }
    }

    private String makeNewName(HashSet<String> nameSet, String baseName) {
        StringBuffer newName = null;
        int i = 0;
        do {
            newName = new StringBuffer(baseName);
            newName.append(++i);
        } while (nameSet.contains(newName.toString()));
        return newName.toString();
    }
}

