/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RemoveOldMessages
implements UpgradePipelineElement {
    private void logMessage(Element messageElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Log log = upgradeSession.getLog();
        String level = messageElement.getAttribute(ReportSpecification20._type);
        String text = XmlUtils.getText(messageElement);
        if (level.equals(ReportSpecification20._info)) {
            log.info(RspecUpgradeMessage.RSU_SPC_INFO_OLD(text));
        } else if (level.equals(ReportSpecification20._warning)) {
            log.warning(RspecUpgradeMessage.RSU_SPC_WARNING_OLD(text));
        } else {
            log.error(RspecUpgradeMessage.RSU_SPC_ERROR_OLD(text));
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getRoot(origSpec);
        if (report == null) {
            return origSpec;
        }
        Element upgradeInfo = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._upgradeInfo);
        if (upgradeInfo == null) {
            return origSpec;
        }
        Element upgradeMessages = XmlUtils.getFirstChildElementByName(upgradeInfo, ReportSpecification20._upgradeMessages);
        if (upgradeMessages == null) {
            return origSpec;
        }
        NodeList messages = upgradeInfo.getElementsByTagName(ReportSpecification20._upgradeMessage);
        if (messages == null) {
            return origSpec;
        }
        int nbMessages = messages.getLength();
        if (nbMessages == 0) {
            return origSpec;
        }
        for (int i = 0; i < nbMessages; ++i) {
            this.logMessage((Element)messages.item(i), upgradeSession);
        }
        XmlUtils.delete(upgradeMessages);
        return origSpec;
    }
}

