/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.expressionrewriter;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.util.Locale;
import org.w3c.dom.Node;

abstract class ExpressionRewriterFramework {
    protected ExpressionRewriterFramework() {
    }

    protected abstract IExpression parse(String var1, Locale var2);

    private void logError(String expression, Node location, UpgradeSessionContext upgradeSession) throws UpgradeException {
        RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_TEST_EXPRESSION_REWRITING_FAILED(expression);
        upgradeSession.getUpgradeNotes().addUpgradeNote(location, 0, msg);
    }

    protected String rewriteExpression(String oldExpression, Locale locale, Node location, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            IExpression expressionTree = this.parse(oldExpression, locale);
            if (expressionTree == null) {
                this.logError(oldExpression, location, upgradeSession);
                return oldExpression;
            }
            expressionTree = expressionTree.optimize();
            this.fragmentCheck(expressionTree, oldExpression, location, upgradeSession);
            expressionTree.getSubExpressions();
            String newExpression = expressionTree.toString(locale);
            IExpression newExpressionTree = this.parse(newExpression, locale);
            if (newExpressionTree == null) {
                this.logError(oldExpression, location, upgradeSession);
                return oldExpression;
            }
            if (!(newExpressionTree = newExpressionTree.optimize()).equals(expressionTree)) {
                this.logError(oldExpression, location, upgradeSession);
                return oldExpression;
            }
            return newExpression;
        }
        catch (Throwable t) {
            this.logError(oldExpression, location, upgradeSession);
            return oldExpression;
        }
    }

    private void fragmentCheck(IExpressionFragment exp, String expression, Node location, UpgradeSessionContext upgradeSession) throws UpgradeException {
        int nbExpressions = exp.getNbSubExpressions();
        for (int i = 0; i < nbExpressions; ++i) {
            IExpressionFragment frag = exp.getSubExpression(i);
            exp.setSubExpression(i, frag);
            IExpressionFragment frag2 = exp.getSubExpression(i);
            if (frag != frag2) {
                this.logError(expression, location, upgradeSession);
            }
            this.fragmentCheck(frag, expression, location, upgradeSession);
        }
    }
}

