/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.expressionrewriter;

import com.cognos.rspecupgrade.internal.expressionparser.cqe.CqeParser;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.expressionrewriter.ExpressionRewriterFramework;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.ExpressionLocale;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class QueryExpressionRewriter
extends ExpressionRewriterFramework
implements UpgradePipelineElement {
    private Document rewriteQueryExpressions(Document v5Spec, Locale locale, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getRoot(v5Spec);
        if (report == null) {
            return null;
        }
        Element queries = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._queries);
        if (queries == null) {
            return v5Spec;
        }
        NodeList expressions = queries.getElementsByTagName(ReportSpecification20._expression);
        int nbExpressions = expressions.getLength();
        for (int expressionNb = 0; expressionNb < nbExpressions; ++expressionNb) {
            Element expression = (Element)expressions.item(expressionNb);
            String oldExpression = XmlUtils.getText(expression);
            String newExpression = this.rewriteExpression(oldExpression, locale, expression, upgradeSession);
            XmlUtils.setText(expression, newExpression);
        }
        return v5Spec;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Locale expressionLocale = ExpressionLocale.getExpressionLocale(origSpec, upgradeSession);
        this.rewriteQueryExpressions(origSpec, expressionLocale, upgradeSession);
        return origSpec;
    }

    @Override
    protected IExpression parse(String expression, Locale locale) {
        IExpression expressionTree;
        CqeParser parser = new CqeParser(new StringReader(expression), locale);
        try {
            expressionTree = parser.start();
        }
        catch (Throwable ex) {
            expressionTree = null;
        }
        return expressionTree;
    }
}

