/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.format;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.format.FormatPatternUpgrader;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.ExpressionLocale;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Cognos8FormatPatternUpgrader
implements UpgradePipelineElement {
    private final String sourceNamespace;
    private final String targetNamespace;

    public Cognos8FormatPatternUpgrader(String theSourceNamespace, String theTargetNamespace) {
        this.sourceNamespace = theSourceNamespace;
        this.targetNamespace = theTargetNamespace;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.upgradeFormatPatterns(origSpec, upgradeSession);
        XmlUtils.writeIntermediateDocument(origSpec, "localized_format_patterns", upgradeSession.getConfiguration());
        return origSpec;
    }

    private void upgradeFormatPatterns(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(origSpec, ReportSpecification20._report);
        if (report == null) {
            return;
        }
        String reportLocale = ExpressionLocale.getExpressionLocaleString(origSpec, upgradeSession);
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        if (layouts == null) {
            return;
        }
        FormatPatternUpgrader upgrader = new FormatPatternUpgrader(this.targetNamespace, upgradeSession.getConfiguration(), upgradeSession.getTranslatedMessages());
        upgrader.upgradeFormatPatterns(layouts, reportLocale, this.sourceNamespace);
    }
}

