/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.format;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.format.LocalizedPatternChars;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

class FormatPatternUpgrader {
    private IConfiguration config = null;
    private Messages messages = null;
    HashSet<String> formatElementNames = null;
    String sourceReportCurrentLocalePatternChars = null;
    String targetReportCurrentLocalePatternChars = null;
    private final String targetNamespace;

    public FormatPatternUpgrader(String theTargetNamespace, IConfiguration theConfig, Messages theMessages) {
        this.targetNamespace = theTargetNamespace;
        this.config = theConfig;
        this.messages = theMessages;
        this.initializeFormatElementNames();
    }

    public void upgradeFormatPatterns(Element startElement, String reportLocale, String reportSpecificationNamespace) throws UpgradeException {
        this.initializeLocalizedFormatPatternChars(reportSpecificationNamespace, reportLocale);
        if (this.targetReportCurrentLocalePatternChars.startsWith(this.sourceReportCurrentLocalePatternChars)) {
            return;
        }
        FormatExaminer examiner = new FormatExaminer();
        try {
            DomWalker.topDownWalkElements(startElement, examiner);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void initializeFormatElementNames() {
        this.formatElementNames = new HashSet();
        this.formatElementNames.add(ReportSpecification40._currencyFormat);
        this.formatElementNames.add(ReportSpecification40._dateFormat);
        this.formatElementNames.add(ReportSpecification40._dateTimeFormat);
        this.formatElementNames.add(ReportSpecification40._format);
        this.formatElementNames.add(ReportSpecification40._intervalFormat);
        this.formatElementNames.add(ReportSpecification40._numberFormat);
        this.formatElementNames.add(ReportSpecification40._percentFormat);
        this.formatElementNames.add(ReportSpecification40._stringFormat);
        this.formatElementNames.add(ReportSpecification40._timeFormat);
    }

    private void initializeLocalizedFormatPatternChars(String sourceReportNamespace, String reportLocale) throws UpgradeException {
        LocalizedPatternChars sourceAllLocalesPatternChars = new LocalizedPatternChars(this.config, this.messages, sourceReportNamespace);
        LocalizedPatternChars targetAllLocalesPatternChars = new LocalizedPatternChars(this.config, this.messages, this.targetNamespace);
        this.sourceReportCurrentLocalePatternChars = sourceAllLocalesPatternChars.getPatternCharsForLocale(reportLocale);
        this.targetReportCurrentLocalePatternChars = targetAllLocalesPatternChars.getPatternCharsForLocale(reportLocale);
    }

    class FormatExaminer
    implements DomWalker.Examiner {
        FormatExaminer() {
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            boolean hasPattern;
            String elemName = XmlUtils.getName(elem);
            if (FormatPatternUpgrader.this.formatElementNames.contains(elemName) && (hasPattern = elem.hasAttribute(ReportSpecification40._pattern))) {
                String pattern = elem.getAttribute(ReportSpecification40._pattern);
                String newPattern = StringUtils.replaceChars((String)pattern, (String)FormatPatternUpgrader.this.sourceReportCurrentLocalePatternChars, (String)FormatPatternUpgrader.this.targetReportCurrentLocalePatternChars);
                elem.setAttribute(ReportSpecification40._pattern, newPattern);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

