/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlChecksumGeneratorImpl;
import com.cognos.rspecupgrade.internal.xml.XmlChecksumUtils;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.UntranslatedMessages;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;

public class AddChecksum
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Messages messages = upgradeSession.getTranslatedMessages();
        if (messages == null) {
            messages = new UntranslatedMessages();
        }
        XmlChecksumGeneratorImpl generator = new XmlChecksumGeneratorImpl();
        String checksum = null;
        try {
            if (origSpec == null) {
                throw new Exception(messages.getString(RspecUpgradeMessage.RSU_CHK_XMLDOC_IS_NULL()));
            }
            SchemaModel schema = XmlUtils.getSchema(origSpec, messages);
            checksum = generator.generateChecksum(origSpec, messages, schema);
            XmlChecksumUtils.removeChecksumNode(origSpec, messages);
            if (checksum != null) {
                String prefix = XmlChecksumUtils.getChecksumPrefix();
                XmlChecksumUtils.appendChecksumNode(origSpec, prefix.concat(checksum), messages);
            }
        }
        catch (Exception e) {
            throw new UpgradeException(e);
        }
        return origSpec;
    }
}

