/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Message;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.OutputReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import java.io.StringWriter;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AddMessages {
    private static String[] severityMap = new String[3];

    public static Document addOriginalReport(Document v5Spec, Messages messages, Document origDoc) throws UpgradeException {
        if (v5Spec == null) {
            throw new NullPointerException("v5 spec may not be null");
        }
        Element upgradeInfo = AddMessages.getOrCreateUpgradeInfoElement(v5Spec, messages.getLocale());
        v5Spec = upgradeInfo.getOwnerDocument();
        Element upgradedSpec = AddMessages.getOrCreateChild(upgradeInfo, OutputReportSpecification.targetNamespace, ReportSpecification40._upgradedSpec);
        StringWriter writer = new StringWriter();
        try {
            XmlUtils.writeDocument(writer, (Node)origDoc);
            while (upgradedSpec.getFirstChild() != null) {
                upgradedSpec.removeChild(upgradedSpec.getLastChild());
            }
            Text text = v5Spec.createTextNode(writer.toString());
            upgradedSpec.appendChild(text);
        }
        catch (Exception ex) {
            UpgradeException.throwNestedException(ex);
        }
        return v5Spec;
    }

    public static Document addMessages(Document v5Spec, Log log, Messages messages) throws UpgradeException {
        if (v5Spec == null) {
            throw new NullPointerException("v5 spec may not be null");
        }
        Locale locale = messages.getLocale();
        if (!log.hasMessages()) {
            return v5Spec;
        }
        for (Message msg : log.getMessages()) {
            AddMessages.addMessage(v5Spec, msg, locale);
        }
        return v5Spec;
    }

    public static Document addMessage(Document v5Spec, Message msg, Locale locale) throws UpgradeException {
        if (v5Spec == null) {
            throw new NullPointerException("v5 spec may not be null");
        }
        Element upgradeMessages = AddMessages.getOrCreateUpgradeMessagesElement(v5Spec, locale);
        v5Spec = XmlUtils.getOwnerDoc(upgradeMessages);
        String txt = msg.getText();
        Text text = v5Spec.createTextNode(txt);
        Element upgradeMessage = v5Spec.createElementNS(OutputReportSpecification.targetNamespace, ReportSpecification40._upgradeMessage);
        Attr msgType = v5Spec.createAttribute(ReportSpecification40._type);
        msgType.setNodeValue(severityMap[msg.getSeverity()]);
        upgradeMessage.setAttributeNode(msgType);
        upgradeMessage.appendChild(text);
        upgradeMessages.appendChild(upgradeMessage);
        return v5Spec;
    }

    private static Element getOrCreateUpgradeMessagesElement(Document doc, Locale locale) throws UpgradeException {
        if (doc == null) {
            throw new NullPointerException("doc may not be null");
        }
        Element upgradeInfo = AddMessages.getOrCreateUpgradeInfoElement(doc, locale);
        Element upgradeMessages = AddMessages.getOrCreateChild(upgradeInfo, OutputReportSpecification.targetNamespace, ReportSpecification40._upgradeMessages);
        return upgradeMessages;
    }

    private static Element getOrCreateUpgradeInfoElement(Document doc, Locale locale) throws UpgradeException {
        if (doc == null) {
            throw new NullPointerException("doc may not be null");
        }
        Element report = AddMessages.getOrCreateReportElement(doc, locale);
        Element upgradeInfo = AddMessages.getOrCreateChild(report, OutputReportSpecification.targetNamespace, ReportSpecification40._upgradeInfo);
        return upgradeInfo;
    }

    private static Element getOrCreateReportElement(Document doc, Locale locale) throws UpgradeException {
        if (doc == null) {
            throw new NullPointerException("doc may not be null");
        }
        Element report = XmlUtils.getFirstChildElementByName(doc, ReportSpecification40._report);
        if (report == null) {
            report = doc.createElementNS(OutputReportSpecification.targetNamespace, ReportSpecification40._report);
            doc.appendChild(report);
            report.setAttribute("xmlns", OutputReportSpecification.targetNamespace);
            String language = "en";
            if (locale != null) {
                language = locale.getLanguage();
            }
            report.setAttribute(ReportSpecification40._expressionLocale, language);
        }
        return report;
    }

    private static Element getOrCreateChild(Node parent, String namespace, String tagName) {
        Element child = XmlUtils.getFirstChildElementByName(parent, tagName);
        if (child == null) {
            Document doc = XmlUtils.getOwnerDoc(parent);
            child = doc.createElementNS(namespace, tagName);
            parent.appendChild(child);
        }
        return child;
    }

    static {
        AddMessages.severityMap[0] = new String(ReportSpecification40._error);
        AddMessages.severityMap[1] = new String(ReportSpecification40._warning);
        AddMessages.severityMap[2] = new String(ReportSpecification40._info);
    }
}

