/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlDeleteTool;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AnchorMessageReferences
implements UpgradePipelineElement {
    static final String attributeName = "RS_upgradeMessageIndex";

    void moveMessageReference(Element xmlAttribute, Element newContainer) {
        if (newContainer == null) {
            Element xmlAttributes = XmlUtils.getParentElement(xmlAttribute);
            xmlAttributes.removeChild(xmlAttribute);
            return;
        }
        Element newXmlAttributes = XmlUtils.getOrCreateChildElementByName(newContainer, ReportSpecification50._XMLAttributes);
        newXmlAttributes.appendChild(xmlAttribute);
    }

    void removeEmptyXmlAttributes(Element xmlAttributes, XmlDeleteTool xmlDeleteTool) throws XmlException {
        NodeList childElements = XmlUtils.getChildElements(xmlAttributes);
        if (childElements.getLength() == 0) {
            xmlDeleteTool.deleteNode(xmlAttributes);
        }
    }

    Element findLegalXmlAttributesLocation(SchemaModel schemaModel, Element descendant) throws SchemaException {
        if (descendant == null) {
            return null;
        }
        if (schemaModel.isChildElementAllowed(descendant, ReportSpecification50._XMLAttributes)) {
            return descendant;
        }
        Element parent = XmlUtils.getParentElement(descendant);
        Element legalPosition = this.findLegalXmlAttributesLocation(schemaModel, parent);
        return legalPosition;
    }

    void moveDisallowedXmlAttribute(Element xmlAttribute, SchemaModel schemaModel) throws SchemaException {
        Element xmlAttributes = XmlUtils.getParentElement(xmlAttribute);
        Element container = XmlUtils.getParentElement(xmlAttributes);
        Element legalPosition = this.findLegalXmlAttributesLocation(schemaModel, container);
        if (legalPosition != container) {
            this.moveMessageReference(xmlAttribute, legalPosition);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            Element root = XmlUtils.getRoot(origSpec);
            String namespace = root.getNamespaceURI();
            XmlAttributeLocator examiner = new XmlAttributeLocator(namespace, upgradeSession);
            DomWalker.bottomUpWalkElements(root, examiner);
            return origSpec;
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    class XmlAttributeLocator
    implements DomWalker.Examiner {
        SchemaModel targetSchemaModel;
        XmlDeleteTool xmlDeleteTool;

        public XmlAttributeLocator(String namespace, UpgradeSessionContext upgradeSession) throws UpgradeException {
            this.xmlDeleteTool = upgradeSession.getXmlDeleteTool();
            this.targetSchemaModel = upgradeSession.getReportSpecificationSchemaModel(namespace);
            if (this.targetSchemaModel == null) {
                throw new UpgradeInternalErrorException("Namespace has no schema: " + namespace);
            }
        }

        @Override
        public DomWalker.SearchOrder examine(Element elem) throws XmlException {
            try {
                String name = XmlUtils.getName(elem);
                if (ReportSpecification50._XMLAttribute.equals(name)) {
                    if (AnchorMessageReferences.attributeName.equals(elem.getAttribute(ReportSpecification50._name))) {
                        AnchorMessageReferences.this.moveDisallowedXmlAttribute(elem, this.targetSchemaModel);
                    }
                } else if (ReportSpecification50._XMLAttributes.equals(name)) {
                    AnchorMessageReferences.this.removeEmptyXmlAttributes(elem, this.xmlDeleteTool);
                }
            }
            catch (SchemaException e) {
                throw new XmlException(e);
            }
            return DomWalker.SearchOrder.proceed;
        }
    }
}

