/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.rsupgrade.internal.configuration.Configuration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.AddMessages;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.IUpgradeNotes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;

public class EmbedOriginalReport
implements UpgradePipelineElement {
    private Document originalReport;

    public EmbedOriginalReport(Document originalReport) {
        this.originalReport = originalReport;
    }

    boolean shouldReportBeEmbedded(Document doc, UpgradeSessionContext upgradeSession) {
        if (this.originalReport == null) {
            return false;
        }
        IUpgradeNotes upgradeNotesTool = upgradeSession.getUpgradeNotes();
        Configuration.EmbedOriginalSpecificationEnumeration embedReportSpec = upgradeSession.getConfiguration().getEmbedOriginalSpecification();
        if (embedReportSpec == Configuration.EmbedOriginalSpecificationEnumeration.NEVER) {
            return false;
        }
        if (embedReportSpec == Configuration.EmbedOriginalSpecificationEnumeration.ALWAYS) {
            return true;
        }
        int maxSeverity = upgradeNotesTool.getMaximumSeverity(doc);
        if (embedReportSpec == Configuration.EmbedOriginalSpecificationEnumeration.ERROR) {
            if (maxSeverity == 0) {
                return true;
            }
        } else if (embedReportSpec == Configuration.EmbedOriginalSpecificationEnumeration.WARNING) {
            if (maxSeverity == 0) {
                return true;
            }
            if (maxSeverity == 1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (this.shouldReportBeEmbedded(origSpec, upgradeSession)) {
            origSpec = AddMessages.addOriginalReport(origSpec, upgradeSession.getTranslatedMessages(), this.originalReport);
        }
        return origSpec;
    }
}

