/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.BeringAugmented;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExpressionLocale {
    public static Locale getExpressionLocale(Document v5, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Locale locale;
        String localeString = ExpressionLocale.getExpressionLocaleString(v5, upgradeSession);
        String language = null;
        String country = "";
        if (localeString.length() <= 3) {
            language = localeString;
        } else {
            language = localeString.substring(0, 2);
            country = localeString.substring(3);
        }
        try {
            locale = new Locale(language, country);
        }
        catch (Exception ex) {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_LOCALE_INVALID(BeringAugmented._expressionLocale);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v5, 1, msg);
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public static String getExpressionLocaleString(Document v5, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getRoot(v5);
        String expressionLocaleAttribute = report.getAttribute(ReportSpecification20._expressionLocale);
        if (expressionLocaleAttribute == null) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_ATTRIBUTE_NOT_FOUND(ReportSpecification20._expressionLocale);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v5, 1, message);
        }
        return expressionLocaleAttribute;
    }
}

