/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools;

import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplateFramework;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.lang.reflect.Method;
import java.util.Vector;

public class LogMap {
    private static Vector<Log> theMap = new Vector(10);

    public static synchronized int registerLog(Log log) {
        int nbEntries = theMap.size();
        for (int i = 0; i < nbEntries; ++i) {
            if (theMap.get(i) != null) continue;
            theMap.set(i, log);
            return i;
        }
        if (theMap.capacity() == nbEntries) {
            theMap.ensureCapacity(nbEntries + 10);
        }
        theMap.add(log);
        nbEntries = theMap.size();
        return nbEntries - 1;
    }

    public static synchronized void deregisterLog(int logIdentifier) {
        theMap.set(logIdentifier, null);
    }

    public static MessageTemplateFramework getMsgTemplate(String msgId, String[] params) throws UpgradeException {
        try {
            Method method;
            MessageTemplateFramework msgTemplate = null;
            Class[] paramsClass = null;
            if (params != null) {
                paramsClass = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    paramsClass[i] = params[i].getClass();
                }
            }
            if ((method = RspecUpgradeMessage.class.getMethod(msgId, paramsClass)) != null) {
                msgTemplate = (MessageTemplateFramework)method.invoke(RspecUpgradeMessage.class, (Object[])params);
            }
            if (msgTemplate == null) {
                throw new UpgradeException("getMsgTemplate exception: Cannot create msgTemplate");
            }
            return msgTemplate;
        }
        catch (Exception ex) {
            throw new UpgradeException("getMsgTemplate exception: " + ex);
        }
    }

    public static String logInfo(int logIdentifier, MessageTemplateFramework msgTemplate) throws UpgradeException {
        Log log = LogMap.getLog(logIdentifier);
        return log.info(msgTemplate);
    }

    public static String logInfo0(int logIdentifier, String msgId) throws UpgradeException {
        return LogMap.logInfo(logIdentifier, LogMap.getMsgTemplate(msgId, null));
    }

    public static String logInfo1(int logIdentifier, String msgId, String param1) throws UpgradeException {
        String[] params = new String[]{param1};
        return LogMap.logInfo(logIdentifier, LogMap.getMsgTemplate(msgId, params));
    }

    public static String logInfo2(int logIdentifier, String msgId, String param1, String param2) throws UpgradeException {
        String[] params = new String[]{param1, param2};
        return LogMap.logInfo(logIdentifier, LogMap.getMsgTemplate(msgId, params));
    }

    public static String logWarning(int logIdentifier, MessageTemplateFramework msgTemplate) throws UpgradeException {
        Log log = LogMap.getLog(logIdentifier);
        return log.warning(msgTemplate);
    }

    public static String logWarning0(int logIdentifier, String msgId) throws UpgradeException {
        return LogMap.logWarning(logIdentifier, LogMap.getMsgTemplate(msgId, null));
    }

    public static String logWarning1(int logIdentifier, String msgId, String param1) throws UpgradeException {
        String[] params = new String[]{param1};
        return LogMap.logWarning(logIdentifier, LogMap.getMsgTemplate(msgId, params));
    }

    public static String logWarning2(int logIdentifier, String msgId, String param1, String param2) throws UpgradeException {
        String[] params = new String[]{param1, param2};
        return LogMap.logWarning(logIdentifier, LogMap.getMsgTemplate(msgId, params));
    }

    public static String logError(int logIdentifier, MessageTemplateFramework msgTemplate) throws UpgradeException {
        Log log = LogMap.getLog(logIdentifier);
        return log.error(msgTemplate);
    }

    public static String logError0(int logIdentifier, String msgId) throws UpgradeException {
        return LogMap.logError(logIdentifier, LogMap.getMsgTemplate(msgId, null));
    }

    public static String logError1(int logIdentifier, String msgId, String param1) throws UpgradeException {
        String[] params = new String[]{param1};
        return LogMap.logError(logIdentifier, LogMap.getMsgTemplate(msgId, params));
    }

    public static String logError2(int logIdentifier, String msgId, String param1, String param2) throws UpgradeException {
        String[] params = new String[]{param1, param2};
        return LogMap.logError(logIdentifier, LogMap.getMsgTemplate(msgId, params));
    }

    public static void logInfo0Void(int logIdentifier, String msgId) throws UpgradeException {
        LogMap.logInfo0(logIdentifier, msgId);
    }

    public static void logInfo1Void(int logIdentifier, String msgId, String param1) throws UpgradeException {
        LogMap.logInfo1(logIdentifier, msgId, param1);
    }

    public static void logInfo2Void(int logIdentifier, String msgId, String param1, String param2) throws UpgradeException {
        LogMap.logInfo2(logIdentifier, msgId, param1, param2);
    }

    public static void logWarning0Void(int logIdentifier, String msgId) throws UpgradeException {
        LogMap.logWarning0(logIdentifier, msgId);
    }

    public static void logWarning1Void(int logIdentifier, String msgId, String param1) throws UpgradeException {
        LogMap.logWarning1(logIdentifier, msgId, param1);
    }

    public static void logWarning2Void(int logIdentifier, String msgId, String param1, String param2) throws UpgradeException {
        LogMap.logWarning2(logIdentifier, msgId, param1, param2);
    }

    public static void logError0Void(int logIdentifier, String msgId) throws UpgradeException {
        LogMap.logError0(logIdentifier, msgId);
    }

    public static void logError1Void(int logIdentifier, String msgId, String param1) throws UpgradeException {
        LogMap.logError1(logIdentifier, msgId, param1);
    }

    public static void logError2Void(int logIdentifier, String msgId, String param1, String param2) throws UpgradeException {
        LogMap.logError2(logIdentifier, msgId, param1, param2);
    }

    private static synchronized Log getLog(int logIdentifier) {
        Log log = theMap.get(logIdentifier);
        return log;
    }
}

