/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgraders;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification60;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrader;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnknownReportVersionUpgrader
implements Upgrader {
    private String sourceNamespace;
    private String targetNamespace;

    public UnknownReportVersionUpgrader(String source, String target) {
        this.sourceNamespace = source;
        this.targetNamespace = target;
    }

    @Override
    public void appendPipelineElements(LinkedList<UpgradePipelineElement> pipeline, UpgradeSessionContext upgradeSession) throws UpgradeException {
        pipeline.add(new PipelineElement());
    }

    @Override
    public String getDestinationNameSpace() {
        return this.targetNamespace;
    }

    @Override
    public String getSourceNameSpace() {
        return this.sourceNamespace;
    }

    private class PipelineElement
    implements UpgradePipelineElement {
        private PipelineElement() {
        }

        @Override
        public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
            try {
                Document doc = XmlUtils.createDocument();
                Element report = doc.createElementNS(UnknownReportVersionUpgrader.this.targetNamespace, ReportSpecification60._report);
                doc.appendChild(report);
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_INVALID_REPORT_TO_UPGRADE();
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)doc, 0, message);
                Document document = doc;
                return document;
            }
            catch (IOException e) {
                UpgradeException.throwNestedException(e);
                throw new UpgradeException(e);
            }
        }
    }
}

