/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgraders;

import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.SchemaVersionUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade100To110;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade10To40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade110To120;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade120To130;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade13xTo140;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade14xTo150;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade20NovRtmTo40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade20RtmTo40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade30To40;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade40To50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade50To60;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade60To70;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade70To80;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade80To90;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrade90To100;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrader;
import com.cognos.rspecupgrade.tools.Utils;
import java.util.HashMap;
import java.util.LinkedList;

public class UpgraderRegistry {
    public static float minorUpgradeBase = 13.0f;
    private HashMap<String, Upgrader> registeredUpgraders = new HashMap();

    public void registerUpgrader(Upgrader upgrader) throws UpgradeException {
        String sourceNameSpace = upgrader.getSourceNameSpace();
        if (this.registeredUpgraders.containsKey(sourceNameSpace)) {
            throw new UpgradeInternalErrorException("Namespace is already registered: " + sourceNameSpace);
        }
        this.registeredUpgraders.put(upgrader.getSourceNameSpace(), upgrader);
    }

    private Upgrader getUpgrader(String sourceNameSpace) throws UpgradeException {
        String sourceNameSpaceFloor;
        float fSourceVersion;
        Upgrader upgrader = null;
        if (this.registeredUpgraders.containsKey(sourceNameSpace)) {
            upgrader = this.registeredUpgraders.get(sourceNameSpace);
        } else if (Utils.hasString(sourceNameSpace) && (fSourceVersion = Float.valueOf(SchemaVersionUtils.getVersionFromNamespace(sourceNameSpace)).floatValue()) > minorUpgradeBase && this.registeredUpgraders.containsKey(sourceNameSpaceFloor = SchemaVersionUtils.getNamespaceFromVersion(Float.toString((float)Math.floor(fSourceVersion))))) {
            upgrader = this.registeredUpgraders.get(sourceNameSpaceFloor);
        }
        return upgrader;
    }

    private void registerUpgraders(IConfiguration config) throws UpgradeException {
        Double version = Double.valueOf(SchemaVersionUtils.getVersionFromNamespace(config.getTargetnamespace()));
        this.registerUpgrader(new Upgrade10To40());
        this.registerUpgrader(new Upgrade20NovRtmTo40());
        this.registerUpgrader(new Upgrade20RtmTo40());
        this.registerUpgrader(new Upgrade30To40());
        this.registerUpgrader(new Upgrade40To50());
        this.registerUpgrader(new Upgrade50To60());
        this.registerUpgrader(new Upgrade60To70());
        this.registerUpgrader(new Upgrade70To80());
        this.registerUpgrader(new Upgrade80To90());
        this.registerUpgrader(new Upgrade90To100());
        this.registerUpgrader(new Upgrade100To110());
        this.registerUpgrader(new Upgrade110To120());
        this.registerUpgrader(new Upgrade120To130());
        if (version >= 14.0) {
            this.registerUpgrader(new Upgrade13xTo140());
        }
        if (version >= 15.0) {
            this.registerUpgrader(new Upgrade14xTo150());
        }
    }

    public UpgraderRegistry(IConfiguration config) throws UpgradeException {
        this.registerUpgraders(config);
    }

    private boolean getUpgraders(String sourceNameSpace, String targetNamespace, LinkedList<Upgrader> upgraders) throws UpgradeException {
        Upgrader upgrader = this.getUpgrader(sourceNameSpace);
        if (upgrader == null) {
            return false;
        }
        float sourceVersion = Float.valueOf(SchemaVersionUtils.getVersionFromNamespace(sourceNameSpace)).floatValue();
        float targetVersion = Float.valueOf(SchemaVersionUtils.getVersionFromNamespace(targetNamespace)).floatValue();
        if (!upgraders.isEmpty() && upgrader.equals(upgraders.getLast()) || sourceVersion >= targetVersion) {
            return false;
        }
        upgraders.addLast(upgrader);
        String destinationNamespace = upgrader.getDestinationNameSpace();
        float destinationVersion = Float.valueOf(SchemaVersionUtils.getVersionFromNamespace(destinationNamespace)).floatValue();
        if (!targetNamespace.equals(destinationNamespace) && (double)destinationVersion < Math.floor(targetVersion)) {
            return this.getUpgraders(destinationNamespace, targetNamespace, upgraders);
        }
        return true;
    }

    public LinkedList<Upgrader> getUpgraders(String sourceNameSpace, String targetNamespace) throws UpgradeException {
        LinkedList<Upgrader> upgraders = new LinkedList<Upgrader>();
        boolean found = this.getUpgraders(sourceNameSpace, targetNamespace, upgraders);
        if (!found) {
            return null;
        }
        return upgraders;
    }
}

