<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<!--* This stylesheet normalizes text elements so they can compare the same in test cases.
* @see trakker 535507
*
-->
<xsl:stylesheet version="1.0" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns:bering="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no" xalan:indent-amount="2" omit-xml-declaration="no"/>
  <!-- 
    * Remove trailing white space in text.
    * @param p_text Text to strip.
    * Outputs stripped text.
    *
    * Named after the perl function chomp.
     -->
  <xsl:template name="chomp">
    <xsl:param name="p_text"/>
    <xsl:choose>
      <xsl:when test="substring($p_text,  string-length($p_text)) = '&#9;' or
                       substring($p_text,  string-length($p_text)) = '&#10;' or		
                       substring($p_text,  string-length($p_text)) = '&#13;' or		
                       substring($p_text,  string-length($p_text)) = '&#32;' ">
        <xsl:call-template name="chomp">
          <xsl:with-param name="p_text" select="substring($p_text,1, string-length($p_text)-1)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$p_text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- -->
  <xsl:template match="comment()">
    <xsl:comment>
      <xsl:value-of select="."/>
    </xsl:comment>
  </xsl:template>
  <!-- 
     * Strip final line feeds.
     -->
  <xsl:template match="text()">
    <xsl:call-template name="chomp">
      <xsl:with-param name="p_text" select="."/>
    </xsl:call-template>
  </xsl:template>
  <!-- -->
  <xsl:template match="*">
    <xsl:element name="{name(.)}" namespace="{namespace-uri(.)}">
      <xsl:for-each select="@*">
        <xsl:sort select="name(.)"/>
        <xsl:copy-of select="."/>
      </xsl:for-each>
      <xsl:apply-templates select="node()"/>
    </xsl:element>
  </xsl:template>
  <!-- -->
</xsl:stylesheet>
