<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<!--
*  
* Transform a report specification from Blacksea INR to Blacksea MR1.
-->
<xsl:stylesheet version="1.0" xmlns="http://developer.cognos.com/schemas/report/5.0/" xmlns:bse="http://developer.cognos.com/schemas/report/4.0/" xmlns:bsemr1="http://developer.cognos.com/schemas/report/5.0/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no" omit-xml-declaration="yes"/>
	<!-- strip out explicit namespace definitions. -->
	<xsl:template match="@xmlns">
	</xsl:template>
	<!-- Work Order 2516 - Dynamic Filtering of Report Data - II 
      * Set the /report@ignoreFilterContext attribute to "false". 
      * ignoreFilterContext is a new attribute introduced in BSEMR1.
      -->
	<xsl:template match="bse:report">
		<xsl:element name="report" namespace="http://developer.cognos.com/schemas/report/5.0/">
			<xsl:attribute name="ignoreFilterContext">false</xsl:attribute>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<!-- Work Order 2516 - Dynamic Filtering of Report Data - II 
      * Set all drillTarget@sendFilterContext attributes to "false". 
      * sendFilterContext is a new attribute introduced in BSEMR1.
      -->
	<xsl:template match="bse:drillTarget">
		<xsl:element name="drillTarget" namespace="http://developer.cognos.com/schemas/report/5.0/">
			<xsl:attribute name="sendFilterContext">false</xsl:attribute>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<!-- Copy over non=specific stuff -->
	<xsl:template match="@*|text()|comment()">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="*">
		<xsl:element name="{local-name(.)}" namespace="http://developer.cognos.com/schemas/report/5.0/">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
