<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<!--
	*  
	* This stylesheet annotates elements of the V5 report layout.
	*
	* Currently, the only annotation is that of a unique name attribute on the 
	* crosstab/defaultMeasure and crosstabNodeMember elements.
	* This is done as part of the implementation of WO1713 and WO1730.
	*
	* The name attribute is used as the name attribute of the valueSets generated
	* by the RSUpgradeResultSetSqueleton stylesheet.  This is so we can map QRD valueSets 
	* back to their corresponding layout elements in the v5 to v5 upgrade.
	*
-->
<xsl:stylesheet version="1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:v5="http://developer.cognos.com/schemas/report/2.0/" xmlns="http://developer.cognos.com/schemas/report/2.0/" exclude-result-prefixes="xsl fo xs">
	<xsl:output method="xml" encoding="utf-8"/>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Generate a unique name attribute for each crosstab/defaultMeasure.                                                      -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:defaultMeasure">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="generate-id(@refDataItem)"/>
			</xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Generate a unique name attribute for each crosstabNodeMember.                                                           -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:crosstabNodeMember">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="generate-id(.)"/>
			</xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Copy all nodes and attributes by default.                                                                               -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
