<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="barChartTemplate">
		<xsl:param name="p_chartType"/>
		<combinationChart>
			<xsl:attribute name="orientation">
				<xsl:choose>
					<xsl:when test="$p_chartType = 'columnChart'">vertical</xsl:when>
					<xsl:when test="$p_chartType = 'barChart'">horizontal</xsl:when>
				</xsl:choose>
			</xsl:attribute>
			<xsl:call-template name="depthTemplate"/>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="legendTemplate"/>
			<xsl:call-template name="axisTemplate"/>
			<combinationChartTypes>
				<bar>
					<xsl:choose>
						<xsl:when test="$p_chartType = 'columnChart'">
							<xsl:apply-templates select="baltic:columnChart"/>
						</xsl:when>
						<xsl:when test="$p_chartType = 'barChart'">
							<xsl:apply-templates select="baltic:barChart"/>						
						</xsl:when>
					</xsl:choose>
					<xsl:call-template name="chartLevelTemplate">
						<xsl:with-param name="p_mode" select="'rowEdge'"/>
					</xsl:call-template>
				</bar>
			</combinationChartTypes>
			<xsl:call-template name="commonClustersTemplateWithMeasureOnColEdgeCheck"/>
			<xsl:call-template name="defaultMeasureTemplate">
				<xsl:with-param name="p_testByCount" select="'no'"/>
			</xsl:call-template>
			<xsl:call-template name="commonChartTemplate"/>
			<xsl:call-template name="commonChartMarkerTemplate"/>
			<xsl:call-template name="commonChartBaselineTemplate">
				<xsl:with-param name="chartType" select="$p_chartType"/>
				<xsl:with-param name="standardType">
					<xsl:choose>
						<xsl:when test="$p_chartType = 'columnChart'"><xsl:value-of select="baltic:columnChart/@standardType"/></xsl:when>
						<xsl:when test="$p_chartType = 'barChart'"><xsl:value-of select="baltic:barChart/@standardType"/></xsl:when>
					</xsl:choose>
				</xsl:with-param>					
			</xsl:call-template>
		</combinationChart>
	</xsl:template>
	<xsl:template match="*[local-name() = 'columnChart' or local-name() = 'barChart']">
		<xsl:call-template name="processAttsTemplate">
			<xsl:with-param name="p_cur" select="."/>
		</xsl:call-template>
		<xsl:call-template name="valueTypeTemplate">
			<xsl:with-param name="p_chart" select="."/>
		</xsl:call-template>
		<xsl:if test="@connectLines = 'true'">
			<connectLines/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
