<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:chart">
		<xsl:variable name="v_chart" select="*[contains(local-name(),'Chart')]"/>
		<xsl:variable name="v_chartType" select="local-name($v_chart)"/>
		<xsl:choose>
			<!-- areaChart -->
			<xsl:when test="$v_chartType='areaChart'">
				<xsl:choose>
					<xsl:when test="$v_chart/@standardType='3DAxis'">
						<xsl:call-template name="threeDAreaChartTemplate"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="areaChartTemplate"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- barChart -->
			<xsl:when test="$v_chartType='barChart'">
				<xsl:choose>
					<xsl:when test="$v_chart/@standardType='3DAxis'">
						<xsl:call-template name="threeDColumnChartTemplate"/>
						<!-- bar becomes column in 3d -->
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="barChartTemplate">
							<xsl:with-param name="p_chartType" select="'barChart'"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- columnChart -->
			<xsl:when test="$v_chartType='columnChart'">
				<xsl:choose>
					<xsl:when test="$v_chart/@standardType='3DAxis'">
						<xsl:call-template name="threeDColumnChartTemplate"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="barChartTemplate">
							<xsl:with-param name="p_chartType" select="'columnChart'"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- combinationChart -->
			<xsl:when test="$v_chartType='combinationChart'">
				<xsl:choose>
					<xsl:when test="$v_chart/@standardType='3DAxis'">
						<xsl:call-template name="combinationThreeDChartTemplate"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="combinationChartTemplate"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- lineChart -->
			<xsl:when test="$v_chartType='lineChart'">
				<xsl:choose>
					<xsl:when test="$v_chart/@standardType='3DAxis'">
						<xsl:call-template name="threeDLineChartTemplate"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="lineChartTemplate"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- bubbleChart -->
			<xsl:when test="$v_chartType='bubbleChart'">
				<xsl:call-template name="bubbleChartTemplate"/>
			</xsl:when>
			<!-- paretoChart -->
			<xsl:when test="$v_chartType='paretoChart'">
				<xsl:call-template name="paretoChartTemplate"/>
			</xsl:when>
			<!-- pieChart -->
			<xsl:when test="$v_chartType='pieChart'">
				<xsl:call-template name="pieChartTemplate"/>
			</xsl:when>
			<!-- polarChart -->
			<xsl:when test="$v_chartType='polarChart'">
				<xsl:call-template name="polarChartTemplate"/>
			</xsl:when>
			<!-- quadrantChart -->
			<xsl:when test="$v_chartType='quadrantChart'">
				<xsl:call-template name="quadrantChartTemplate"/>
			</xsl:when>
			<!-- radarChart -->
			<xsl:when test="$v_chartType='radarChart'">
				<xsl:call-template name="radarChartTemplate"/>
			</xsl:when>
			<!-- progressiveChart -->
			<xsl:when test="$v_chartType='progressiveChart'">
				<xsl:call-template name="progressiveChartTemplate"/>
			</xsl:when>
			<!-- scatterChart -->
			<xsl:when test="$v_chartType='scatterChart'">
				<xsl:call-template name="scatterChartTemplate"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
