<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<!--
*  
*  Intermediate stage in upgrading from a baltic report specification
*  to a bering report specification.
*
* Remove custom charrt labels where they are not needed.
-->
<xsl:stylesheet version="1.0" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns:bering="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no" xalan:indent-amount="2" omit-xml-declaration="yes"/>
	<!-- 
       * Remove customm chart labels that are not needed.
       * trakker 554269 Chart Custom Label in no longer generated in appropriate way.
       * -->
	<xsl:template match="node()[@refDataItem]">
		<xsl:variable name="v_dataItem" select="@refDataItem"/>
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="text()"/>
			<xsl:for-each select="./node()">
				<xsl:choose>
					<xsl:when test="local-name() = 'chartLabel'">
						<xsl:variable name="v_soleNode">
							<xsl:call-template name="soleDescendant">
								<xsl:with-param name="ancestor" select="."/>
								<xsl:with-param name="descendant" select="./bering:chartContents/bering:chartTextItem/bering:dataSource/bering:dataItemLabel[@refDataItem=$v_dataItem] "/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$v_soleNode='1'">
								<!-- Ignore the default chart label -->
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="copy"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="copy"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	<!-- Copy anything that is unmatched over to output. -->
	<xsl:template match="@*|node()|text()|comment()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()|text()|comment()"/>
		</xsl:copy>
	</xsl:template>
	<!-- copy over the object and apply the templates to the children. -->
	<xsl:template name="copy">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()|text()|comment()"/>
		</xsl:copy>
	</xsl:template>
	<!-- Check if a node is the only descendant of another node, -->
	<xsl:template name="soleDescendant">
		<xsl:param name="ancestor"/>
		<xsl:param name="descendant"/>
		<xsl:choose>
			<xsl:when test="count($descendant)!=1">0</xsl:when>
			<xsl:when test="$ancestor=$descendant">1</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="parent" select="$descendant/.."/>
				<xsl:choose>
					<xsl:when test="count($parent/node())=1">
						<xsl:call-template name="soleDescendant">
							<xsl:with-param name="ancestor" select="$ancestor"/>
							<xsl:with-param name="descendant" select="$parent"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
