<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="combinationChartTemplate">
		<combinationChart>
			<xsl:variable name="p_depth" select="baltic:combinationChart/@depth"/>
			<xsl:if test="$p_depth != ''">
				<xsl:attribute name="depth"><xsl:value-of select="$p_depth"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="matchSeriesColorTemplate"/>
			<xsl:variable name="v_axis" select="baltic:combinationChart/@axis"/>
			<xsl:if test="$v_axis = 'bipolar' or $v_axis = 'dual'">
				<xsl:attribute name="axisY2Position"><xsl:value-of select="$v_axis"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="legendTemplate"/>
			<xsl:call-template name="axisTemplate"/>
			<combinationChartTypes>
				<xsl:call-template name="generateCombinationChartTypes"/>
			</combinationChartTypes>
			<xsl:call-template name="commonClustersTemplate">
				<xsl:with-param name="p_addChartContents" select="'true'"/>
			</xsl:call-template>
			<xsl:call-template name="defaultMeasureTemplate"/>
			<xsl:call-template name="commonChartTemplate"/>
			<xsl:call-template name="commonChartMarkerTemplate"/>
			<xsl:call-template name="commonChartBaselineTemplate">
				<xsl:with-param name="chartType" select="'combinationChart'"/>
				<xsl:with-param name="standardType" select="baltic:combinationChart/@standardType"/>
			</xsl:call-template>
		</combinationChart>
	</xsl:template>
	<xsl:template name="matchSeriesColorTemplate">
		<xsl:variable name="v_matchSeriesColor" select="baltic:combinationChart/@matchSeriesColor"/>
		<xsl:variable name="v_refQuery" select="@refQuery"/>
		<xsl:if test="$v_matchSeriesColor != ''">
			<!--
					In the case where the chart's associated query has no row edges, i.e. series, we disable
					 the matchSeriesColor attribute, regardless of what it was set to originally.  This is to
					 prevent the attribute from being applied to series measures in Bering when it wasn't applied
					to any in Baltic (since measures are moved from "Measures" to "Series" in the upgrade).
					See Trakker #528738. 
					Note that this rule may need to be applied to other chart attributes in the future.
				-->
			<xsl:attribute name="matchSeriesColor"><xsl:choose><xsl:when test="count(//baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:rowEdge/baltic:level) = 0"><xsl:value-of select="'false'"/></xsl:when><xsl:otherwise><xsl:value-of select="$v_matchSeriesColor"/></xsl:otherwise></xsl:choose></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template name="generateCombinationChartTypes">
		<xsl:choose>
			<xsl:when test="count(baltic:combinationChart/baltic:*) = 1">
				<!-- If there is only one chart type, process it (even if it has no chartMember) -->
				<xsl:apply-templates select="baltic:combinationChart/baltic:*"/>
			</xsl:when>
			<xsl:otherwise>
				<!-- If there is more than one chart type, ignore the ones that have no chartMember. -->
				<xsl:apply-templates select="baltic:combinationChart/baltic:*/baltic:chartMember/.."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="fillNodesTemplate">
		<xsl:param name="p_refQuery"/>
		<xsl:variable name="p_mode" select="'rowEdge'"/>
		<xsl:variable name="p_base" select="../.."/>
		<xsl:variable name="p_addChartContents" select="'true'"/>
		<xsl:variable name="p_pos" select="'1'"/>
		<xsl:variable name="v_cube">
			<xsl:call-template name="getCubeOrCubeReference">
				<xsl:with-param name="p_queryNode" select="//baltic:BIQuery[@name=$p_refQuery]"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="v_chartNodeMembersExist">
			<xsl:for-each select="$p_base/baltic:chartLevel">
				<xsl:variable name="v_refDataItem" select="baltic:queryItemRef/@refItem"/>
				<xsl:variable name="v_chartNodesCount" select="count(//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:*[local-name(.)=$p_mode]/baltic:level[position()=$p_pos]/baltic:item[@refItem=$v_refDataItem])"/>
				<xsl:if test="$v_chartNodesCount &gt; 0">true</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_chartNodeMembersExist != ''">
				<chartNodes>
					<chartNode>
						<chartNodeMembers>
							<xsl:for-each select="$p_base/baltic:chartLevel">
								<xsl:variable name="v_refDataItem" select="baltic:queryItemRef/@refItem"/>
								<xsl:variable name="v_chartNodesCount" select="count(//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:*[local-name(.)=$p_mode]/baltic:level[position()=$p_pos]/baltic:item[@refItem=$v_refDataItem])"/>
								<xsl:if test="$v_chartNodesCount &gt; 0">
									<chartNodeMember refDataItem="{$v_refDataItem}">
										<chartContents>
											<chartTextItem>
												<xsl:call-template name="simpleLayoutGroupTemplate"/>
												<dataSource>
													<xsl:apply-templates select="baltic:queryItemRef"/>
												</dataSource>
											</chartTextItem>
										</chartContents>
										<xsl:if test="baltic:chartText">
											<chartLabel>
												<chartContents>
													<xsl:apply-templates select="baltic:chartText"/>
												</chartContents>
											</chartLabel>
										</xsl:if>
										<xsl:call-template name="sortListTemplate">
											<xsl:with-param name="p_cube" select="$v_cube"/>
											<xsl:with-param name="p_refDataItem" select="$v_refDataItem"/>
											<xsl:with-param name="p_base" select="$p_base"/>
										</xsl:call-template>
									</chartNodeMember>
								</xsl:if>
							</xsl:for-each>
						</chartNodeMembers>
						<!-- 
							If a combination chart element is already defined as the default measure 
							of the chart, then don't add the nested chartNodeMember because it will 
							be added as the defaultChartMeasure.  See Trakker #487225.1.
						-->
						<xsl:if test="baltic:chartMember and baltic:chartMember/@refMember != ancestor::baltic:chart/baltic:chartMeasure/baltic:member/@refMember">
							<chartNestedNodes>
								<chartNode>
									<chartNodeMembers>
										<xsl:apply-templates select="baltic:chartMember">
											<xsl:with-param name="p_cube" select="$v_cube"/>
											<xsl:with-param name="p_base" select="$p_base"/>
										</xsl:apply-templates>
									</chartNodeMembers>
								</chartNode>
							</chartNestedNodes>
						</xsl:if>
					</chartNode>
				</chartNodes>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="baltic:chartMember and baltic:chartMember/@refMember != ancestor::baltic:chart/baltic:chartMeasure/baltic:member/@refMember">
					<chartNodes>
						<chartNode>
							<chartNodeMembers>
								<xsl:apply-templates select="baltic:chartMember">
									<xsl:with-param name="p_cube" select="$v_cube"/>
									<xsl:with-param name="p_base" select="$p_base"/>
								</xsl:apply-templates>
							</chartNodeMembers>
						</chartNode>
					</chartNodes>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="baltic:combinationChart[not (@standardType='3DAxis')]/baltic:area">
		<area>
			<xsl:call-template name="processAttsTemplate"/>
			<xsl:call-template name="valueTypeTemplate">
				<xsl:with-param name="p_chart" select=".."/>
			</xsl:call-template>
			<xsl:call-template name="useNumericalAxisTemplate"/>
			<xsl:call-template name="fillNodesTemplate">
				<xsl:with-param name="p_refQuery" select="../../@refQuery"/>
			</xsl:call-template>
		</area>
	</xsl:template>
	<xsl:template match="baltic:combinationChart[not (@standardType='3DAxis')]/baltic:column">
		<bar>
			<xsl:call-template name="processAttsTemplate"/>
			<xsl:call-template name="valueTypeTemplate">
				<xsl:with-param name="p_chart" select=".."/>
			</xsl:call-template>
			<xsl:call-template name="useNumericalAxisTemplate"/>
			<xsl:call-template name="fillNodesTemplate">
				<xsl:with-param name="p_refQuery" select="../../@refQuery"/>
			</xsl:call-template>
		</bar>
	</xsl:template>
	<xsl:template match="baltic:combinationChart[not (@standardType='3DAxis')]/baltic:line">
		<xsl:variable name="v_depth" select="../@depth"/>
		<line>
			<xsl:if test="$v_depth = '0' or $v_depth = ''">
				<xsl:attribute name="showBorders">true</xsl:attribute>
			</xsl:if>
			<xsl:call-template name="chartMarkerTemplate">
				<xsl:with-param name="p_chart" select="."/>
				<xsl:with-param name="p_defaultShape" select="'square'"/>
			</xsl:call-template>
			<xsl:call-template name="processAttsTemplate"/>
			<xsl:call-template name="valueTypeTemplate">
				<xsl:with-param name="p_chart" select=".."/>
			</xsl:call-template>
			<xsl:call-template name="useNumericalAxisTemplate"/>
			<xsl:call-template name="fillNodesTemplate">
				<xsl:with-param name="p_refQuery" select="../../@refQuery"/>
			</xsl:call-template>
		</line>
	</xsl:template>
	<xsl:template match="baltic:chartMember">
		<xsl:param name="p_cube"/>
		<xsl:param name="p_base"/>
		<chartNodeMember refDataItem="{@refMember}">
			<xsl:variable name="v_refMember" select="@refMember"/>
			<xsl:variable name="v_chartMeasure" select="../../../baltic:chartMeasure[baltic:member[@refMember=$v_refMember]]"/>
			<xsl:choose>
				<xsl:when test="../../../baltic:chartMeasure[1]/baltic:member/@refMember=$v_refMember">
					<!-- Baltic only applies the style from the chart body for the first measure. see trakker 554842 -->
					<!-- get the CSS style and data format from the chartMeasure and chartBody-->
					<xsl:call-template name="mergeStylesFromChartBodyAndChartMeasure">
						<xsl:with-param name="p_chartBody" select="../../../baltic:chartBody"/>
						<xsl:with-param name="p_chartMeasure" select="$v_chartMeasure"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- Baltic did not apply the style from the chart body other than for the first measure. see trakker 554842 -->
					<xsl:if test="../../../baltic:chartBody/baltic:style">
						<xsl:comment>
							<xsl:value-of select="log:logInfo0(/baltic:report/logIdentifier/@logId, 'RSU_SPC_CHART_BODY_STYLE_IGNORED_FOR_NON_FIRST_MEASURE')" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>
						</xsl:comment>
					</xsl:if>
					<!-- tricky kludge passing a non-exist chart body, so there is nothing to override the measure. -->
					<xsl:call-template name="mergeStylesFromChartBodyAndChartMeasure">
						<xsl:with-param name="p_chartBody" select="/baltic:charBody"/>
						<xsl:with-param name="p_chartMeasure" select="$v_chartMeasure"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			<chartContents>
				<chartTextItem>
					<dataSource>
						<memberCaption/>
					</dataSource>
				</chartTextItem>
			</chartContents>
			<xsl:if test="$v_chartMeasure/baltic:chartText">
				<chartLabel>
					<chartContents>
						<xsl:apply-templates select="$v_chartMeasure/baltic:chartText"/>
					</chartContents>
				</chartLabel>
			</xsl:if>
			<xsl:call-template name="sortListTemplate">
				<xsl:with-param name="p_cube" select="$p_cube"/>
				<xsl:with-param name="p_refDataItem" select="$v_refMember"/>
				<xsl:with-param name="p_base" select="../../.."/>
			</xsl:call-template>
		</chartNodeMember>
	</xsl:template>
</xsl:stylesheet>
