<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:background">
		<fillEffects>
			<xsl:apply-templates select="baltic:wash"/>
			<xsl:apply-templates select="baltic:pattern"/>
		</fillEffects>
	</xsl:template>
	<xsl:template match="baltic:wash">
		<chartGradient>
			<xsl:attribute name="direction"><xsl:choose><xsl:when test="@washDirection"><xsl:value-of select="@washDirection"/></xsl:when><xsl:otherwise>down</xsl:otherwise></xsl:choose></xsl:attribute>
			<xsl:if test="@fromColor">
				<xsl:attribute name="fromColor"><xsl:value-of select="@fromColor"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@toColor">
				<xsl:attribute name="toColor"><xsl:value-of select="@toColor"/></xsl:attribute>
			</xsl:if>
		</chartGradient>
	</xsl:template>
	<xsl:template match="baltic:pattern">
		<chartPattern>
			<xsl:if test="@patternType">
				<xsl:attribute name="patternType"><xsl:choose><xsl:when test="@patternType = 'transparentCrossDiagonal'">diagonalCross</xsl:when><xsl:when test="@patternType = 'transparentCross'">cross</xsl:when><xsl:when test="@patternType = 'transparentBackDiagonal'">backwardDiagonal</xsl:when><xsl:when test="@patternType = 'transparentForwardDiagonal'">forwardDiagonal</xsl:when><xsl:when test="@patternType = 'transparentVertical'">vertical</xsl:when><xsl:when test="@patternType = 'transparentHorizontal'">horizontal</xsl:when><xsl:when test="@patternType = 'solid'">horizontal</xsl:when><xsl:when test="@patternType = 'solidCrossDiagonal'">diagonalCross</xsl:when><xsl:when test="@patternType = 'solidCross'">cross</xsl:when><xsl:when test="@patternType = 'solidBackDiagonal'">backwardDiagonal</xsl:when><xsl:when test="@patternType = 'solidForwardDiagonal'">forwardDiagonal</xsl:when><xsl:when test="@patternType = 'solidVertical'">vertical</xsl:when><xsl:when test="@patternType = 'solidHorizontal'">horizontal</xsl:when></xsl:choose></xsl:attribute>
			</xsl:if>
			<xsl:if test="@direction">
				<xsl:attribute name="direction"><xsl:value-of select="@direction"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@color2 != ''">
				<xsl:attribute name="foregroundColor"><xsl:value-of select="@color2"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@color1 != ''">
				<xsl:attribute name="backgroundColor"><xsl:value-of select="@color1"/></xsl:attribute>
			</xsl:if>
		</chartPattern>
	</xsl:template>
	<xsl:template match="baltic:color">
		<chartColor>
			<xsl:if test="@value">
				<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
			</xsl:if>
		</chartColor>
	</xsl:template>
	<xsl:template match="baltic:chartPalette">
		<chartPalette>
			<xsl:apply-templates/>
		</chartPalette>
	</xsl:template>
	<xsl:template match="baltic:chartBody">
		<xsl:if test="baltic:background or baltic:style">
			<chartBody>
				<xsl:apply-templates select="baltic:background"/>
				<xsl:call-template name="simpleLayoutGroupTemplate"/>
			</chartBody>
		</xsl:if>
	</xsl:template>
	<xsl:template name="commonChartMarkerTemplate">
		<xsl:param name="p_chart" select="."/>
		<xsl:variable name="v_showMarkers" select="$p_chart/@showMarkers"/>
		<xsl:if test="baltic:marker">
			<xsl:element name="markers">
				<xsl:if test="$v_showMarkers != ''">
					<xsl:attribute name="markerTextLocation"><xsl:value-of select="$v_showMarkers"/></xsl:attribute>
				</xsl:if>
				<xsl:for-each select="baltic:marker">
					<xsl:call-template name="commonMarkerTemplate">
						<xsl:with-param name="markerElementName" select="'marker'"/>
						<xsl:with-param name="positioningElementName" select="'markerPosition'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template name="pointChartMarkerTemplate">
		<xsl:param name="p_chart" select="."/>
		<xsl:variable name="v_showMarkers" select="$p_chart/@showMarkers"/>
		<xsl:if test="baltic:marker">
			<xsl:element name="pointChartMarkers">
				<xsl:if test="$v_showMarkers != ''">
					<xsl:attribute name="markerTextLocation"><xsl:value-of select="$v_showMarkers"/></xsl:attribute>
				</xsl:if>
				<xsl:for-each select="baltic:marker">
					<xsl:call-template name="commonMarkerTemplate">
						<xsl:with-param name="markerElementName" select="'pointChartMarker'"/>
						<xsl:with-param name="positioningElementName" select="'pointChartMarkerPosition'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template name="commonMarkerTemplate">
		<xsl:param name="markerElementName"/>
		<xsl:param name="positioningElementName"/>
		<xsl:param name="p_marker" select="."/>
		<xsl:variable name="dataPointColor">
			<xsl:if test="baltic:style">
				<xsl:call-template name="getColorFromCSSTemplate">
					<xsl:with-param name="inputString" select="normalize-space(baltic:style[1]/baltic:CSS/@value)"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="v_yPosition">
			<xsl:choose>
				<xsl:when test="$p_marker/@yPosition">
					<xsl:value-of select="$p_marker/@yPosition"/>
				</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:element name="{$markerElementName}">
			<xsl:call-template name="dataPointTemplate"/>
			<xsl:if test="$dataPointColor!=''">
				<xsl:attribute name="dataPointColor"><xsl:value-of select="$dataPointColor"/></xsl:attribute>
			</xsl:if>
			<xsl:element name="{$positioningElementName}">
				<xsl:choose>
					<xsl:when test="$positioningElementName='markerPosition'">
						<numericPosition>
							<dataSource>
								<staticValue>
									<xsl:value-of select="$v_yPosition"/>
								</staticValue>
							</dataSource>
						</numericPosition>
						<memberPosition>
							<reportExpression>
								<xsl:value-of select="$p_marker/@xPosition"/>
							</reportExpression>
						</memberPosition>
					</xsl:when>
					<xsl:otherwise>
						<XPosition>
							<dataSource>
								<staticValue>
									<xsl:value-of select="$p_marker/@xPosition"/>
								</staticValue>
							</dataSource>
						</XPosition>
						<YPosition>
							<dataSource>
								<staticValue>
									<xsl:value-of select="$v_yPosition"/>
								</staticValue>
							</dataSource>
						</YPosition>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:call-template name="chartContentsLabelTemplate">
				<xsl:with-param name="labelName" select="'markerLabel'"/>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>
	<xsl:template name="commonChartBaselineTemplate">
		<xsl:param name="chartType"/>
		<xsl:param name="standardType"/>
		<xsl:if test="baltic:statistics[@function='baseLine']">
			<baselines>
				<xsl:for-each select="baltic:statistics">
					<xsl:if test="@function='baseLine'">
						<xsl:call-template name="chartBaselineTemplate">
							<xsl:with-param name="chartType" select="$chartType"/>
							<xsl:with-param name="standardType" select="$standardType"/>
							<xsl:with-param name="baselineElementName" select="'baseline'"/>
							<xsl:with-param name="positioningElementName" select="'baselinePosition'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</baselines>
		</xsl:if>
	</xsl:template>
	<xsl:template name="commonPointChartBaselineTemplate">
		<xsl:param name="chartType"/>
		<xsl:param name="standardType"/>
		<xsl:choose>
			<xsl:when test="$chartType = 'quadrantChart'">
				<pointChartBaselines>
					<!-- puts in the X and Y quadrant  lines, these become baselines in V5 -->
					<xsl:call-template name="quadrantLineTemplate">
						<xsl:with-param name="axisPosition" select="'xPosition'"/>
						<xsl:with-param name="percentAlongAxis" select="baltic:quadrantChart/@xPosition"/>
					</xsl:call-template>
					<xsl:call-template name="quadrantLineTemplate">
						<xsl:with-param name="axisPosition" select="'yPosition'"/>
						<xsl:with-param name="percentAlongAxis" select="baltic:quadrantChart/@yPosition"/>
					</xsl:call-template>
					<xsl:for-each select="baltic:statistics">
						<xsl:if test="@function='baseLine'">
							<xsl:call-template name="chartBaselineTemplate">
								<xsl:with-param name="chartType" select="$chartType"/>
								<xsl:with-param name="standardType" select="$standardType"/>
								<xsl:with-param name="baselineElementName" select="'pointChartBaseline'"/>
								<xsl:with-param name="positioningElementName" select="'pointChartBaselinePosition'"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</pointChartBaselines>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="baltic:statistics[@function='baseLine']">
					<pointChartBaselines>
						<xsl:for-each select="baltic:statistics">
							<xsl:if test="@function='baseLine'">
								<xsl:call-template name="chartBaselineTemplate">
									<xsl:with-param name="chartType" select="$chartType"/>
									<xsl:with-param name="standardType" select="$standardType"/>
									<xsl:with-param name="baselineElementName" select="'pointChartBaseline'"/>
									<xsl:with-param name="positioningElementName" select="'pointChartBaselinePosition'"/>
								</xsl:call-template>
							</xsl:if>
						</xsl:for-each>
					</pointChartBaselines>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="threeDComboBaselineTemplate">
		<xsl:param name="chartType"/>
		<xsl:param name="standardType"/>
		<xsl:if test="baltic:statistics[@function='baseLine']">
			<threeDComboBaselines>
				<xsl:for-each select="baltic:statistics">
					<xsl:if test="@function='baseLine'">
						<xsl:call-template name="chartBaselineTemplate">
							<xsl:with-param name="chartType" select="$chartType"/>
							<xsl:with-param name="standardType" select="$standardType"/>
							<xsl:with-param name="baselineElementName" select="'threeDComboBaseline'"/>
							<xsl:with-param name="positioningElementName" select="'threeDBaselinePosition'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</threeDComboBaselines>
		</xsl:if>
	</xsl:template>
	<xsl:template name="threeDScatterBaselineTemplate">
		<xsl:param name="chartType"/>
		<xsl:param name="standardType"/>
		<xsl:if test="baltic:statistics[@function='baseLine']">
			<threeDScatterBaselines>
				<xsl:for-each select="baltic:statistics">
					<xsl:if test="@function='baseLine'">
						<xsl:call-template name="chartBaselineTemplate">
							<xsl:with-param name="chartType" select="$chartType"/>
							<xsl:with-param name="standardType" select="$standardType"/>
							<xsl:with-param name="baselineElementName" select="'threeDScatterBaseline'"/>
							<xsl:with-param name="positioningElementName" select="'threeDBaselinePosition'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</threeDScatterBaselines>
		</xsl:if>
	</xsl:template>
	<xsl:template name="chartBaselineTemplate">
		<xsl:param name="chartType"/>
		<xsl:param name="standardType"/>
		<xsl:param name="baselineElementName"/>
		<xsl:param name="positioningElementName"/>
		<!--Get baseline color-->
		<xsl:variable name="color">
			<xsl:if test="baltic:style">
				<xsl:call-template name="getColorFromCSSTemplate">
					<xsl:with-param name="inputString" select="normalize-space(baltic:style[1]/baltic:CSS/@value)"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:variable>
		<!--Get baseline useNumericalAxis-->
		<xsl:variable name="useNumericalAxis">
			<xsl:call-template name="getUseNumericalAxisTemplate">
				<xsl:with-param name="chartType" select="$chartType"/>
				<xsl:with-param name="standardType" select="$standardType"/>
				<xsl:with-param name="axisPosition" select="@axisPosition"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:element name="{$baselineElementName}">
			<!-- line style attribute-->
			<xsl:call-template name="lineStyleTemplate">
				<xsl:with-param name="p_lineStyle" select="@lineStyle"/>
			</xsl:call-template>
			<!-- line color attribute-->
			<xsl:if test="$color!=''">
				<xsl:attribute name="color"><xsl:value-of select="$color"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$chartType='bubbleChart' or $chartType='polarChart' or $chartType='quadrantChart' or $chartType='scatterChart'">
				<!-- useNumericalAxis attribute-->
				<xsl:if test="$useNumericalAxis!=''">
					<xsl:attribute name="pointChartAxis"><xsl:value-of select="$useNumericalAxis"/></xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:element name="{$positioningElementName}">
				<xsl:if test="$chartType='areaChart' or $chartType='barChart' or $chartType='columnChart' or $chartType='lineChart' or $chartType='combinationChart' or $chartType='paretoChart' or $chartType='progressiveChart' or $chartType='radarChart'">
					<xsl:if test="$useNumericalAxis = 'numericalAxisY1' or $useNumericalAxis = 'numericalAxisY2' or $useNumericalAxis = 'radialAxis'">
						<!-- useNumericalAxis attribute-->
						<xsl:attribute name="useNumericalAxis"><xsl:value-of select="$useNumericalAxis"/></xsl:attribute>
					</xsl:if>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="$useNumericalAxis = 'ordinalAxisX'">
						<memberPosition>
							<reportExpression>
								<xsl:value-of select="@customValue"/>
							</reportExpression>
						</memberPosition>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$chartType = 'bubbleChart' or $chartType = 'polarChart' or $chartType = 'quadrantChart' or $chartType = 'scatterChart' or $standardType = '3DAxis'">
								<dataSource>
									<staticValue>
										<xsl:value-of select="@customValue"/>
									</staticValue>
								</dataSource>
							</xsl:when>
							<xsl:otherwise>
								<numericPosition>
									<xsl:choose>
										<xsl:when test="$standardType = 'percent'">
											<!--for percent, customValue is always define as x/100, therefore multiply by 100 for V5-->
											<percentAlongAxis>
												<xsl:attribute name="percentAlongAxis"><xsl:value-of select="number(@customValue)*100"/></xsl:attribute>
											</percentAlongAxis>
										</xsl:when>
										<xsl:otherwise>
											<dataSource>
												<staticValue>
													<xsl:value-of select="@customValue"/>
												</staticValue>
											</dataSource>
										</xsl:otherwise>
									</xsl:choose>
								</numericPosition>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:if test="$standardType != '3DAxis'">
				<xsl:call-template name="chartContentsLabelTemplate">
					<xsl:with-param name="labelName" select="'baselineLabel'"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template name="getUseNumericalAxisTemplate">
		<xsl:param name="chartType"/>
		<xsl:param name="standardType"/>
		<xsl:param name="axisPosition"/>
		<xsl:choose>
			<xsl:when test="$chartType = 'bubbleChart' or $chartType = 'quadrantChart' or $chartType = 'scatterChart'">
				<xsl:choose>
					<xsl:when test="$axisPosition='X'">
						<xsl:value-of select="'xAxis'"/>
					</xsl:when>
					<xsl:otherwise>
						<!--Default value in V4 is "Y1".  Therefore, carry this default over when no value is specified-->
						<xsl:text>yAxis</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$chartType = 'polarChart'">
				<xsl:choose>
					<xsl:when test="$axisPosition='X'">
						<xsl:value-of select="'angularAxis'"/>
					</xsl:when>
					<xsl:otherwise>
						<!--Default value in V4 is "Y1".  Therefore, carry this default over when no value is specified-->
						<xsl:text>radialAxis</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$standardType != '3DAxis'">
				<!--3D combination charts in V5, the baseline is always occur on the Z-axis.
					Since Z-axis is the mandatory axis for 3D charts, there are no V5 defintion for "useNumericalAxis" for 3D charts
				-->
				<xsl:choose>
					<xsl:when test="$axisPosition='X'">
						<xsl:value-of select="'ordinalAxisX'"/>
					</xsl:when>
					<xsl:when test="$axisPosition='Y1'">
						<xsl:value-of select="'numericalAxisY1'"/>
					</xsl:when>
					<xsl:when test="$axisPosition='Y2'">
						<xsl:value-of select="'numericalAxisY2'"/>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="chartContentsLabelTemplate">
		<xsl:param name="labelName"/>
		<xsl:element name="{$labelName}">
			<chartContents>
				<xsl:for-each select="baltic:chartText">
					<xsl:call-template name="chartTextGroupTemplate"/>
				</xsl:for-each>
			</chartContents>
		</xsl:element>
	</xsl:template>
	<xsl:template match="baltic:note">
		<note>
			<xsl:if test="@refQuery">
				<xsl:variable name="var_beringRefQuery">
					<xsl:call-template name="getQueryTemplate">
						<xsl:with-param name="refQuery" select="@refQuery"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:attribute name="refQuery"><xsl:value-of select="$var_beringRefQuery"/></xsl:attribute>
				<!-- originalRefQuery is used when looking up the Baltic query from Bering context, and will be removed in later stages. -->
				<xsl:attribute name="originalRefQuery"><xsl:value-of select="@refQuery"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@noteWidth">
				<xsl:attribute name="width"><xsl:value-of select="@noteWidth"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@noteHeight">
				<xsl:attribute name="height"><xsl:value-of select="@noteHeight"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@noteLeft">
				<xsl:attribute name="left"><xsl:value-of select="@noteLeft"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@noteTop">
				<xsl:attribute name="bottom"><xsl:value-of select="number(@noteTop)-number(@noteHeight)"/></xsl:attribute>
			</xsl:if>
			<noteContent>
				<chartContents>
					<xsl:for-each select="baltic:chartText">
						<xsl:call-template name="chartPlainTextTemplate"/>
					</xsl:for-each>
				</chartContents>
				<xsl:call-template name="simpleLayoutGroupTemplate"/>
			</noteContent>
			<xsl:if test="@lineStyle">
				<noteBorder>
					<xsl:call-template name="lineStyleTemplate"/>
				</noteBorder>
			</xsl:if>
		</note>
	</xsl:template>
	<xsl:template match="baltic:categoryItemTruncationText">
		<truncationText>
			<xsl:call-template name="chartTextGroupTemplate"/>
		</truncationText>
	</xsl:template>
	<!-- named templates/helpers -->
	<xsl:template name="chartTextTemplate">
		<xsl:call-template name="chartTextAttributesTemplate"/>
		<xsl:call-template name="chartTextGroupTemplate"/>
	</xsl:template>
	<xsl:template name="chartPlainTextTemplate">
		<xsl:call-template name="chartTextAttributesTemplate"/>
		<xsl:call-template name="chartTextGroupTemplate"/>
	</xsl:template>
	<xsl:template match="baltic:chartText">
		<xsl:call-template name="chartTextGroupTemplate"/>
	</xsl:template>
	<xsl:template name="chartTextGroupTemplate">
		<xsl:param name="p_cur" select="."/>
		<chartTextItem>
			<xsl:if test="$p_cur/baltic:text[not(@refVariableValue)] or $p_cur/baltic:expression or $p_cur/baltic:queryItemRef">
				<dataSource>
					<xsl:apply-templates select="$p_cur/baltic:text[not(@refVariableValue)]"/>
					<xsl:apply-templates select="comment()"/>
					<!-- Harvest comments in case there were expression parsing errors. -->
					<xsl:apply-templates select="$p_cur/baltic:expression"/>
					<xsl:apply-templates select="$p_cur/baltic:queryItemRef"/>
				</dataSource>
			</xsl:if>
			<xsl:variable name="v_refVariableExists">
				<xsl:call-template name="checkRefVariableTemplate">
					<xsl:with-param name="p_cur" select="$p_cur"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="count($p_cur/@refVariable) = 1 and $v_refVariableExists = 'true' and count($p_cur/baltic:text[@refVariableValue]) &gt; 0">
				<conditionalDataSources>
					<xsl:attribute name="refVariable"><xsl:value-of select="$p_cur/@refVariable"/></xsl:attribute>
					<xsl:apply-templates select="$p_cur/baltic:text[@refVariableValue]"/>
				</conditionalDataSources>
			</xsl:if>
			<xsl:call-template name="simpleLayoutGroupTemplate">
				<xsl:with-param name="p_cur" select="$p_cur"/>
			</xsl:call-template>
		</chartTextItem>
	</xsl:template>
	<xsl:template name="chartTextAttributesTemplate">
		<!-- tbd -->
	</xsl:template>
	<xsl:template name="chartLevelTemplate">
		<xsl:param name="p_mode"/>
		<xsl:param name="p_base" select="."/>
		<xsl:param name="p_addChartContents" select="'true'"/>
		<xsl:param name="p_pos" select="'1'"/>
		<xsl:param name="p_checkMeasures" select="'conditionally'"/>
		<xsl:param name="p_testMoveMeasureToColEdge" select="0"/>
		<xsl:variable name="v_refQuery" select="@refQuery"/>
		<xsl:variable name="v_cube">
			<xsl:call-template name="getCubeOrCubeReference">
				<xsl:with-param name="p_queryNode" select="//baltic:BIQuery[@name=$v_refQuery]"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="v_measureOnColEdge">
			<xsl:choose>
				<xsl:when test="//baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/baltic:cellMembers">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_levelOnColEdge">
			<xsl:choose>
				<xsl:when test="//baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/baltic:level">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_chartNodes">
			<xsl:call-template name="checkSummaryLevelTemplate">
				<xsl:with-param name="p_mode" select="$p_mode"/>
				<xsl:with-param name="p_base" select="$p_base"/>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="count($p_base/baltic:chartMeasure) &gt; 1 and $p_checkMeasures = 'yes'">1</xsl:when>
				<xsl:when test="count($p_base/baltic:chartMeasure) &gt; 1 and $p_checkMeasures = 'conditionally'">1</xsl:when>
				<!-- These next two are to test for the case when you have one default measure, and no level on the column edge.
						In this case, put the measure on the column edge so that the labels will show up properly. -->
				<xsl:when test="$p_testMoveMeasureToColEdge = 1 and count($p_base/baltic:chartMeasure) = 1 and $v_levelOnColEdge = 1">0</xsl:when>
				<xsl:when test="$p_testMoveMeasureToColEdge = 1 and count($p_base/baltic:chartMeasure) = 1 and $v_measureOnColEdge = 1">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_chartNodes != 0">
			<xsl:variable name="v_measures">
				<xsl:call-template name="chartNodeTemplate">
					<xsl:with-param name="p_cube" select="$v_cube/baltic:cube"/>
					<xsl:with-param name="p_refQuery" select="$v_refQuery"/>
					<xsl:with-param name="p_mode" select="$p_mode"/>
					<xsl:with-param name="p_base" select="$p_base"/>
					<xsl:with-param name="p_addChartContents" select="$p_addChartContents"/>
					<xsl:with-param name="p_pos" select="$p_pos"/>
					<xsl:with-param name="p_checkMeasures" select="$p_checkMeasures"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$v_measures/*">
				<chartNodes>
					<xsl:copy-of select="$v_measures"/>
				</chartNodes>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="chooseEdgeAndPlaceMeasuresTemplate">
		<!-- In the summary section of a v4 chart query, you can place cellMembers on the
			 rowEdge or on the columnEdge. On which edge it is determines where multiple 
			 measures go in the v5 spec. For example, for an area chart, it determines
			 if the multiple measures go on the commonClusters or on combinationChartTypes/area.
		-->
		<xsl:param name="p_refQuery"/>
		<xsl:param name="p_mode"/>
		<xsl:param name="p_checkMeasures" select="'never'"/>
		<xsl:param name="p_cube"/>
		<xsl:param name="p_base" select="."/>
		<xsl:param name="p_addNestedNode" select="'false'"/>
		<xsl:variable name="v_placeMeasures">
			<xsl:choose>
				<xsl:when test="$p_checkMeasures = 'never'">false</xsl:when>
				<xsl:when test="$p_checkMeasures = 'yes'">true</xsl:when>
				<xsl:when test="//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:rowEdge/baltic:cellMembers and $p_checkMeasures = 'conditionally'">
					<xsl:if test="$p_mode = 'rowEdge'">true</xsl:if>
				</xsl:when>
				<xsl:when test="//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:columnEdge/baltic:cellMembers and $p_checkMeasures = 'conditionally'">
					<xsl:if test="$p_mode = 'columnEdge'">true</xsl:if>
				</xsl:when>
				<xsl:when test="not(//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:columnEdge/baltic:cellMembers) and not(//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:rowEdge/baltic:cellMembers) and $p_checkMeasures = 'conditionally'">
					<xsl:choose>
						<xsl:when test="//baltic:chart[@refQuery=$p_refQuery]/pieChart and $p_mode = 'categoryEdge'">true</xsl:when>
						<xsl:when test="not(//baltic:chart[@refQuery=$p_refQuery]/pieChart) and $p_mode = 'rowEdge'">true</xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_placeMeasures = 'true'">
			<xsl:if test="$p_addNestedNode = 'false'">
				<chartNodeMembers>
					<xsl:call-template name="processChartMeasuresTemplate">
						<xsl:with-param name="p_cube" select="$p_cube"/>
						<xsl:with-param name="p_base" select="$p_base"/>
					</xsl:call-template>
				</chartNodeMembers>
			</xsl:if>
			<xsl:if test="$p_addNestedNode = 'true'">
				<chartNestedNodes>
					<chartNode>
						<chartNodeMembers>
							<xsl:call-template name="processChartMeasuresTemplate">
								<xsl:with-param name="p_cube" select="$p_cube"/>
								<xsl:with-param name="p_base" select="$p_base"/>
							</xsl:call-template>
						</chartNodeMembers>
					</chartNode>
				</chartNestedNodes>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="chartNodeTemplate">
		<xsl:param name="p_cube"/>
		<xsl:param name="p_refQuery"/>
		<xsl:param name="p_mode"/>
		<xsl:param name="p_base" select="."/>
		<xsl:param name="p_addChartContents" select="'true'"/>
		<xsl:param name="p_pos" select="'1'"/>
		<xsl:param name="p_checkMeasures"/>
		<xsl:variable name="v_checkMeasures">
			<xsl:choose>
				<xsl:when test="$p_checkMeasures = 'yes'">yes</xsl:when>
				<xsl:when test="$p_checkMeasures = 'conditionally' and count($p_base/baltic:chartMeasure) &gt; 1">conditionally</xsl:when>
				<xsl:otherwise>never</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_currentLevelName" select="//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:*[local-name(.)=$p_mode]/baltic:level[position()=$p_pos]/@refLevel"/>
		<xsl:variable name="v_currentChartLevel" select="$p_base/baltic:chartLevel[@refLevel=$v_currentLevelName]"/>
		<xsl:variable name="v_currentLevelItemRef">
			<xsl:call-template name="getKeyItemNameForLevel">
				<xsl:with-param name="p_level" select="$p_cube//baltic:level[@name=$v_currentLevelName]"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="v_chartNodeMembersExist">
			<xsl:if test="count($v_currentChartLevel) = 1 or $v_checkMeasures = 'yes'">yes</xsl:if>
			<xsl:if test="count($v_currentChartLevel) = 1 or $v_checkMeasures = 'conditionally'">yes</xsl:if>
		</xsl:variable>
		<xsl:variable name="v_currentRefDataItem">
			<xsl:value-of select="$v_currentLevelItemRef"/>
		</xsl:variable>
		<xsl:variable name="staticChartLabel">
			<xsl:choose>
				<xsl:when test="$v_currentLevelName != $v_currentLevelItemRef">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Are the measures on the column.  1=yes 0=no -->
		<xsl:variable name="v_measureOnColEdge">
			<xsl:choose>
				<xsl:when test="//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:columnEdge/baltic:cellMembers">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Are the measures on the row. 1=yes 0=no )-->
		<xsl:variable name="v_measureOnRowEdge">
			<xsl:choose>
				<xsl:when test="//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:rowEdge/baltic:cellMembers">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Should chartLabels be generated. 1=yes 0=no
            * Do not generate labels if ANY measure has text, and the measures are going to become nestedNodes of the
            * node we are generating.
          -->
		<xsl:variable name="v_generateChartLabel">
			<xsl:choose>
				<xsl:when test="(($p_mode='rowEdge' and $v_measureOnRowEdge='1') or ($p_mode='columnEdge' and $v_measureOnColEdge='1')) and $p_base/baltic:chartMeasure/baltic:chartText/baltic:text">0</xsl:when>
				<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!--  Start of Debugging Information -->
		<!--<xsl:comment>Entering "chartNodeTemplate".</xsl:comment>
		<xsl:comment>
			<xsl:text>p_refQuery = </xsl:text>
			<xsl:value-of select="$p_refQuery"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>p_mode = </xsl:text>
			<xsl:value-of select="$p_mode"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>p_pos = </xsl:text>
			<xsl:value-of select="$p_pos"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>p_checkMeasures = </xsl:text>
			<xsl:value-of select="$p_checkMeasures"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>v_currentLevelName = </xsl:text>
			<xsl:value-of select="$v_currentLevelName"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>v_currentLevelItemRef = </xsl:text>
			<xsl:value-of select="$v_currentLevelItemRef"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>v_chartNodeMembersExist = </xsl:text>
			<xsl:value-of select="$v_chartNodeMembersExist"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>v_currentRefDataItem = </xsl:text>
			<xsl:value-of select="$v_currentRefDataItem"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>Start of v_currentChartLevel</xsl:text>
		</xsl:comment>
		<dump>
			<xsl:copy-of select="$v_currentChartLevel"/>
		</dump>
		<xsl:comment>
			<xsl:text>End of v_currentChartLevel</xsl:text>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>v_measureOnColEdge = </xsl:text>
			<xsl:value-of select="$v_measureOnColEdge"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>v_measureOnRowEdge = </xsl:text>
			<xsl:value-of select="$v_measureOnRowEdge"/>
		</xsl:comment>
		<xsl:comment>
			<xsl:text>v_generateChartLabel = </xsl:text>
			<xsl:value-of select="$v_generateChartLabel"/>
		</xsl:comment>
-->		
		<!--  End of Debugging Information -->
		<xsl:variable name="v_chartNodeContents">
			<xsl:choose>
				<xsl:when test="$v_chartNodeMembersExist != ''">
					<xsl:choose>
						<xsl:when test="count($v_currentChartLevel) = 1 or ($v_currentLevelName != '' and not($p_base/baltic:chartMeasure/baltic:member[@refMember=$v_currentLevelName]))">
							<chartNodeMembers>
								<chartNodeMember refDataItem="{$v_currentRefDataItem}">
									<chartContents>
										<chartTextItem>
											<dataSource>
												<xsl:choose>
													<xsl:when test="$v_generateChartLabel = '0'">
														<staticValue/>
													</xsl:when>
													<xsl:when test="count($v_currentChartLevel) = 1">
														<xsl:apply-templates select="$v_currentChartLevel/baltic:queryItemRef">
															<xsl:with-param name="p_currentRefDataItem" select="$v_currentRefDataItem"/>
														</xsl:apply-templates>
													</xsl:when>
													<xsl:otherwise>
														<dataItemValue refDataItem="{$v_currentRefDataItem}"/>
													</xsl:otherwise>
												</xsl:choose>
											</dataSource>
											<xsl:call-template name="simpleLayoutGroupTemplate">
												<xsl:with-param name="p_cur" select="$v_currentChartLevel"/>
											</xsl:call-template>
										</chartTextItem>
									</chartContents>
									<xsl:if test="$v_currentChartLevel/baltic:chartText and $v_generateChartLabel='1'">
										<chartLabel>
											<chartContents>
												<xsl:choose>
													<xsl:when test="$staticChartLabel = 'true'">
														<!--
														In Bering there is no equivalent refLevel support as in Baltic so turn the 
														refLevel into staticValue to get equivalent labels get display as in Baltic.
														
														V4 example:
														===========
														<chartLevel refLevel="Order method(Aging Buckets)">
															<queryItemRef refItem=""Order method"/>
															<chartText>
																<queryItemRef content="label" refItem="Order method"/>
															</chartText>
														<chartLevel>
														
														
														Resulting V5 is:
														================
														
														
														<chartNodeMember refDataItem="Order method">
															<chartContents>
																<chartTextItem>
																	<dataSource>
																		<memberCaption/>
																	</dataSource>
																</chartTextItem>
															</chartContents>
															<chartLabel>
																<chartContents>
																	<chartTextItem>
																		<dataSource>
																			<staticValue>Order method(Aging Buckets)</staticValue>
																		</dataSource>
																	</chartTextItem>
																</chartContents>
															</chartLabel>
														</chartNodeMember>
														
														
													-->
														<chartTextItem>
															<dataSource>
																<staticValue>
																	<xsl:value-of select="$v_currentLevelName"/>
																</staticValue>
															</dataSource>
														</chartTextItem>
													</xsl:when>
													<xsl:otherwise>
														<xsl:apply-templates select="$v_currentChartLevel/baltic:chartText"/>
													</xsl:otherwise>
												</xsl:choose>
											</chartContents>
										</chartLabel>
									</xsl:if>
									<xsl:call-template name="sortListTemplate">
										<xsl:with-param name="p_cube" select="$p_cube"/>
										<xsl:with-param name="p_refDataItem" select="$v_currentLevelItemRef"/>
										<xsl:with-param name="p_base" select="$p_base"/>
									</xsl:call-template>
								</chartNodeMember>
							</chartNodeMembers>
							<xsl:variable name="v_nextLevelName" select="//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:*[local-name(.)=$p_mode]/baltic:level[position()=$p_pos+1]/@refLevel"/>
							<xsl:variable name="v_nextChartLevel" select="$p_base/baltic:chartLevel[@refLevel=$v_nextLevelName]"/>
							<xsl:choose>
								<xsl:when test="count($v_nextChartLevel) = 1">
									<chartNestedNodes>
										<xsl:call-template name="chartNodeTemplate">
											<xsl:with-param name="p_cube" select="$p_cube"/>
											<xsl:with-param name="p_refQuery" select="$p_refQuery"/>
											<xsl:with-param name="p_mode" select="$p_mode"/>
											<xsl:with-param name="p_base" select="$p_base"/>
											<xsl:with-param name="p_addChartContents" select="$p_addChartContents"/>
											<xsl:with-param name="p_pos" select="$p_pos+1"/>
											<xsl:with-param name="p_checkMeasures" select="$p_checkMeasures"/>
										</xsl:call-template>
									</chartNestedNodes>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="chooseEdgeAndPlaceMeasuresTemplate">
										<xsl:with-param name="p_mode" select="$p_mode"/>
										<xsl:with-param name="p_refQuery" select="$p_refQuery"/>
										<xsl:with-param name="p_checkMeasures" select="$v_checkMeasures"/>
										<xsl:with-param name="p_cube" select="$p_cube"/>
										<xsl:with-param name="p_base" select="$p_base"/>
										<xsl:with-param name="p_addNestedNode" select="'true'"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="chooseEdgeAndPlaceMeasuresTemplate">
								<xsl:with-param name="p_mode" select="$p_mode"/>
								<xsl:with-param name="p_refQuery" select="$p_refQuery"/>
								<xsl:with-param name="p_checkMeasures" select="$v_checkMeasures"/>
								<xsl:with-param name="p_cube" select="$p_cube"/>
								<xsl:with-param name="p_base" select="$p_base"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<!-- Current summary query level not found in the chart.  Skip to next level.  -->
					<chartNodeMembers>
						<xsl:variable name="v_nextLevelName" select="//baltic:BIQuery[@name=$p_refQuery]/baltic:summary/baltic:*[local-name(.)=$p_mode]/baltic:level[position()=$p_pos+1]/@refLevel"/>
						<xsl:variable name="v_nextChartLevel" select="$p_base/baltic:chartLevel[@refLevel=$v_nextLevelName]"/>
						<xsl:if test="count($v_nextChartLevel) = 1">
							<xsl:call-template name="chartNodeTemplate">
								<xsl:with-param name="p_cube" select="$p_cube"/>
								<xsl:with-param name="p_refQuery" select="$p_refQuery"/>
								<xsl:with-param name="p_mode" select="$p_mode"/>
								<xsl:with-param name="p_base" select="$p_base"/>
								<xsl:with-param name="p_addChartContents" select="$p_addChartContents"/>
								<xsl:with-param name="p_pos" select="$p_pos+1"/>
								<xsl:with-param name="p_checkMeasures" select="$p_checkMeasures"/>
							</xsl:call-template>
						</xsl:if>
					</chartNodeMembers>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_chartNodeContents/*">
			<chartNode>
				<xsl:copy-of select="$v_chartNodeContents"/>
			</chartNode>
		</xsl:if>
	</xsl:template>
	<xsl:template name="standardChartAttributesTemplate">
		<!-- refQuery, class, name, repeatEveryPage, showTooltips -->
		<!-- refQuery ==> refQuery -->
		<xsl:variable name="v_refQuery" select="@refQuery"/>
		<xsl:variable name="v_cubeQuery">
			<xsl:call-template name="getQueryTemplate">
				<xsl:with-param name="refQuery" select="$v_refQuery"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:attribute name="refQuery"><xsl:value-of select="$v_cubeQuery"/></xsl:attribute>
		<!-- originalRefQuery is used when looking up the Baltic query from Bering context, and will be removed in later stages. -->
		<xsl:attribute name="originalRefQuery"><xsl:value-of select="$v_refQuery"/></xsl:attribute>
		<!-- class ==> class -->
		<xsl:variable name="v_default">
			<xsl:choose>
				<xsl:when test="@class">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="addStyle">
			<xsl:with-param name="for" select="'chart'"/>
			<xsl:with-param name="default" select="$v_default"/>
		</xsl:call-template>
		<!-- id ==> name -->
		<xsl:variable name="v_id" select="@id"/>
		<xsl:if test="$v_id != ''">
			<xsl:attribute name="name"><xsl:value-of select="$v_id"/></xsl:attribute>
		</xsl:if>
		<!-- repeatEveryPage ==> repeatEveryPage -->
		<xsl:variable name="v_repeatEveryPage" select="@repeatEveryPage"/>
		<xsl:if test="$v_repeatEveryPage != ''">
			<xsl:attribute name="repeatEveryPage"><xsl:value-of select="$v_repeatEveryPage"/></xsl:attribute>
		</xsl:if>
		<!-- tooltips ==> showTooltips -->
		<xsl:variable name="v_tooltips" select="@tooltips"/>
		<xsl:if test="$v_tooltips != ''">
			<xsl:attribute name="showTooltips"><xsl:value-of select="$v_tooltips"/></xsl:attribute>
		</xsl:if>
		<!-- showValues ==> displayDataLocation -->
		<xsl:variable name="v_showValues" select="*[contains(local-name(),'Chart')]/@showValues"/>
		<xsl:if test="$v_showValues != ''">
			<xsl:call-template name="showValuesToLocationTemplate">
				<xsl:with-param name="p_showValues" select="$v_showValues"/>
				<xsl:with-param name="p_addShowValuesAttr">
					<xsl:choose>
						<xsl:when test="*[contains(local-name(),'radarChart')]">true</xsl:when>
						<xsl:when test="*[contains(local-name(),'progressiveChart')]">true</xsl:when>
						<xsl:when test="*[contains(local-name(),'paretoChart')]">true</xsl:when>
						<xsl:otherwise>false</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="commonChartTemplate">
		<xsl:apply-templates select="baltic:title"/>
		<xsl:apply-templates select="baltic:subtitle"/>
		<xsl:apply-templates select="baltic:footer"/>
		<xsl:apply-templates select="baltic:chartBody/baltic:chartPalette"/>
		<xsl:variable name="v_CSS">
			<xsl:call-template name="widthAndHeightTemplate"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="baltic:style">
				<xsl:apply-templates select="baltic:style">
					<xsl:with-param name="p_addValue" select="$v_CSS"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$v_CSS != ''">
					<style>
						<CSS value="{$v_CSS}"/>
					</style>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="baltic:conditionalStyle"/>
		<xsl:apply-templates select="baltic:chartBody"/>
		<xsl:apply-templates select="baltic:background"/>
		<xsl:if test="baltic:note">
			<notes>
				<xsl:apply-templates select="baltic:note"/>
			</notes>
		</xsl:if>
		<xsl:call-template name="drillTargetTemplate"/>
	</xsl:template>
	<xsl:template name="checkSummaryLevelTemplate">
		<xsl:param name="p_mode"/>
		<xsl:param name="p_base" select="."/>
		<xsl:variable name="v_refQuery" select="@refQuery"/>
		<xsl:for-each select="$p_base/baltic:chartLevel">
			<xsl:variable name="v_refDataItem" select="baltic:queryItemRef/@refItem"/>
			<xsl:if test="//baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:*[local-name(.)=$p_mode]/baltic:level/baltic:item[@refItem=$v_refDataItem]">
				<xsl:text>true</xsl:text>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="processAttsTemplate">
		<xsl:param name="p_cur" select="."/>
		<xsl:variable name="v_showValues" select="$p_cur/@showValues"/>
		<xsl:if test="$v_showValues != '' and $v_showValues != 'none'">
			<xsl:attribute name="showValues">true</xsl:attribute>
			<xsl:variable name="v_showValuesLocation" select="$p_cur/@showValues"/>
			<xsl:if test="$v_showValuesLocation != ''">
				<xsl:call-template name="showValuesToLocationTemplate">
					<xsl:with-param name="p_showValues" select="$v_showValuesLocation"/>
					<xsl:with-param name="p_addShowValuesAttr" select="'false'"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="dataPointTemplate">
		<xsl:variable name="v_dataPointShape">
			<xsl:choose>
				<!-- WO1194: piratePlus has been removed as an available marker.  Replace with fatPlus. -->
				<xsl:when test="@markerShape = 'piratePlus'">fatPlus</xsl:when>
				<xsl:when test="@markerShape">
					<xsl:value-of select="@markerShape"/>
				</xsl:when>
				<xsl:otherwise>plainX</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:attribute name="dataPointShape"><xsl:value-of select="$v_dataPointShape"/></xsl:attribute>
		<!-- Note: markerSize is in pixels and must be converted to points for dataPointSize (see Trakker 550271). -->
		<xsl:attribute name="dataPointSize"><xsl:choose><xsl:when test="@markerSize"><xsl:value-of select="@markerSize * 0.75"/></xsl:when><xsl:otherwise>5</xsl:otherwise></xsl:choose></xsl:attribute>
	</xsl:template>
	<xsl:template name="chartMarkerTemplate">
		<xsl:param name="p_chart" select="."/>
		<xsl:param name="p_defaultShape" select="'circle'"/>
		<xsl:param name="p_addDataPointSize"/>
		<xsl:choose>
			<xsl:when test="$p_chart/@depth &gt; 0">
				<!-- See trakker 544100 and 540948.  A Baltic but would not output markers if the depth was not zero. 
                   * Since we are in the middle of an element we cannot output the diagnostic into the XML.
		     -->
				<!-- Gotcha,  markers will be generated unless the dataPointSize is set to 0. -->
				<xsl:attribute name="dataPointSize">0</xsl:attribute>
				<xsl:value-of select="log:logInfo0Void(/baltic:report/logIdentifier/@logId, 'RSU_SPC_DEPTH_OVERRIDES_MARKER')" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="pointChartDataPointShape"><xsl:call-template name="chartMarker"><xsl:with-param name="p_chart" select="$p_chart"/><xsl:with-param name="p_defaultShape" select="$p_defaultShape"/></xsl:call-template></xsl:attribute>
				<xsl:if test="$p_addDataPointSize != 'false'">
					<!-- Note: markerSize is in pixels and must be converted to points for dataPointSize (see Trakker 550271). -->
					<xsl:attribute name="dataPointSize"><xsl:choose><xsl:when test="$p_chart/@markerSize != ''"><xsl:value-of select="$p_chart/@markerSize * 0.75"/></xsl:when><xsl:otherwise>5</xsl:otherwise></xsl:choose></xsl:attribute>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
		 * WO1194: piratePlus has been removed as an available marker.  Replace with fatPlus. 
         * Since we are in the middle of an element we cannot output the diagnostic into the XML.
	-->
	<xsl:template name="chartMarker">
		<xsl:param name="p_chart"/>
		<xsl:param name="p_defaultShape" select="'circle'"/>
		<xsl:choose>
			<!-- WO1194: piratePlus has been removed as an available marker.  Replace with fatPlus. -->
			<xsl:when test="$p_chart/@markerShape = 'piratePlus'">
				<xsl:value-of select="log:logInfo2Void(/baltic:report/logIdentifier/@logId, 'RSU_SPC_OBSOLETE_MARKER', 'piratePlus', 'fatPlus')" xmlns:log="http://developer.cognos.com/schemas/report/2.0/com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.LogMap"/>			
					fatPlus
		    </xsl:when>
			<xsl:when test="$p_chart/@markerShape != ''">
				<xsl:value-of select="$p_chart/@markerShape"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$p_defaultShape"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
      *
      -->
	<xsl:template name="widthAndHeightTemplate">
		<xsl:variable name="v_chartWidth" select="@chartWidth"/>
		<xsl:variable name="v_chartHeight" select="@chartHeight"/>
		<xsl:if test="$v_chartWidth != ''">
			<xsl:text>width:</xsl:text>
			<xsl:value-of select="$v_chartWidth"/>
			<xsl:text>px;</xsl:text>
		</xsl:if>
		<xsl:if test="$v_chartHeight != ''">
			<xsl:text>height:</xsl:text>
			<xsl:value-of select="$v_chartHeight"/>
			<xsl:text>px;</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template name="quadrantLineTemplate">
		<xsl:param name="axisPosition"/>
		<xsl:param name="percentAlongAxis"/>
		<xsl:element name="pointChartBaseline">
			<xsl:attribute name="pointChartAxis"><xsl:choose><xsl:when test="$axisPosition = 'xPosition'"><xsl:text>xAxis</xsl:text></xsl:when><xsl:otherwise><xsl:text>yAxis</xsl:text></xsl:otherwise></xsl:choose></xsl:attribute>
			<xsl:element name="pointChartBaselinePosition">
				<xsl:element name="percentAlongAxis">
					<xsl:attribute name="percentAlongAxis"><xsl:choose><xsl:when test="$percentAlongAxis != ''"><xsl:value-of select="$percentAlongAxis"/></xsl:when><xsl:otherwise><!--Carry the default value from V4 to V5--><xsl:text>50</xsl:text></xsl:otherwise></xsl:choose></xsl:attribute>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template name="sortListTemplate">
		<xsl:param name="p_cube"/>
		<xsl:param name="p_refDataItem"/>
		<xsl:param name="p_base"/>
		<!-- Generate sortList from the baltic:item sort attributes up to this level in the current dimension. 
         *    Beware: some additional stages will clean up this.  In particular sortItems may be duplicated, and the sortOrder may
         *    be invalid, waiting to be set from the tabular model.
          -->
		<sortList>
			<xsl:choose>
				<xsl:when test="$p_cube//baltic:item[@alias=$p_refDataItem]">
					<!-- Items in preceding levels. -->
					<xsl:apply-templates select="$p_cube//baltic:level/baltic:item[@alias=$p_refDataItem]/../preceding-sibling::baltic:level/baltic:item" mode="generate_sortItems"/>
					<!-- All items in same level.-->
					<xsl:apply-templates select="$p_cube//baltic:level/baltic:item[@alias=$p_refDataItem]/../baltic:item" mode="generate_sortItems"/>
					<!-- Named item in factList. -->
					<xsl:apply-templates select="$p_cube/baltic:factList/baltic:item[@alias=$p_refDataItem]" mode="generate_sortItems"/>
				</xsl:when>
				<xsl:when test="$p_cube//baltic:item[@refItem=$p_refDataItem]">
					<!-- Items in preceding levels. -->
					<xsl:apply-templates select="$p_cube//baltic:level/baltic:item[@refItem=$p_refDataItem]/../preceding-sibling::baltic:level/baltic:item" mode="generate_sortItems"/>
					<!-- All items in same level.-->
					<xsl:apply-templates select="$p_cube//baltic:level/baltic:item[@refItem=$p_refDataItem]/../baltic:item" mode="generate_sortItems"/>
					<!-- Named item in factList. -->
					<xsl:apply-templates select="$p_cube/baltic:factList/baltic:item[@refItem=$p_refDataItem]" mode="generate_sortItems"/>
				</xsl:when>
			</xsl:choose>
			<!-- Measures that sort chart node members.  
				* If the chart node members were unsorted, then we are 
				* allowed to change the sort order.  If they were sorted, 
				* the new sorting item is added afterwards and will only be 
				* used in ties.
			-->
			<xsl:for-each select="$p_base">
				<xsl:for-each select="baltic:chartMeasure/baltic:member">
					<xsl:variable name="v_refMember" select="@refMember"/>
					<xsl:choose>
						<xsl:when test="$p_cube/baltic:factList/baltic:item[@alias=$v_refMember]">
							<xsl:apply-templates select="$p_cube/baltic:factList/baltic:item[@alias=$v_refMember]" mode="generate_sortItems"/>
						</xsl:when>
						<xsl:when test="$p_cube/baltic:factList/baltic:item[@refItem=$v_refMember]">
							<xsl:apply-templates select="$p_cube/baltic:factList/baltic:item[@refItem=$v_refMember]" mode="generate_sortItems"/>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:choose>
				<xsl:when test="count($p_base/baltic:chartLevel) = 1 and count($p_base/baltic:chartMeasure) = 1">
					<xsl:variable name="v_refDataItem">
						<xsl:choose>
							<xsl:when test="$p_base/baltic:chartMeasure/baltic:chartText/baltic:queryItemRef/@refItem">
								<xsl:value-of select="$p_base/baltic:chartMeasure/baltic:chartText/baltic:queryItemRef/@refItem"/>
							</xsl:when>
							<xsl:when test="$p_base/baltic:chartMeasure/baltic:member/@refMember">
								<xsl:value-of select="$p_base/baltic:chartMeasure/baltic:member/@refMember"/>
							</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:apply-templates select="$p_cube//baltic:item[@refItem=$v_refDataItem]/../preceding-sibling::baltic:level//baltic:item" mode="generate_sortItems"/>
					<xsl:apply-templates select="$p_cube//baltic:item[@refItem=$v_refDataItem]" mode="generate_sortItems"/>
				</xsl:when>
			</xsl:choose>
		</sortList>
	</xsl:template>
	<xsl:template name="lineStyleTemplate">
		<xsl:param name="p_lineStyle" select="@lineStyle"/>
		<xsl:if test="$p_lineStyle != ''">
			<xsl:attribute name="lineStyle"><xsl:value-of select="translate($p_lineStyle,'ABCDEFGHIJKLMNOPQRSTVWXYZ','abcdefghijklmnopqrstvwxyz')"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template name="processChartMeasuresTemplate">
		<xsl:param name="p_cube"/>
		<xsl:param name="p_base"/>
		<xsl:for-each select="$p_base/baltic:chartMeasure">
			<xsl:variable name="v_refDataItem" select="baltic:member/@refMember"/>
			<chartNodeMember refDataItem="{$v_refDataItem}">
				<chartContents>
					<chartTextItem>
						<dataSource>
							<xsl:choose>
								<xsl:when test="baltic:chartText/baltic:text">
									<xsl:element name="staticValue">
										<xsl:value-of select="baltic:chartText/baltic:text/text()"/>
									</xsl:element>
								</xsl:when>
								<xsl:otherwise>
									<memberCaption/>
								</xsl:otherwise>
							</xsl:choose>
						</dataSource>
					</chartTextItem>
				</chartContents>
				<xsl:call-template name="mergeStylesFromChartBodyAndChartMeasure">
					<xsl:with-param name="p_chartBody" select="$p_base/baltic:chartBody"/>
					<xsl:with-param name="p_chartMeasure" select="."/>
				</xsl:call-template>
				<xsl:call-template name="sortListTemplate">
					<xsl:with-param name="p_cube" select="$p_cube"/>
					<xsl:with-param name="p_refDataItem" select="$v_refDataItem"/>
					<xsl:with-param name="p_base" select="$p_base"/>
				</xsl:call-template>
			</chartNodeMember>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="showValuesToLocationTemplate">
		<xsl:param name="p_showValues"/>
		<xsl:param name="p_addShowValuesAttr" select="'false'"/>
		<xsl:variable name="v_displayDataLocation">
			<xsl:choose>
				<xsl:when test="$p_showValues = 'insideMaximum'">insideAtTop</xsl:when>
				<xsl:when test="$p_showValues = 'outsideMaximum'">outsideAtTop</xsl:when>
				<xsl:when test="$p_showValues = 'insideMinimum'">insideAtBottom</xsl:when>
				<xsl:when test="$p_showValues = 'outsideMinimum'">outsideAtBottom</xsl:when>
				<xsl:when test="$p_showValues = 'center'">centered</xsl:when>
				<xsl:when test="$p_showValues = 'none'"/>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_displayDataLocation != ''">
			<xsl:if test="$p_addShowValuesAttr = 'true'">
				<xsl:attribute name="showValues">true</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="displayDataLocation"><xsl:value-of select="$v_displayDataLocation"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template name="pointsAndPointClustersTemplate">
		<xsl:param name="p_radialClusters"/>
		<xsl:param name="p_checkMeasures" select="'never'"/>
		<xsl:variable name="v_points">
			<xsl:call-template name="chartLevelTemplate">
				<xsl:with-param name="p_mode" select="'rowEdge'"/>
				<xsl:with-param name="p_checkMeasures" select="$p_checkMeasures"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="v_pointClusters">
			<xsl:call-template name="chartLevelTemplate">
				<xsl:with-param name="p_mode" select="'columnEdge'"/>
				<xsl:with-param name="p_checkMeasures" select="$p_checkMeasures"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_points//*">
				<points>
					<xsl:copy-of select="$v_points"/>
				</points>
				<xsl:choose>
					<xsl:when test="$p_radialClusters = 'true'">
						<xsl:if test="$v_pointClusters//*">
							<radialClusters>
								<xsl:copy-of select="$v_pointClusters"/>
							</radialClusters>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="$v_pointClusters//*">
							<pointClusters>
								<xsl:copy-of select="$v_pointClusters"/>
							</pointClusters>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$v_pointClusters//*">
					<points>
						<xsl:copy-of select="$v_pointClusters"/>
					</points>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="baltic:title">
		<xsl:variable name="v_chartTitle">
			<xsl:choose>
				<xsl:when test="baltic:text">
					<xsl:value-of select="baltic:text"/>
				</xsl:when>
				<xsl:when test="baltic:queryItemRef">'true'</xsl:when>
				<xsl:when test="baltic:expression">'true'</xsl:when>
				<xsl:otherwise/>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_chartTitle != ''">
			<chartTitle>
				<xsl:call-template name="addStyle">
					<xsl:with-param name="for" select="'chartTitle'"/>
				</xsl:call-template>
				<chartContents>
					<xsl:call-template name="chartTextTemplate"/>
				</chartContents>
				<xsl:if test="@render = 'false'">
					<style>
						<CSS value="visibility:hidden"/>
					</style>
				</xsl:if>
				<xsl:if test="@render != 'false'">
					<xsl:call-template name="simpleLayoutGroupTemplate">
						<xsl:with-param name="p_cur" select="."/>
					</xsl:call-template>
				</xsl:if>
			</chartTitle>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:title" mode="legend">
		<xsl:call-template name="chartTextTemplate"/>
	</xsl:template>
	<xsl:template match="baltic:title" mode="axis">
		<xsl:call-template name="chartTextTemplate"/>
	</xsl:template>
	<xsl:template match="baltic:subtitle">
		<xsl:variable name="v_chartSubTitle">
			<xsl:choose>
				<xsl:when test="baltic:text">
					<xsl:value-of select="baltic:text"/>
				</xsl:when>
				<xsl:when test="baltic:queryItemRef">'true'</xsl:when>
				<xsl:when test="baltic:expression">'true'</xsl:when>
				<xsl:otherwise/>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_chartSubTitle != ''">
			<chartSubTitle>
				<xsl:call-template name="addStyle">
					<xsl:with-param name="for" select="'chartSubtitle'"/>
				</xsl:call-template>
				<chartContents>
					<xsl:call-template name="chartTextTemplate"/>
				</chartContents>
				<xsl:if test="@render = 'false'">
					<style>
						<CSS value="visibility:hidden"/>
					</style>
				</xsl:if>
				<xsl:if test="@render != 'false'">
					<xsl:call-template name="simpleLayoutGroupTemplate">
						<xsl:with-param name="p_cur" select="."/>
					</xsl:call-template>
				</xsl:if>
			</chartSubTitle>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:footer">
		<xsl:variable name="v_chartFooter">
			<xsl:choose>
				<xsl:when test="baltic:text">
					<xsl:value-of select="baltic:text"/>
				</xsl:when>
				<xsl:when test="baltic:queryItemRef">'true'</xsl:when>
				<xsl:when test="baltic:expression">'true'</xsl:when>
				<xsl:otherwise/>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_chartFooter != ''">
			<chartFooter>
				<xsl:call-template name="addStyle">
					<xsl:with-param name="for" select="'chartFooter'"/>
				</xsl:call-template>
				<chartContents>
					<xsl:call-template name="chartTextTemplate"/>
				</chartContents>
				<xsl:if test="@render = 'false'">
					<style>
						<CSS value="visibility:hidden"/>
					</style>
				</xsl:if>
				<xsl:if test="@render != 'false'">
					<xsl:call-template name="simpleLayoutGroupTemplate">
						<xsl:with-param name="p_cur" select="."/>
					</xsl:call-template>
				</xsl:if>
			</chartFooter>
		</xsl:if>
	</xsl:template>
	<xsl:template name="depthTemplate">
		<xsl:param name="p_defaultDepth" select="'50'"/>
		<xsl:variable name="v_depth">
			<xsl:call-template name="getChartDepth"/>
		</xsl:variable>
		<xsl:attribute name="depth"><xsl:choose><xsl:when test="$v_depth != ''"><xsl:value-of select="$v_depth"/></xsl:when><xsl:otherwise><xsl:value-of select="$p_defaultDepth"/></xsl:otherwise></xsl:choose></xsl:attribute>
	</xsl:template>
	<xsl:template name="getChartDepth">
		<xsl:value-of select="*[contains(local-name(), 'Chart')]/@depth"/>
	</xsl:template>
	<xsl:template name="pointChartShowValuesTemplate">
		<xsl:if test="*[contains(local-name(),'Chart')]/@showValues">
			<xsl:attribute name="showPointValues">valuesAndLabels</xsl:attribute>
		</xsl:if>
		<xsl:if test="*[contains(local-name(),'Chart')]/@showLabels">
			<xsl:attribute name="showPointValuesForPoints">valuesOnly</xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template name="getColorFromCSSTemplate">
		<xsl:param name="inputString"/>
		<xsl:param name="color"/>
		<xsl:choose>
			<xsl:when test="starts-with($inputString, 'color:')">
				<xsl:variable name="tempString" select="substring-after($inputString, 'color:')"/>
				<xsl:choose>
					<xsl:when test="contains($tempString, ';')">
						<xsl:call-template name="getColorFromCSSTemplate">
							<xsl:with-param name="inputString" select="substring-after($tempString, ';')"/>
							<xsl:with-param name="color" select="substring-before($tempString, ';')"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$tempString"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="contains($inputString, ';')">
				<xsl:call-template name="getColorFromCSSTemplate">
					<xsl:with-param name="inputString" select="substring-after($inputString, ';')"/>
					<xsl:with-param name="color" select="$color"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$color"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
        * Output the ordinalAxis
        * @param p_gridlines Should gridlines be generated. 0 is false, 1 is true.
      -->
	<xsl:template name="ordinalAxis">
		<xsl:param name="p_gridLines"/>
		<ordinalAxis>
			<xsl:call-template name="copyTruncationAttsTemplate"/>
			<xsl:call-template name="processAllowAttsTemplate">
				<xsl:with-param name="p_el" select=".."/>
			</xsl:call-template>
			<xsl:call-template name="axisTitleTemplate"/>
			<xsl:if test="$p_gridLines">
				<xsl:call-template name="gridlinesTemplate">
					<xsl:with-param name="p_chart" select=".."/>
					<xsl:with-param name="p_mandatory" select="'true'"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
			<xsl:apply-templates select="baltic:labels/baltic:conditionalStyle"/>
		</ordinalAxis>
	</xsl:template>
</xsl:stylesheet>
