<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<!-- Mapping rules

	/report/querySet/BIQuery/summary/columnEdge/level[1] ==> 
		crosstabColumns/crosstabNode/crosstabNodeMembers/crosstabNodeMember

	/report/querySet/BIQuery/summary/columnEdge/level[>1] ==> 
		crosstabColumns/crosstabNode/crosstabNestedNodes/crosstabNode/crosstabNodeMembers/crosstabNodeMember

	/report/querySet/BIQuery/summary/rowEdge/level[1] ==> 
		crosstabRows/crosstabNode/crosstabNodeMembers/crosstabNodeMember
	
	/report/querySet/BIQuery/summary/rowEdge/level[>1] ==> 
		crosstabRows/crosstabNode/crosstabNestedNodes/crosstabNode/crosstabNodeMembers/crosstabNodeMember
	
	crosstab/crosstabLevel ==> contents/textItem/dataSource/memberCaption
	
	crosstab/crosstabLevel/levelHeader ==> crosstabNode/crosstabNodeMembers/crosstabNodeMember
	
	crosstab/crosstabLevel/levelFooter ==> crosstabNode/crosstabNodeMembers/crosstabNodeMember
	
	crosstab/crosstabLevel/levelHeader ==> add new data item in the query set
	
	crosstab/crosstabLevel/levelFooter ==> add new data item in the query set
	
	If BIQuery/summary/rowEdge/cellMembers
	    crosstab/crosstabMember ==> crosstab/crosstabRows//DEEPEST_CROSSTABNODE/crosstabNestedNodes/crosstabNode/crosstabNodeMember
	If BIQuery/summary/columnEdge/cellMembers
	    crosstab/crosstabMember ==> crosstab/crosstabColumns//DEEPEST_CROSSTABNODE/crosstabNestedNodes/crosstabNode/crosstabNodeMember
	
	Match each crosstab/crosstabCell to crosstab/crosstabMember based on the @refMember attribute.
	Then for each crosstab/crosstabCell ==> crosstab/(crosstabRows or crosstabColumns)//DEEPEST_CROSSTABNODE/crosstabNestedNodes/crosstabNode/crosstabNodeMember/factCell
	
	crosstab/crosstabCell[1] ==> defaultMeasure
	
	crosstab/crosstabCell[1] ==> crosstabFactCell/contents/textItem/dataSource/cellValue
	
	-->
	<xsl:template match="baltic:crosstab">
		<xsl:variable name="v_refQuery" select="@refQuery"/>
		<xsl:element name="crosstab">
			<!-- 
				Process crosstab attributes
					maxRows					==> rowsPerPage
					repeatEveryPage			==> repeatEveryPage
					factCellStylePrecedence	==> factCellStylePrecedence
					keepWithHeader 			==> keepWithNext (on lowest level crosstabRowMember along the row edge)
					keepWithFooter			==> keepWithPrevious (on lowest level crosstabRowMember along the row edge)
					refQuery				==> refQuery
					id						==> name
					class					==> class (new defaults for v5)
			 -->
			<!-- repeatEveryPage ==> repeatEveryPage -->
			<xsl:variable name="v_repeatEveryPage" select="@repeatEveryPage"/>
			<xsl:if test="$v_repeatEveryPage != ''">
				<xsl:attribute name="repeatEveryPage"><xsl:value-of select="$v_repeatEveryPage"/></xsl:attribute>
			</xsl:if>
			<!-- factCellStylePrecedence ==> factCellStylePrecedence -->
			<xsl:variable name="v_factCellStylePrecedence" select="@factCellStylePrecedence"/>
			<xsl:if test="$v_factCellStylePrecedence != ''">
				<xsl:attribute name="factCellStylePrecedence"><xsl:value-of select="$v_factCellStylePrecedence"/></xsl:attribute>
			</xsl:if>
			<xsl:variable name="v_keepWithHeader" select="@keepWithHeader"/>
			<xsl:variable name="v_keepWithFooter" select="@keepWithFooter"/>
			<!-- class ==> class -->
			<xsl:call-template name="addStyle"/>
			<!-- refQuery ==> refQuery -->
			<xsl:attribute name="refQuery"><xsl:call-template name="getQueryTemplate"><xsl:with-param name="refQuery" select="$v_refQuery"/></xsl:call-template></xsl:attribute>
			<!-- originalRefQuery is used for property list fixups, and will be removed in later stages. -->
			<xsl:attribute name="originalRefQuery"><xsl:value-of select="$v_refQuery"/></xsl:attribute>
			<!-- maxRows ==> rowsPerPage -->
			<xsl:if test="@maxRows != ''">
				<xsl:choose>
					<xsl:when test="@maxRows=0">
						<!-- INFINITY -->
						<xsl:attribute name="rowsPerPage">2147483647</xsl:attribute>
					</xsl:when>
					<xsl:when test="@maxRows&gt;0">
						<xsl:attribute name="rowsPerPage"><xsl:value-of select="@maxRows"/></xsl:attribute>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
			<!-- id ==> name -->
			<xsl:variable name="v_name" select="@id"/>
			<xsl:if test="$v_name != ''">
				<xsl:attribute name="name"><xsl:value-of select="$v_name"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:style"/>
			<xsl:if test="baltic:crosstabCorner/*">
				<xsl:apply-templates select="baltic:crosstabCorner"/>
			</xsl:if>
			<xsl:variable name="v_cube">
				<xsl:call-template name="getCubeOrCubeReference">
					<xsl:with-param name="p_queryNode" select="//baltic:BIQuery[@name=$v_refQuery]"/>
				</xsl:call-template>
			</xsl:variable>
			<!-- The structure of the V5 crosstab row and column element is derived from the V4 Summary Query. -->
			<xsl:apply-templates select="/baltic:report/baltic:querySet/baltic:BIQuery[@name=$v_refQuery]" mode="crosstab">
				<xsl:with-param name="p_crosstab" select="."/>
				<xsl:with-param name="p_cube" select="$v_cube/baltic:cube"/>
				<xsl:with-param name="p_keepWithHeader" select="$v_keepWithHeader"/>
				<xsl:with-param name="p_keepWithFooter" select="$v_keepWithFooter"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="baltic:crosstabCell[1]" mode="crosstabFactCell"/>
			<xsl:apply-templates select="baltic:conditionalStyle"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="/baltic:report/baltic:querySet/baltic:BIQuery" mode="crosstab">
		<xsl:param name="p_crosstab"/>
		<xsl:param name="p_cube"/>
		<xsl:param name="p_keepWithHeader"/>
		<xsl:param name="p_keepWithFooter"/>
		<xsl:if test="baltic:summary/baltic:rowEdge/baltic:level[1] or
			baltic:summary/baltic:rowEdge/baltic:cellMembers">
			<xsl:variable name="v_rowNodeStyle">
				<xsl:call-template name="simpleLayoutGroupTemplate">
					<xsl:with-param name="p_cur" select="$p_crosstab//baltic:crosstabRows"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$v_rowNodeStyle/*">
				<crosstabRowNodeStyle>
					<xsl:copy-of select="$v_rowNodeStyle"/>
				</crosstabRowNodeStyle>
			</xsl:if>
			<crosstabRows>
				<xsl:call-template name="processEdgeLevelTemplate">
					<xsl:with-param name="p_edge" select="'rowEdge'"/>
					<xsl:with-param name="p_pos" select="'1'"/>
					<xsl:with-param name="p_crosstab" select="$p_crosstab"/>
					<xsl:with-param name="p_cube" select="$p_cube"/>
					<xsl:with-param name="p_keepWithHeader" select="$p_keepWithHeader"/>
					<xsl:with-param name="p_keepWithFooter" select="$p_keepWithFooter"/>
				</xsl:call-template>
			</crosstabRows>
		</xsl:if>
		<xsl:if test="baltic:summary/baltic:columnEdge/baltic:level[1] or
			baltic:summary/baltic:columnEdge/baltic:cellMembers">
			<xsl:variable name="v_columnNodeStyle">
				<xsl:call-template name="simpleLayoutGroupTemplate">
					<xsl:with-param name="p_cur" select="$p_crosstab//baltic:crosstabColumns[1]"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$v_columnNodeStyle/*">
				<crosstabColumnNodeStyle>
					<xsl:copy-of select="$v_columnNodeStyle"/>
				</crosstabColumnNodeStyle>
			</xsl:if>
			<crosstabColumns>
				<xsl:call-template name="processEdgeLevelTemplate">
					<xsl:with-param name="p_edge" select="'columnEdge'"/>
					<xsl:with-param name="p_pos" select="'1'"/>
					<xsl:with-param name="p_crosstab" select="$p_crosstab"/>
					<xsl:with-param name="p_cube" select="$p_cube"/>
					<xsl:with-param name="p_keepWithHeader" select="$p_keepWithHeader"/>
					<xsl:with-param name="p_keepWithFooter" select="$p_keepWithFooter"/>
				</xsl:call-template>
			</crosstabColumns>
		</xsl:if>
		<!--	Add defaultMeasure if there's only one crosstabCell.	-->
		<xsl:variable name="crosstabCells" select="$p_crosstab//baltic:crosstabCell"/>
		<xsl:if test="count($crosstabCells) = 1">
			<defaultMeasure refDataItem="{$crosstabCells/baltic:member/@refMember}"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="/baltic:report/baltic:querySet/baltic:BIQuery/baltic:summary/*/baltic:level" mode="crosstab">
		<xsl:param name="p_crosstab"/>
		<xsl:param name="p_cube"/>
		<xsl:param name="p_keepWithNext"/>
		<xsl:param name="p_keepWithPrevious"/>
		<xsl:variable name="v_refLevel" select="@refLevel"/>
		<xsl:variable name="v_refDataItem">
			<xsl:call-template name="getKeyItemNameForLevel">
				<xsl:with-param name="p_level" select="$p_cube//baltic:level[@name=$v_refLevel]"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_refDataItem='ERROR: Cannot find item or dataItem for the level referenced.'">
				<xsl:comment>
					<xsl:call-template name="logError2">
						<xsl:with-param name="p_msgId" select="'RSU_SPC_LEVEL_KEYITEM_MISSING'"/>
						<xsl:with-param name="p_param1" select="'crosstabNodeMember'"/>
						<xsl:with-param name="p_param2" select="$v_refLevel"/>
					</xsl:call-template>
				</xsl:comment>
			</xsl:when>
			<xsl:otherwise>
				<crosstabNodeMember>
					<!-- Remember the refLevel so it can be used for looking up property items. -->
					<xsl:attribute name="originalRefLevel"><xsl:value-of select="$v_refLevel"/></xsl:attribute>
					<xsl:call-template name="nextPreviousTemplate">
						<xsl:with-param name="p_keepWithNext" select="$p_keepWithNext"/>
						<xsl:with-param name="p_keepWithPrevious" select="$p_keepWithPrevious"/>
					</xsl:call-template>
					<xsl:attribute name="refDataItem"><xsl:value-of select="$v_refDataItem"/></xsl:attribute>
					<xsl:call-template name="addStyle">
						<xsl:with-param name="for" select="'crosstabLevel'"/>
					</xsl:call-template>
					<xsl:apply-templates select="$p_crosstab//baltic:crosstabLevel[@refLevel=$v_refLevel]">
						<xsl:with-param name="p_cube" select="$p_cube"/>
						<xsl:with-param name="p_refDataItem" select="$v_refDataItem"/>
					</xsl:apply-templates>
					<xsl:element name="propertyList"/>
				</crosstabNodeMember>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="baltic:crosstabLevel" name="crosstabLevelTemplate">
		<xsl:param name="p_cube"/>
		<xsl:param name="p_refDataItem"/>
		<xsl:call-template name="layoutContainerGroupTemplate"/>
		<!-- Generate sortList from the baltic:item sort attributes for this level. -->
		<sortList>
			<xsl:choose>
				<xsl:when test="$p_cube//baltic:item[@alias=$p_refDataItem]">
					<xsl:apply-templates select="$p_cube//baltic:item[@alias=$p_refDataItem]/preceding-sibling::baltic:item" mode="generate_sortItems"/>
					<xsl:apply-templates select="$p_cube//baltic:item[@alias=$p_refDataItem]" mode="generate_sortItems"/>
				</xsl:when>
				<xsl:when test="$p_cube//baltic:item[@refItem=$p_refDataItem]">
					<xsl:apply-templates select="$p_cube//baltic:item[@refItem=$p_refDataItem]/preceding-sibling::baltic:item" mode="generate_sortItems"/>
					<xsl:apply-templates select="$p_cube//baltic:item[@refItem=$p_refDataItem]" mode="generate_sortItems"/>
				</xsl:when>
			</xsl:choose>
		</sortList>
		<xsl:call-template name="simpleLayoutGroupTemplate"/>
	</xsl:template>
	<xsl:template match="baltic:crosstabMember">
		<xsl:variable name="var_refMember" select="@refMember"/>
		<crosstabNodeMember>
			<xsl:attribute name="refDataItem"><xsl:value-of select="$var_refMember"/></xsl:attribute>
			<!-- Trakker 490878: Must specify solveOrder="1" for crosstab cells.  Otherwise calculated dataItems are not aggregated correctly. -->
			<xsl:attribute name="solveOrder">1</xsl:attribute>
			<xsl:call-template name="addStyle"/>
			<xsl:call-template name="layoutContainerGroupTemplate"/>
			<xsl:apply-templates select="../baltic:crosstabCell[baltic:member/@refMember=$var_refMember]" mode="factCell"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
			<!-- 
				Trakker 533136.1.  Make sure all crosstabNodeMember elements have a propertyList that can be used
			    by the PropertyListAdjuster class to add propertyItems.
			-->
			<propertyList/>
		</crosstabNodeMember>
	</xsl:template>
	<xsl:template match="baltic:crosstabCorner">
		<crosstabCorner>
			<xsl:call-template name="layoutContainerTemplate"/>
		</crosstabCorner>
	</xsl:template>
	<xsl:template match="baltic:crosstabCell" mode="crosstabFactCell">
		<crosstabFactCell>
			<xsl:choose>
				<xsl:when test="@class">
					<xsl:call-template name="addStyle"/>
				</xsl:when>
				<xsl:otherwise>
					<!-- Default to crosstabFactCell style. -->
					<xsl:attribute name="class">mv</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="count(../baltic:crosstabCell) = 1">
					<!-- When there is only one crosstabCell, it is safe to generate all of the layout information in the crosstabFactCell. -->
					<xsl:call-template name="layoutContainerGroupTemplate"/>
					<xsl:call-template name="simpleLayoutGroupTemplate">
						<xsl:with-param name="p_recursive" select="'false'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- When there are many crosstabCells, just generate a vanilla crosstabFactCell. -->
					<!-- Each crosstabCell will be mapped to the corresponding crosstabMember's factCell. -->
					<contents>
						<textItem>
							<dataSource>
								<cellValue/>
							</dataSource>
						</textItem>
					</contents>
				</xsl:otherwise>
			</xsl:choose>
		</crosstabFactCell>
	</xsl:template>
	<xsl:template match="baltic:crosstabCell" mode="factCell">
		<factCell>
			<xsl:if test="@class">
				<xsl:call-template name="addStyle"/>
			</xsl:if>
			<xsl:call-template name="layoutContainerGroupTemplate"/>
			<xsl:call-template name="simpleLayoutGroupTemplate">
				<xsl:with-param name="p_recursive" select="'false'"/>
			</xsl:call-template>
		</factCell>
	</xsl:template>
	<xsl:template name="processCrosstabHeaderFooterTemplate">
		<!-- 
		* This template generates a crosstabNode from a baltic:levelHeader or baltic:levelFooter.
		-->
		<xsl:param name="p_crosstab"/>
		<xsl:param name="p_refLevel"/>
		<xsl:param name="p_refItem"/>
		<xsl:param name="p_hf"/>
		<xsl:param name="p_keepWithNext"/>
		<xsl:param name="p_keepWithPrevious"/>
		<xsl:param name="p_cellMembers" select="false()"/>
		<xsl:variable name="v_crosstabLevel" select="$p_crosstab//baltic:crosstabLevel"/>
		<!-- Generate crosstabNode for baltic:levelHeader or baltic:levelFooter. -->
		<crosstabNode>
			<crosstabNodeMembers>
				<crosstabNodeMember>
					<xsl:call-template name="nextPreviousTemplate">
						<xsl:with-param name="p_keepWithNext" select="$p_keepWithNext"/>
						<xsl:with-param name="p_keepWithPrevious" select="$p_keepWithPrevious"/>
					</xsl:call-template>
					<xsl:attribute name="refDataItem">aggregate(<xsl:value-of select="$p_refItem"/>)</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$p_crosstab//baltic:crosstabLevel[@refLevel=$p_refLevel]/baltic:levelHeader">
							<xsl:call-template name="addStyle">
								<xsl:with-param name="for" select="'levelHeader'"/>
							</xsl:call-template>
							<xsl:call-template name="layoutContainerGroupTemplate">
								<xsl:with-param name="p_cur" select="$p_crosstab//baltic:crosstabLevel[@refLevel=$p_refLevel]/baltic:levelHeader"/>
							</xsl:call-template>
							<xsl:call-template name="simpleLayoutGroupTemplate">
								<xsl:with-param name="p_cur" select="$p_crosstab//baltic:crosstabLevel[@refLevel=$p_refLevel]/baltic:levelHeader"/>
							</xsl:call-template>
							<factCell>
								<xsl:call-template name="addStyle">
									<xsl:with-param name="for" select="'levelCells'"/>
								</xsl:call-template>
								<xsl:call-template name="simpleLayoutGroupTemplate">
									<xsl:with-param name="p_cur" select="$p_crosstab//baltic:crosstabLevel[@refLevel=$p_refLevel]/baltic:levelHeader/baltic:levelCells"/>
								</xsl:call-template>
							</factCell>
						</xsl:when>
						<xsl:when test="$p_crosstab//baltic:crosstabLevel[@refLevel=$p_refLevel]/baltic:levelFooter">
							<xsl:call-template name="addStyle">
								<xsl:with-param name="for" select="'levelFooter'"/>
							</xsl:call-template>
							<xsl:call-template name="layoutContainerGroupTemplate">
								<xsl:with-param name="p_cur" select="$p_crosstab//baltic:crosstabLevel[@refLevel=$p_refLevel]/baltic:levelFooter"/>
							</xsl:call-template>
							<xsl:call-template name="simpleLayoutGroupTemplate">
								<xsl:with-param name="p_cur" select="$p_crosstab//baltic:crosstabLevel[@refLevel=$p_refLevel]/baltic:levelFooter"/>
							</xsl:call-template>
							<factCell>
								<xsl:call-template name="addStyle">
									<xsl:with-param name="for" select="'levelCells'"/>
								</xsl:call-template>
								<xsl:call-template name="simpleLayoutGroupTemplate">
									<xsl:with-param name="p_cur" select="$p_crosstab//baltic:crosstabLevel[@refLevel=$p_refLevel]/baltic:levelFooter/baltic:levelCells"/>
								</xsl:call-template>
							</factCell>
						</xsl:when>
					</xsl:choose>
					<xsl:element name="propertyList"/>
				</crosstabNodeMember>
			</crosstabNodeMembers>
			<xsl:if test="$p_cellMembers and $p_crosstab//baltic:crosstabMember">
				<crosstabNestedNodes>
					<crosstabNode>
						<crosstabNodeMembers>
							<xsl:apply-templates select="$p_crosstab//baltic:crosstabMember"/>
						</crosstabNodeMembers>
					</crosstabNode>
				</crosstabNestedNodes>
			</xsl:if>
		</crosstabNode>
	</xsl:template>
	<xsl:template name="addHYStyle">
		<xsl:param name="p_el" select="."/>
		<xsl:variable name="v_default">
			<xsl:choose>
				<xsl:when test="$p_el/@class">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="addStyle">
			<xsl:with-param name="el" select="$p_el"/>
			<xsl:with-param name="for" select="'hyperlink'"/>
			<xsl:with-param name="default" select="'false'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="processEdgeLevelTemplate">
		<!-- 
			* This template generates a crosstabNode for a specific summary query level indexed by p_pos.
		-->
		<xsl:param name="p_edge"/>
		<!-- p_edge specifies whether this level is on the 'rowEdge' or 'columnEdge' -->
		<xsl:param name="p_pos" select="'1'"/>
		<xsl:param name="p_crosstab"/>
		<xsl:param name="p_cube"/>
		<xsl:param name="p_keepWithHeader"/>
		<xsl:param name="p_keepWithFooter"/>
		<xsl:variable name="v_rowsHaveCellMembers" select="count(baltic:summary/baltic:*[local-name()=$p_edge]/baltic:cellMembers) &gt; 0"/>
		<xsl:variable name="v_refLevel" select="baltic:summary/baltic:*[local-name()=$p_edge]/baltic:level[position()=$p_pos]/@refLevel"/>
		<xsl:variable name="v_refItem">
			<xsl:call-template name="getItemNameFromLevelReference">
				<xsl:with-param name="p_queryName" select="@name"/>
				<xsl:with-param name="p_levelRef" select="$v_refLevel"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="v_isDeepestLevelOnEdge">
			<xsl:choose>
				<!-- Is there another level on this edge? -->
				<xsl:when test="baltic:summary/baltic:*[local-name()=$p_edge]/baltic:level[position()=$p_pos+1]">
					<xsl:value-of select="'false'"/>
					<!-- There is another level on this edge, then this one is not the deepest. -->
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'true'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_keepWithNext">
			<!-- keepWithHeader ==> keepWithNext 
				(only on lowest level crosstabRowMember along the row edge) -->
			<xsl:choose>
				<xsl:when test="$p_edge = 'rowEdge' and $v_isDeepestLevelOnEdge = 'true'">
					<xsl:value-of select="$p_keepWithHeader"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_keepWithPrevious">
			<!-- keepWithFooter ==> keepWithPrevious 
				(only on lowest level crosstabRowMember along the row edge) -->
			<xsl:choose>
				<xsl:when test="$p_edge = 'rowEdge' and $v_isDeepestLevelOnEdge = 'true'">
					<xsl:value-of select="$p_keepWithFooter"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_levelHasHeader">
			<xsl:choose>
				<xsl:when test="$p_crosstab//baltic:crosstabLevel[@refLevel=$v_refLevel]/baltic:levelHeader">
					<xsl:value-of select="'true'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'false'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="v_levelHasFooter">
			<xsl:choose>
				<xsl:when test="$p_crosstab//baltic:crosstabLevel[@refLevel=$v_refLevel]/baltic:levelFooter">
					<xsl:value-of select="'true'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'false'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$v_levelHasHeader = 'true'">
			<!-- Process crosstabHeader for this level. -->
			<xsl:call-template name="processCrosstabHeaderFooterTemplate">
				<xsl:with-param name="p_crosstab" select="$p_crosstab"/>
				<xsl:with-param name="p_refLevel" select="$v_refLevel"/>
				<xsl:with-param name="p_refItem" select="$v_refItem"/>
				<xsl:with-param name="p_hf" select="'baltic:levelHeader'"/>
				<xsl:with-param name="p_keepWithNext" select="''"/>
				<xsl:with-param name="p_keepWithPrevious" select="''"/>
				<xsl:with-param name="p_cellMembers" select="$v_rowsHaveCellMembers"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="baltic:summary/baltic:*[local-name()=$p_edge]/baltic:level">
				<crosstabNode>
					<xsl:choose>
						<xsl:when test="$v_levelHasFooter = 'true'">
							<crosstabNodeMembers>
								<!-- There is a crosstabFooter, this is not the deepest crosstabNodeMember. -->
								<!-- Do not set the keepWithHeader / keepWithFooter. -->
								<xsl:apply-templates select="baltic:summary/baltic:*[local-name()=$p_edge]/baltic:level[position()=$p_pos]" mode="crosstab">
									<xsl:with-param name="p_crosstab" select="$p_crosstab"/>
									<xsl:with-param name="p_cube" select="$p_cube"/>
									<xsl:with-param name="p_keepWithHeader" select="''"/>
									<xsl:with-param name="p_keepWithFooter" select="''"/>
								</xsl:apply-templates>
							</crosstabNodeMembers>
						</xsl:when>
						<xsl:otherwise>
							<crosstabNodeMembers>
								<!-- No crosstabFooter, this may be the deepest crosstabNodeMember. -->
								<xsl:apply-templates select="baltic:summary/baltic:*[local-name()=$p_edge]/baltic:level[position()=$p_pos]" mode="crosstab">
									<xsl:with-param name="p_crosstab" select="$p_crosstab"/>
									<xsl:with-param name="p_cube" select="$p_cube"/>
									<xsl:with-param name="p_keepWithNext" select="$v_keepWithNext"/>
									<xsl:with-param name="p_keepWithPrevious" select="$v_keepWithPrevious"/>
								</xsl:apply-templates>
							</crosstabNodeMembers>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="baltic:summary/baltic:*[local-name()=$p_edge]/baltic:level[position()=$p_pos+1]">
							<crosstabNestedNodes>
								<xsl:call-template name="processEdgeLevelTemplate">
									<xsl:with-param name="p_edge" select="$p_edge"/>
									<xsl:with-param name="p_pos" select="$p_pos+1"/>
									<xsl:with-param name="p_crosstab" select="$p_crosstab"/>
									<xsl:with-param name="p_cube" select="$p_cube"/>
									<xsl:with-param name="p_keepWithHeader" select="$p_keepWithHeader"/>
									<xsl:with-param name="p_keepWithFooter" select="$p_keepWithFooter"/>
								</xsl:call-template>
							</crosstabNestedNodes>
						</xsl:when>
						<xsl:when test="baltic:summary/baltic:*[local-name()=$p_edge]/baltic:cellMembers">
							<crosstabNestedNodes>
								<crosstabNode>
									<crosstabNodeMembers>
										<xsl:apply-templates select="$p_crosstab//baltic:crosstabMember"/>
									</crosstabNodeMembers>
								</crosstabNode>
							</crosstabNestedNodes>
						</xsl:when>
					</xsl:choose>
				</crosstabNode>
			</xsl:when>
			<xsl:when test="baltic:summary/baltic:*[local-name()=$p_edge]/baltic:cellMembers">
				<xsl:for-each select="$p_crosstab//baltic:crosstabMember">
					<crosstabNode>
						<crosstabNodeMembers>
							<xsl:apply-templates select="."/>
						</crosstabNodeMembers>
					</crosstabNode>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="$v_levelHasFooter = 'true'">
			<!-- Process crosstabFooter for this level. -->
			<xsl:call-template name="processCrosstabHeaderFooterTemplate">
				<xsl:with-param name="p_crosstab" select="$p_crosstab"/>
				<xsl:with-param name="p_refLevel" select="$v_refLevel"/>
				<xsl:with-param name="p_refItem" select="$v_refItem"/>
				<xsl:with-param name="p_hf" select="'baltic:levelFooter'"/>
				<xsl:with-param name="p_keepWithNext" select="$v_keepWithNext"/>
				<xsl:with-param name="p_keepWithPrevious" select="$v_keepWithPrevious"/>
				<xsl:with-param name="p_cellMembers" select="$v_rowsHaveCellMembers"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="nextPreviousTemplate">
		<xsl:param name="p_keepWithNext"/>
		<xsl:param name="p_keepWithPrevious"/>
		<xsl:if test="$p_keepWithNext != ''">
			<xsl:attribute name="keepWithNext"><xsl:value-of select="$p_keepWithNext"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$p_keepWithPrevious != ''">
			<xsl:attribute name="keepWithPrevious"><xsl:value-of select="$p_keepWithPrevious"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:style" mode="formatOnly">
		<xsl:call-template name="formatGroupTemplate"/>
	</xsl:template>
	<xsl:template match="baltic:style" mode="CSSOnly">
		<xsl:apply-templates select="baltic:CSS"/>
	</xsl:template>
</xsl:stylesheet>
