<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns:mlt="http://myLookupTable/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl mlt">
	<!-- Start of dataFormat lookup table. -->
	<mlt:v4_dataFormat name="stringFormat"/>
	<mlt:v4_dataFormat name="numberFormat"/>
	<mlt:v4_dataFormat name="currencyFormat"/>
	<mlt:v4_dataFormat name="percentFormat"/>
	<mlt:v4_dataFormat name="dateFormat"/>
	<mlt:v4_dataFormat name="timeFormat"/>
	<mlt:v4_dataFormat name="dateTimeFormat"/>
	<mlt:v4_dataFormat name="intervalFormat"/>
	<mlt:v4_dataFormat name="format"/>
	<xsl:variable name="v_dataFormats" select="document('')/*/mlt:v4_dataFormat"/>
	<!-- End of dataFormat lookup table. -->
	<xsl:template name="formatGroupTemplate">
		<xsl:param name="p_recursive" select="'false'"/>
		<xsl:param name="p_includeDataFormatElement" select="'true'"/>
		<xsl:choose>
			<xsl:when test="$p_recursive = 'true'">
				<xsl:for-each select="../*[local-name()!='CSS']">
					<xsl:variable name="v_currentFormat" select="local-name(.)"/>
					<xsl:if test="count($v_dataFormats[@name=$v_currentFormat]) = 1">
						<xsl:choose>
							<xsl:when test="$p_includeDataFormatElement = 'true'">
								<dataFormat>
									<xsl:apply-templates select="."/>
								</dataFormat>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="*[local-name()!='CSS']">
					<xsl:variable name="v_currentFormat" select="local-name(.)"/>
					<xsl:if test="count($v_dataFormats[@name=$v_currentFormat]) = 1">
						<xsl:choose>
							<xsl:when test="$p_includeDataFormatElement = 'true'">
								<dataFormat>
									<xsl:apply-templates select="."/>
								</dataFormat>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="baltic:stringFormat">
		<stringFormat>
			<xsl:call-template name="copyFormatAttributesTemplate"/>
		</stringFormat>
	</xsl:template>
	<xsl:template match="baltic:numberFormat">
		<numberFormat>
			<xsl:call-template name="copyFormatAttributesTemplate"/>
		</numberFormat>
	</xsl:template>
	<xsl:template match="baltic:currencyFormat">
		<currencyFormat>
			<xsl:call-template name="copyFormatAttributesTemplate"/>
		</currencyFormat>
	</xsl:template>
	<xsl:template match="baltic:percentFormat">
		<percentFormat>
			<xsl:for-each select="attribute::*">
				<xsl:if test="name(.) != 'xml:lang'">
					<!-- Do not copy xml:lang attributes -->
					<xsl:if test="local-name(.) = 'scale' and . != '%'">
						<!-- Do not copy scale="%" attributes -->
						<xsl:copy/>
					</xsl:if>
					<xsl:if test="local-name(.) != 'scale'">
						<!-- Copy all other attributes -->
						<xsl:choose>
							<xsl:when test="local-name(.) = 'percentScale'">
								<xsl:if test=". &gt;= 0">
									<!-- negate positive percentScale drop negative scales -->
									<xsl:attribute name="percentScale"><xsl:value-of select="0 - ."/></xsl:attribute>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:copy/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</percentFormat>
	</xsl:template>
	<xsl:template match="baltic:dateFormat">
		<dateFormat>
			<xsl:call-template name="copyFormatAttributesTemplate"/>
		</dateFormat>
	</xsl:template>
	<xsl:template match="baltic:timeFormat">
		<timeFormat>
			<xsl:call-template name="copyFormatAttributesTemplate"/>
		</timeFormat>
	</xsl:template>
	<xsl:template match="baltic:dateTimeFormat">
		<dateTimeFormat>
			<xsl:call-template name="copyFormatAttributesTemplate"/>
		</dateTimeFormat>
	</xsl:template>
	<xsl:template match="baltic:intervalFormat">
		<intervalFormat>
			<xsl:call-template name="copyFormatAttributesTemplate"/>
		</intervalFormat>
	</xsl:template>
	<xsl:template match="baltic:format">
		<format>
			<xsl:call-template name="copyFormatAttributesTemplate"/>
		</format>
	</xsl:template>
	<xsl:template name="copyFormatAttributesTemplate">
		<xsl:for-each select="attribute::*">
			<xsl:if test="name(.) != 'xml:lang'">
				<!-- Do not copy xml:lang attributes -->
				<xsl:copy/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
