<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:textItem">
		<textItem>
			<xsl:call-template name="textFrameTemplate"/>
		</textItem>
	</xsl:template>
	<xsl:template match="baltic:image">
		<image>
			<xsl:call-template name="imageFrameTemplate"/>
		</image>
	</xsl:template>
	<xsl:template match="baltic:hyperlink">
		<hyperlink>
			<xsl:call-template name="actionFrameTemplate"/>
		</hyperlink>
	</xsl:template>
	<xsl:template match="baltic:button">
		<button>
			<xsl:call-template name="actionFrameTemplate"/>
		</button>
	</xsl:template>
	<xsl:template match="baltic:promptButton">
		<promptButton>
			<xsl:call-template name="promptButtonFrameTemplate"/>
		</promptButton>
	</xsl:template>
	<xsl:template match="baltic:HTMLItem">
		<HTMLItem>
			<xsl:call-template name="HTMLFrameTemplate"/>
		</HTMLItem>
	</xsl:template>
	<xsl:template match="baltic:XMLItem">
		<!--The XMLItem was not supported in baltic and therefore is not being migrated.-->
		<xsl:call-template name="notImplemented">
			<xsl:with-param name="p_target">XMLItem</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="baltic:bookmark">
		<bookmark>
			<xsl:call-template name="bookmarkTypeTemplate"/>
		</bookmark>
	</xsl:template>
	<xsl:template name="textFrameTemplate">
		<!-- NOTE: The following attributes  were not supported in baltic and therefore are not being migrated:
		       repeatEveryPage, keepTogether, keepWithGroup, pageBreak, resetPageNumber, resetPageCount and showContinuation.
		-->
		<xsl:if test="count(@maxCharacters) = 1">
			<xsl:attribute name="maxCharacters"><xsl:value-of select="@maxCharacters"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="count(@id) = 1">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
		</xsl:if>
		<xsl:call-template name="addStyle"/>
		<xsl:variable name="v_refVariableExists">
			<xsl:call-template name="checkRefVariableTemplate"/>
		</xsl:variable>
		<xsl:if test="count(@refVariable) = 1 and $v_refVariableExists = 'true' and count(baltic:text[@refVariableValue]) &gt; 0">
			<!-- Generate a conditionalDataSources -->
			<conditionalDataSources>
				<xsl:attribute name="refVariable"><xsl:value-of select="@refVariable"/></xsl:attribute>
				<xsl:apply-templates select="baltic:text[@refVariableValue]"/>
			</conditionalDataSources>
		</xsl:if>
		<xsl:variable name="v_text">
			<xsl:apply-templates select="baltic:text[not(@refVariableValue)]"/>
		</xsl:variable>
		<xsl:variable name="v_expression">
			<xsl:apply-templates select="baltic:expression"/>
		</xsl:variable>
		<xsl:variable name="v_queryItemRef">
			<xsl:apply-templates select="baltic:queryItemRef"/>
		</xsl:variable>
		<dataSource>
			<xsl:apply-templates select="comment()"/> <!-- Harvest comments in case there were expression parsing errors. -->
			<xsl:choose>
				<xsl:when test="$v_text/*">
					<xsl:copy-of select="$v_text"/>
				</xsl:when>
				<xsl:when test="$v_expression/*">
					<xsl:copy-of select="$v_expression"/>
				</xsl:when>
				<xsl:when test="$v_queryItemRef/*">
					<xsl:copy-of select="$v_queryItemRef"/>
				</xsl:when>
				<xsl:otherwise>
					<staticValue/>
				</xsl:otherwise>
			</xsl:choose>
		</dataSource>
		<xsl:call-template name="drillTargetTemplate">
			<xsl:with-param name="p_drillTargets" select="baltic:drillTarget"/>
		</xsl:call-template>
		<xsl:call-template name="simpleLayoutGroupTemplate"/>
	</xsl:template>
	<xsl:template match="baltic:text[not(@refVariableValue)]">
		<staticValue>
			<xsl:apply-templates/>
		</staticValue>
	</xsl:template>
	<xsl:template match="baltic:text[@refVariableValue]">
		<conditionalDataSource refVariableValue="{@refVariableValue}">
			<staticValue>
				<xsl:apply-templates/>
			</staticValue>
		</conditionalDataSource>
	</xsl:template>
	<xsl:template name="imageFrameTemplate">
		<xsl:if test="count(@id) = 1">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
		</xsl:if>
		<xsl:call-template name="addStyle">
			<xsl:with-param name="default" select="'false'"/>
		</xsl:call-template>
		<dataSource>
			<xsl:call-template name="actionSourceGroupTemplate"/>
		</dataSource>
		<xsl:call-template name="simpleLayoutGroupTemplate"/>
		<xsl:call-template name="drillTargetTemplate">
			<xsl:with-param name="p_drillTargets" select="baltic:drillTarget"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="actionFrameTemplate">
		<xsl:if test="count(@id) = 1">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
		</xsl:if>
		<xsl:call-template name="addStyle"/>
		<dataSource>
			<xsl:call-template name="actionSourceGroupTemplate"/>
		</dataSource>
		<xsl:call-template name="layoutItemGroupTemplate"/>
		<xsl:call-template name="simpleLayoutGroupTemplate"/>
	</xsl:template>
	<xsl:template name="promptButtonFrameTemplate">
		<xsl:if test="count(@type) = 1">
			<xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="count(@id) = 1">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
		</xsl:if>
		<xsl:call-template name="addStyle"/>
		<xsl:call-template name="layoutItemGroupTemplate"/>
		<xsl:call-template name="simpleLayoutGroupTemplate"/>
	</xsl:template>
	<xsl:template name="HTMLFrameTemplate">
		<xsl:if test="count(@id) = 1">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
		</xsl:if>
		<!-- Yes, believe it or not, the description property of the HTML Item is stored in an XML comment below the HTMLItem element... -->
		<xsl:if test="child::comment()">
			<xsl:attribute name="description"><xsl:value-of select="child::comment()"/></xsl:attribute>
		</xsl:if>
		<dataSource>
			<xsl:apply-templates select="baltic:HTML"/>
			<xsl:apply-templates select="comment()"/> <!-- Harvest comments in case there were expression parsing errors. -->
			<xsl:apply-templates select="baltic:expression"/>
			<xsl:apply-templates select="baltic:queryItemRef"/>
		</dataSource>
	</xsl:template>
	<xsl:template name="bookmarkTypeTemplate">
		<dataSource>
			<xsl:apply-templates select="baltic:label"/>
			<xsl:apply-templates select="comment()"/> <!-- Harvest comments in case there were expression parsing errors. -->
			<xsl:apply-templates select="baltic:expression"/>
			<xsl:apply-templates select="baltic:queryItemRef"/>
		</dataSource>
	</xsl:template>
	<xsl:template name="actionSourceGroupTemplate">
		<xsl:apply-templates select="baltic:URL"/>
		<xsl:apply-templates select="comment()"/> <!-- Harvest comments in case there were expression parsing errors. -->
		<xsl:apply-templates select="baltic:expression"/>
		<xsl:apply-templates select="baltic:queryItemRef"/>
	</xsl:template>
	<xsl:template name="layoutItemGroupTemplate">
		<contents>
			<xsl:for-each select="*">
				<xsl:if test="local-name(.) = 'table'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'block'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'textItem'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'image'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'hyperlink'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'button'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'promptButton'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'HTMLItem'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'XMLItem'">
					<xsl:apply-templates select="."/>
				</xsl:if>
				<xsl:if test="local-name(.) = 'bookmark'">
					<xsl:apply-templates select="."/>
				</xsl:if>
			</xsl:for-each>
		</contents>
	</xsl:template>
	<xsl:template match="baltic:URL">
		<staticValue>
			<xsl:value-of select="@href"/>
		</staticValue>
	</xsl:template>
	<xsl:template match="baltic:HTML">
		<staticValue>
			<xsl:apply-templates/>
		</staticValue>
	</xsl:template>
	<xsl:template match="baltic:label">
		<staticValue>
			<xsl:apply-templates/>
		</staticValue>
	</xsl:template>
	<xsl:template match="baltic:expression">
		<reportExpression>
			<xsl:if test="@upgradeNoteId">
				<xsl:attribute name="upgradeNoteId"><xsl:value-of select="@upgradeNoteId"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates/>
		</reportExpression>
	</xsl:template>
	<xsl:template match="baltic:queryItemRef[@content='value']">
		<dataItemValue>
			<xsl:attribute name="refDataItem"><xsl:value-of select="@refItem"/></xsl:attribute>
			<xsl:apply-templates/>
		</dataItemValue>
	</xsl:template>
	<xsl:template match="baltic:queryItemRef[@content='label']">
		<!-- NOTE: Although documented in the v4 schema, the level and overall child elements (queryLevelRefGroup) are not supported. -->
		<xsl:variable name="v_refItem" select="@refItem"/>
		<xsl:choose>
			<xsl:when test="//baltic:dataItem[@name=$v_refItem] or //baltic:item[@refItem=$v_refItem] or //baltic:item[@alias=$v_refItem]">
				<dataItemLabel>
					<xsl:attribute name="refDataItem"><xsl:value-of select="$v_refItem"/></xsl:attribute>
					<xsl:apply-templates/>
				</dataItemLabel>
			</xsl:when>
			<xsl:otherwise>
				<staticValue>
					<xsl:value-of select="$v_refItem"/>
				</staticValue>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="baltic:queryItemRef">
		<!-- NOTE: Although documented in the v4 schema, the level and overall child elements (queryLevelRefGroup) are not supported. -->
		<xsl:param name="p_currentRefDataItem"/>
		<xsl:variable name="v_refItem" select="@refItem"/>
		<xsl:choose>
			<!-- When inside a crosstabCell and the refItem attribute matches the member[@refMember], generate a cellValue.  -->
			<xsl:when test="ancestor::baltic:crosstabCell/baltic:member[@refMember=$v_refItem]">
				<cellValue/>
			</xsl:when>
			<xsl:otherwise>
				<dataItemValue>
					<xsl:attribute name="refDataItem"><xsl:value-of select="$v_refItem"/></xsl:attribute>
					<xsl:apply-templates/>
				</dataItemValue>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
