<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="lineChartTemplate">
		<combinationChart>
			<xsl:call-template name="depthTemplate"/>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="legendTemplate"/>
			<xsl:call-template name="axisTemplate"/>
			<combinationChartTypes>
				<line>
					<xsl:variable name="v_depth">
						<xsl:call-template name="getChartDepth"/>
					</xsl:variable>
					<xsl:if test="$v_depth = '0' or $v_depth = ''">
						<xsl:attribute name="showBorders">true</xsl:attribute>
					</xsl:if>
					<xsl:call-template name="chartMarkerTemplate">
						<xsl:with-param name="p_chart" select="baltic:lineChart"/>
						<xsl:with-param name="p_defaultShape" select="'square'"/>
					</xsl:call-template>
					<xsl:call-template name="processAttsTemplate">
						<xsl:with-param name="p_cur" select="baltic:lineChart"/>
					</xsl:call-template>
					<xsl:call-template name="valueTypeTemplate">
						<xsl:with-param name="p_chart" select="baltic:lineChart"/>
					</xsl:call-template>
					<xsl:call-template name="chartLevelTemplate">
						<xsl:with-param name="p_mode" select="'rowEdge'"/>
						<xsl:with-param name="p_testMoveMeasureToColEdge" select="'yes'"/>
					</xsl:call-template>
				</line>
			</combinationChartTypes>
			<xsl:call-template name="commonClustersTemplateWithMeasureOnColEdgeCheck"/>
			<xsl:call-template name="defaultMeasureTemplate">
				<xsl:with-param name="p_testByCount" select="'no'"/>
			</xsl:call-template>
			<xsl:call-template name="commonChartTemplate"/>
			<xsl:call-template name="commonChartMarkerTemplate"/>
			<xsl:call-template name="commonChartBaselineTemplate">
				<xsl:with-param name="chartType" select="'lineChart'"/>
				<xsl:with-param name="standardType" select="baltic:lineChart/@standardType"/>
			</xsl:call-template>
		</combinationChart>
	</xsl:template>
</xsl:stylesheet>
