<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:list">
		<list>
			<xsl:variable name="var_refQuery" select="@refQuery"/>
			<!-- originalRefQuery is used for property list fixups, and will be removed in later stages. -->
			<xsl:attribute name="originalRefQuery"><xsl:value-of select="@refQuery"/></xsl:attribute>
			<xsl:call-template name="listAttributesTemplate"/>
			<!-- 
			* In baltic, the list columns and their titles are specified separately.
			* In bering, each column specification contains its title.
			* So we must gather both columns and titles before generating the bering listColumns:
			* 
			* list/listColumns/listColumn -> list/listColumns/listColumn/listColumnBody
			* list/listColumnTitles/listColumnTitle - > list/listColumns/listColumn/listColumnTitle
			*
			* Mappings for the other list elements:
			* 
			* list/overallHeader -> list/listOverallGroup/listHeader
			* list/overallFooter -> list/listOverallGroup/listFooter
			* list/listHeader -> list/listPageHeader
			* list/listFooter -> list/listPageFooter
			* list/groupHeader -> list/listGroups/listGroup/listHeader
			* list/groupFooter -> list/listGroups/listGroup/listFooter
			* 
			* Mappings for corresponding list styles:
			* 
			* list/overallHeader/rowCells/simpleLayoutGroup -> list/listOverallGroup/listHeader/rowCellsStyle
			* list/overallFooter/rowCells/simpleLayoutGroup -> list/listOverallGroup/listFooter/rowCellsStyle
			* list/listHeader/rowCells/simpleLayoutGroup -> list/listPageHeader/rowCellsStyle.
			* list/listFooter/rowCells/simpleLayoutGroup -> list/listPageFooter/rowCellsStyle.
			* list/groupHeader/rowCells/simpleLayoutGroup -> list/listGroups/listGroup/listHeader/rowCellsStyle
			* list/groupFooter/rowCells/simpleLayoutGroup -> list/listGroups/listGroup/listFooter/rowCellsStyle
			* list/listColumnTitles/simpleLayoutGroup -> list/listColumnTitleStyle
			* list/listColumns/simpleLayoutGroup -> list/listColumnBodyStyle
			* 
			-->
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
			<xsl:variable name="var_nColumnBodies" select="count(baltic:listColumns/baltic:listColumn)"/>
			<xsl:variable name="var_nColumnTitles" select="count(baltic:listColumnTitles/baltic:listColumnTitle)"/>
			<xsl:variable name="var_listColumns" select="baltic:listColumns/baltic:listColumn"/>
			<xsl:variable name="var_listColumnTitles" select="baltic:listColumnTitles/baltic:listColumnTitle"/>
			<xsl:choose>
				<xsl:when test="$var_nColumnBodies = 0 and $var_nColumnTitles = 0">
					<xsl:comment>This list has no columns.</xsl:comment>
				</xsl:when>
				<xsl:when test="$var_nColumnBodies &gt; $var_nColumnTitles">
					<listColumns>
						<xsl:for-each select="baltic:listColumns/baltic:listColumn">
							<listColumn>
								<xsl:variable name="var_position" select="position()"/>
								<xsl:choose>
									<xsl:when test="$var_position &lt;= $var_nColumnTitles">
										<xsl:apply-templates select="$var_listColumnTitles[$var_position]"/>
									</xsl:when>
									<xsl:otherwise>
										<listColumnTitle>
											<contents/>
										</listColumnTitle>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:apply-templates select="$var_listColumns[$var_position]"/>
							</listColumn>
						</xsl:for-each>
					</listColumns>
				</xsl:when>
				<xsl:otherwise>
					<listColumns>
						<xsl:for-each select="baltic:listColumnTitles/baltic:listColumnTitle">
							<listColumn>
								<xsl:variable name="var_position" select="position()"/>
								<xsl:apply-templates select="$var_listColumnTitles[$var_position]"/>
								<xsl:choose>
									<xsl:when test="$var_position &lt;= $var_nColumnBodies">
										<xsl:apply-templates select="$var_listColumns[$var_position]"/>
									</xsl:when>
									<xsl:otherwise>
										<listColumnBody>
											<contents/>
										</listColumnBody>
									</xsl:otherwise>
								</xsl:choose>
							</listColumn>
						</xsl:for-each>
					</listColumns>
				</xsl:otherwise>
			</xsl:choose>
			<!-- The structure of the V5 list grouping is derived from the V4 Cube Dimension Levels. -->
			<xsl:apply-templates select="/baltic:report/baltic:querySet/baltic:BIQuery[@name=$var_refQuery]" mode="list">
				<xsl:with-param name="p_list" select="."/>
			</xsl:apply-templates>
			<xsl:call-template name="baltic:listOverallGroupTemplate"/>
			<xsl:apply-templates select="baltic:listHeader"/>
			<xsl:apply-templates select="baltic:listFooter"/>
			<xsl:apply-templates select="baltic:listColumnTitles" mode="style"/>
			<xsl:apply-templates select="baltic:listColumns" mode="style"/>
		</list>
	</xsl:template>
	<xsl:template name="listAttributesTemplate">
		<xsl:call-template name="addStyle"/>
		<xsl:attribute name="refQuery"><xsl:call-template name="getQueryTemplate"><xsl:with-param name="refQuery" select="@refQuery"/></xsl:call-template></xsl:attribute>
		<xsl:if test="count(@id) = 1">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="count(@maxColumns) = 1">
			<xsl:attribute name="columnsPerPage"><xsl:value-of select="@maxColumns"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="@maxRows != ''">
			<xsl:choose>
				<xsl:when test="@maxRows=0">
					<!-- INFINITY -->
					<xsl:attribute name="rowsPerPage">2147483647</xsl:attribute>
				</xsl:when>
				<xsl:when test="@maxRows&gt;0">
					<xsl:attribute name="rowsPerPage"><xsl:value-of select="@maxRows"/></xsl:attribute>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="count(@cellHeightBehavior) = 1">
			<xsl:attribute name="cellHeightBehavior"><xsl:value-of select="@cellHeightBehavior"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="count(@showColumnTitles) = 1">
			<xsl:attribute name="showColumnTitles"><xsl:value-of select="@showColumnTitles"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="count(@repeatEveryPage) = 1">
			<xsl:attribute name="repeatEveryPage"><xsl:value-of select="@repeatEveryPage"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="count(@keepWithHeader) = 1">
			<xsl:attribute name="keepWithHeader"><xsl:choose><xsl:when test="@keepWithHeader = 'true'">1</xsl:when><xsl:when test="@keepWithHeader = 'false'">0</xsl:when><xsl:otherwise><xsl:value-of select="@keepWithHeader"/></xsl:otherwise></xsl:choose></xsl:attribute>
		</xsl:if>
		<xsl:if test="count(@keepWithFooter) = 1">
			<xsl:attribute name="keepWithFooter"><xsl:choose><xsl:when test="@keepWithFooter = 'true'">1</xsl:when><xsl:when test="@keepWithFooter = 'false'">0</xsl:when><xsl:otherwise><xsl:value-of select="@keepWithFooter"/></xsl:otherwise></xsl:choose></xsl:attribute>
		</xsl:if>
		<xsl:if test="count(@shareResultSet) = 1">
			<xsl:attribute name="shareResultSet"><xsl:value-of select="@shareResultSet"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:listColumnTitles" mode="style">
		<xsl:if test="count(baltic:style) &gt; 0 or count(baltic:XMLAttribute) &gt; 0 or
			count(baltic:conditionalStyle) &gt; 0">
			<listColumnTitleStyle>
				<xsl:call-template name="simpleLayoutGroupTemplate"/>
			</listColumnTitleStyle>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:listColumns" mode="style">
		<xsl:if test="count(baltic:style) &gt; 0 or count(baltic:XMLAttribute) &gt; 0 or
			count(baltic:conditionalStyle) &gt; 0">
			<listColumnBodyStyle>
				<xsl:call-template name="simpleLayoutGroupTemplate"/>
			</listColumnBodyStyle>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:listColumnTitle">
		<listColumnTitle>
			<xsl:call-template name="addStyle"/>
			<xsl:call-template name="layoutContainerTemplate"/>
		</listColumnTitle>
	</xsl:template>
	<xsl:template match="baltic:listColumn">
		<listColumnBody>
			<xsl:call-template name="addStyle"/>
			<xsl:call-template name="layoutContainerTemplate"/>
			<!-- Map @refLevel to listColumnRowSpan/@refDataItem. -->
			<xsl:if test="count(@refLevel) = 1">
				<xsl:variable name="v_refQuery" select="ancestor::baltic:list[1]/@refQuery"/>
				<xsl:variable name="v_refLevel" select="@refLevel"/>
				<xsl:variable name="v_refDataItem">
					<xsl:call-template name="getItemNameFromLevelReference">
						<xsl:with-param name="p_queryName" select="$v_refQuery"/>
						<xsl:with-param name="p_levelRef" select="$v_refLevel"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$v_refDataItem='ERROR: Cannot find item or dataItem for the level referenced.'">
						<xsl:comment>
							<xsl:call-template name="logError2">
								<xsl:with-param name="p_msgId" select="'RSU_SPC_LEVEL_KEYITEM_MISSING'"/>
								<xsl:with-param name="p_param1" select="'listColumnRowSpan'"/>
								<xsl:with-param name="p_param2" select="$v_refLevel"/>
							</xsl:call-template>
						</xsl:comment>
					</xsl:when>
					<xsl:otherwise>
						<listColumnRowSpan>
							<xsl:attribute name="refDataItem"><xsl:value-of select="$v_refDataItem"/></xsl:attribute>
						</listColumnRowSpan>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</listColumnBody>
	</xsl:template>
	<xsl:template match="/baltic:report/baltic:querySet/baltic:BIQuery" mode="list">
		<xsl:param name="p_list"/>
		<xsl:variable name="var_cube">
			<xsl:call-template name="getCubeOrCubeReference"/>
		</xsl:variable>
		<xsl:variable name="var_listGroups">
			<xsl:apply-templates select="$var_cube/baltic:cube/baltic:dimension/baltic:level" mode="list">
				<xsl:with-param name="p_list" select="$p_list"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:if test="count($var_cube/baltic:cube/baltic:dimension/baltic:level) &gt; 0">
			<listGroups>
				<xsl:copy-of select="$var_listGroups"/>
			</listGroups>
		</xsl:if>
		<xsl:element name="propertyList"/>
		<!-- Generate the sortList from the baltic:cube/baltic:factList/baltic:item sort attributes. -->
		<sortList>
			<xsl:apply-templates select="$var_cube/baltic:cube/baltic:factList/baltic:item" mode="generate_sortItems"/>
		</sortList>
	</xsl:template>
	<xsl:template match="baltic:cube/baltic:dimension/baltic:level" mode="list">
		<xsl:param name="p_list"/>
		<xsl:variable name="var_refLevel" select="@name"/>
		<xsl:variable name="v_refDataItem">
			<xsl:call-template name="getKeyItemNameForLevel"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$v_refDataItem='ERROR: Cannot find item or dataItem for the level referenced.'">
				<xsl:comment>
					<xsl:call-template name="logError2">
						<xsl:with-param name="p_msgId" select="'RSU_SPC_LEVEL_KEYITEM_MISSING'"/>
						<xsl:with-param name="p_param1" select="'listGroup'"/>
						<xsl:with-param name="p_param2" select="$var_refLevel"/>
					</xsl:call-template>
				</xsl:comment>
			</xsl:when>
			<xsl:otherwise>
				<listGroup refDataItem="{$v_refDataItem}">
					<!-- Generate listHeader and listFooter from baltic:groupHeader and baltic:groupFooter with matching refLevel attribute. -->
					<xsl:apply-templates select="$p_list/baltic:groupHeader[@refLevel=$var_refLevel]"/>
					<xsl:apply-templates select="$p_list/baltic:groupFooter[@refLevel=$var_refLevel]"/>
					<xsl:element name="propertyList"/>
					<!-- Generate sortList from the baltic:item sort attributes up to this level in the current dimension. -->
					<sortList>
						<xsl:apply-templates select="baltic:item" mode="generate_sortItems"/>
					</sortList>
				</listGroup>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="baltic:listOverallGroupTemplate">
		<xsl:if test="count(baltic:overallHeader) &gt; 0 or count(baltic:overallFooter) &gt; 0">
			<listOverallGroup>
				<xsl:apply-templates select="baltic:overallHeader"/>
				<xsl:apply-templates select="baltic:overallFooter"/>
				<xsl:variable name="var_cube">
					<xsl:call-template name="getCube">
						<xsl:with-param name="p_queryName" select="@refQuery"/>
					</xsl:call-template>
				</xsl:variable>
			</listOverallGroup>
		</xsl:if>
	</xsl:template>
	<xsl:template name="rowCellsStyleTemplate">
		<xsl:if test="count(baltic:style) &gt; 0 or count(baltic:XMLAttribute) &gt; 0 or
			count(baltic:conditionalStyle) &gt; 0">
			<rowCellsStyle>
				<xsl:call-template name="simpleLayoutGroupTemplate"/>
			</rowCellsStyle>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:overallHeader">
		<listHeader>
			<xsl:if test="count(@repeatEveryPage) = 1">
				<xsl:attribute name="repeatEveryPage"><xsl:value-of select="@repeatEveryPage"/></xsl:attribute>
			</xsl:if>
			<!-- Output empty property list so location can be found when parsing expressions.
                 * It will be removed during Bering post processing phase of upgrade, if it is still empty.
                 -->
			<propertyList/>
			<listRows>
				<xsl:apply-templates select="baltic:rowCells"/>
			</listRows>
		</listHeader>
	</xsl:template>
	<xsl:template match="baltic:overallFooter">
		<listFooter>
			<xsl:if test="count(@pushToBottom) = 1">
				<xsl:attribute name="pushToBottom"><xsl:value-of select="@pushToBottom"/></xsl:attribute>
			</xsl:if>
			<!-- Output empty property list so location can be found when parsing expressions.
                 * It will be removed during Bering post processing phase of upgrade, if it is still empty.
                 -->
			<propertyList/>
			<listRows>
				<xsl:apply-templates select="baltic:rowCells"/>
			</listRows>
		</listFooter>
	</xsl:template>
	<xsl:template match="baltic:listHeader">
		<listPageHeader>
			<xsl:if test="count(@afterOverallHeader) = 1">
				<xsl:attribute name="afterOverallHeader"><xsl:value-of select="@afterOverallHeader"/></xsl:attribute>
			</xsl:if>
			<listRows>
				<xsl:apply-templates select="baltic:rowCells"/>
			</listRows>
		</listPageHeader>
	</xsl:template>
	<xsl:template match="baltic:listFooter">
		<listPageFooter>
			<xsl:if test="count(@pushToBottom) = 1">
				<xsl:attribute name="pushToBottom"><xsl:value-of select="@pushToBottom"/></xsl:attribute>
			</xsl:if>
			<listRows>
				<xsl:apply-templates select="baltic:rowCells"/>
			</listRows>
		</listPageFooter>
	</xsl:template>
	<xsl:template match="baltic:groupHeader">
		<xsl:if test="//baltic:rowCell">
			<listHeader>
				<xsl:if test="count(@repeatEveryPage) = 1">
					<xsl:attribute name="repeatEveryPage"><xsl:value-of select="@repeatEveryPage"/></xsl:attribute>
				</xsl:if>
				<!-- Output empty property list so location can be found when parsing expressions.
                 * It will be removed during Bering post processing phase of upgrade, if it is still empty.
                 -->
				<propertyList/>
				<listRows>
					<xsl:apply-templates select="baltic:rowCells"/>
				</listRows>
				<xsl:call-template name="rowCellsStyleTemplate"/>
			</listHeader>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:groupFooter">
		<xsl:if test="//baltic:rowCell">
			<listFooter>
				<xsl:if test="count(@pushToBottom) = 1">
					<xsl:attribute name="pushToBottom"><xsl:value-of select="@pushToBottom"/></xsl:attribute>
				</xsl:if>
				<!-- Output empty property list so location can be found when parsing expressions.
                 * It will be removed during Bering post processing phase of upgrade, if it is still empty.
                 -->
				<propertyList/>
				<listRows>
					<xsl:apply-templates select="baltic:rowCells"/>
				</listRows>
				<xsl:call-template name="rowCellsStyleTemplate"/>
			</listFooter>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:rowCells">
		<!-- NOTE: the baltic:rowCells becomes bering:listRow.  The bering:rowCells is just a simple container for rowCell elements. -->
		<listRow>
			<rowCells>
				<xsl:apply-templates select="baltic:rowCell"/>
			</rowCells>
			<xsl:call-template name="rowCellsStyleTemplate"/>
		</listRow>
	</xsl:template>
	<xsl:template match="baltic:rowCell">
		<rowCell>
			<xsl:call-template name="addStyle"/>
			<xsl:if test="count(@colSpan) = 1">
				<xsl:attribute name="colSpan"><xsl:value-of select="@colSpan"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="layoutContainerGroupTemplate"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</rowCell>
	</xsl:template>
	<xsl:template match="baltic:table">
		<xsl:variable name="var_tableRows">
			<xsl:apply-templates select="baltic:tableRow"/>
		</xsl:variable>
		<table>
			<xsl:if test="count(@id) = 1">
				<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="addStyle"/>
			<tableRows>
				<xsl:copy-of select="$var_tableRows"/>
			</tableRows>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</table>
	</xsl:template>
	<xsl:template match="baltic:tableRow">
		<xsl:variable name="var_tableCells">
			<xsl:apply-templates select="baltic:tableCell"/>
		</xsl:variable>
		<tableRow>
			<tableCells>
				<xsl:copy-of select="$var_tableCells"/>
			</tableCells>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</tableRow>
	</xsl:template>
	<xsl:template match="baltic:tableCell">
		<tableCell>
			<xsl:call-template name="addStyle"/>
			<xsl:if test="count(@colSpan) = 1">
				<xsl:attribute name="colSpan"><xsl:value-of select="@colSpan"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="layoutContainerGroupTemplate"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</tableCell>
	</xsl:template>
	<xsl:template match="baltic:block">
		<block>
			<xsl:if test="count(@id) = 1">
				<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="addStyle"/>
			<xsl:call-template name="layoutContainerTemplate"/>
		</block>
	</xsl:template>
	<xsl:template match="baltic:conditionalBlockList">
		<xsl:variable name="v_refVariableExists">
			<xsl:call-template name="checkRefVariableTemplate"/>
		</xsl:variable>
		<xsl:if test="$v_refVariableExists = 'true'">
			<conditionalBlocks>
				<xsl:if test="baltic:conditionalBlock[@refVariableValue]">
					<conditionalBlockCases>
						<xsl:attribute name="refVariable"><xsl:value-of select="@refVariable"/></xsl:attribute>
						<xsl:apply-templates select="baltic:conditionalBlock[@refVariableValue]"/>
					</conditionalBlockCases>
				</xsl:if>
				<conditionalBlockDefault>
					<xsl:apply-templates select="baltic:conditionalBlock[not(@refVariableValue)]"/>
				</conditionalBlockDefault>
			</conditionalBlocks>
		</xsl:if>
	</xsl:template>
	<xsl:template match="baltic:conditionalBlock[@refVariableValue]">
		<conditionalBlock>
			<xsl:call-template name="addStyle"/>
			<xsl:attribute name="refVariableValue"><xsl:value-of select="@refVariableValue"/></xsl:attribute>
			<xsl:call-template name="layoutContainerTemplate"/>
		</conditionalBlock>
	</xsl:template>
	<xsl:template match="baltic:conditionalBlock[not(@refVariableValue)]">
		<xsl:call-template name="layoutContainerTemplate"/>
	</xsl:template>
</xsl:stylesheet>
