<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template match="baltic:page">
		<xsl:param name="p_resetPageNumber"/>
		<!--Value may be passed down from the pageSet. -->
		<xsl:param name="p_resetPageCount"/>
		<!--Value may be passed down from the pageSet. -->
		<page>
			<xsl:if test="count(@refQuery)">
				<xsl:attribute name="refQuery"><xsl:call-template name="getQueryTemplate"><xsl:with-param name="refQuery" select="@refQuery"/></xsl:call-template></xsl:attribute>
				<xsl:attribute name="originalRefQuery"><xsl:call-template name="getQueryTemplate"><xsl:with-param name="refQuery" select="@refQuery"/></xsl:call-template></xsl:attribute>
			</xsl:if>
			<xsl:variable name="v_for">
				<xsl:choose>
					<xsl:when test="parent::baltic:promptPageList">promptPage</xsl:when>
					<xsl:otherwise>page</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:call-template name="addStyle">
				<xsl:with-param name="for" select="$v_for"/>
			</xsl:call-template>
			<xsl:if test="count(@name) = 1">
				<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="count(@resetPageNumber) = 1">
					<xsl:call-template name="resetPageTemplate">
						<xsl:with-param name="attribute" select="@resetPageNumber"/>
						<xsl:with-param name="targetName" select="'resetPageNumber'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$p_resetPageNumber != ''">
					<xsl:call-template name="resetPageTemplate">
						<xsl:with-param name="attribute" select="$p_resetPageNumber"/>
						<xsl:with-param name="targetName" select="'resetPageNumber'"/>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="count(@resetPageCount) = 1">
					<xsl:call-template name="resetPageTemplate">
						<xsl:with-param name="attribute" select="@resetPageCount"/>
						<xsl:with-param name="targetName" select="'resetPageCount'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$p_resetPageCount != ''">
					<xsl:call-template name="resetPageTemplate">
						<xsl:with-param name="attribute" select="$p_resetPageCount"/>
						<xsl:with-param name="targetName" select="'resetPageCount'"/>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:apply-templates select="baltic:pageBody"/>
			<xsl:apply-templates select="baltic:pageHeader"/>
			<xsl:choose>
				<xsl:when test="parent::baltic:promptPageList">
					<xsl:call-template name="promptPageFooter">
						<xsl:with-param name="p_page" select="."/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="baltic:pageFooter"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
			<xsl:variable name="v_cube">
				<xsl:call-template name="getCube">
					<xsl:with-param name="p_queryName" select="@refQuery"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="count(@refQuery)">
				<xsl:element name="propertyList"/>
			</xsl:if>
		</page>
	</xsl:template>
	<xsl:template name="resetPageTemplate">
		<xsl:param name="attribute"/>
		<xsl:param name="targetName"/>
		<xsl:choose>
			<xsl:when test="$attribute = 'true'">
				<xsl:attribute name="{$targetName}">1</xsl:attribute>
			</xsl:when>
			<xsl:when test="$attribute = 'false'"/>
			<xsl:when test="$attribute = 'never'"/>
			<xsl:otherwise>
				<xsl:attribute name="{$targetName}"><xsl:value-of select="$attribute"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="baltic:pageHeader">
		<pageHeader>
			<xsl:call-template name="addStyle">
				<xsl:with-param name="for" select="'pageHeader'"/>
			</xsl:call-template>
			<xsl:call-template name="layoutContainerGroupTemplate"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</pageHeader>
	</xsl:template>
	<xsl:template match="baltic:pageBody">
		<pageBody>
			<xsl:call-template name="addStyle">
				<xsl:with-param name="for" select="'pageBody'"/>
			</xsl:call-template>
			<xsl:call-template name="layoutContainerGroupTemplate"/>
			<xsl:call-template name="simpleLayoutGroupTemplate"/>
		</pageBody>
	</xsl:template>
	<xsl:template match="baltic:pageFooter">
		<pageFooter>
			<xsl:call-template name="pageFooterBody"/>
		</pageFooter>
	</xsl:template>
	<xsl:template name="pageFooterBody">
		<xsl:call-template name="addStyle">
			<xsl:with-param name="for" select="'pageFooter'"/>
		</xsl:call-template>
		<xsl:call-template name="layoutContainerGroupTemplate"/>
		<xsl:call-template name="simpleLayoutGroupTemplate"/>
	</xsl:template>
</xsl:stylesheet>
