<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="paretoChartTemplate">
		<paretoChart>
			<xsl:call-template name="processAttsTemplate">
				<xsl:with-param name="p_cur" select="baltic:paretoChart"/>
			</xsl:call-template>
			<xsl:call-template name="depthTemplate"/>
			<xsl:attribute name="orientation"><xsl:choose><xsl:when test="baltic:paretoChart/@paretoType='barStacked'">horizontal</xsl:when><xsl:otherwise>vertical</xsl:otherwise></xsl:choose></xsl:attribute>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="legendTemplate"/>
			<xsl:call-template name="axisParetoTemplate"/>
			<cumulationLine>
				<xsl:attribute name="color"><xsl:text>#cc9933</xsl:text></xsl:attribute>
				<xsl:attribute name="dataPointShape">
					<xsl:choose>
						<xsl:when test="baltic:paretoChart/baltic:cumulativeLine/@markerShape">
							<xsl:value-of select="baltic:paretoChart/baltic:cumulativeLine/@markerShape"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>circle</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:attribute name="dataPointSize">
					<!-- Note: markerSize is in pixels and must be converted to points for dataPointSize (see Trakker 550271). -->
					<xsl:choose>
						<xsl:when test="baltic:paretoChart/baltic:cumulativeLine/@markerSize">
							<xsl:value-of select="baltic:paretoChart/baltic:cumulativeLine/@markerSize * 0.75"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>5</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>		
				<cumulationLabel>
					<xsl:call-template name="addStyle">
						<xsl:with-param name="for" select="'cumulationLineLabel'"/>
						<xsl:with-param name="default" select="'false'"/>
					</xsl:call-template>
					<chartContents>
						<xsl:for-each select="baltic:paretoChart/baltic:cumulativeLine/baltic:chartText">
							<xsl:call-template name="chartPlainTextTemplate"/>
						</xsl:for-each>
					</chartContents>
				</cumulationLabel>
				<xsl:variable name="v_Y2" select="baltic:axis[@axisPosition='Y2']"/>
				<xsl:if test="$v_Y2">
					<cumulationAxis>
						<xsl:call-template name="copyAxisAttsTemplate">
							<xsl:with-param name="p_el" select="$v_Y2"/>
						</xsl:call-template>
						<xsl:call-template name="axisTitleTemplate">
							<xsl:with-param name="p_cur" select="$v_Y2"/>
							<xsl:with-param name="p_y2">true</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_lineStyle">dash</xsl:with-param>
							<xsl:with-param name="p_color">#99ccff</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate">
							<xsl:with-param name="p_axis" select="$v_Y2"/>
							<xsl:with-param name="p_y2" select="'true'"/>
						</xsl:call-template>
					</cumulationAxis>
				</xsl:if>
			</cumulationLine>
			<xsl:variable name="v_refQuery" select="@refQuery"/>
			<xsl:variable name="p_testMoveMeasureToColEdge">
				<xsl:if test="not(@columnEdgeIncluded ='false') and //baltic:BIQuery[@name=$v_refQuery]/baltic:summary/baltic:columnEdge/baltic:cellMembers">1</xsl:if>
			</xsl:variable>
			<xsl:variable name="v_paretoBarClusters">
				<xsl:call-template name="chartLevelTemplate">
					<xsl:with-param name="p_mode" select="'columnEdge'"/>
					<xsl:with-param name="p_testMoveMeasureToColEdge" select="$p_testMoveMeasureToColEdge"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$v_paretoBarClusters/*">
				<paretoBarClusters>
					<xsl:copy-of select="$v_paretoBarClusters"/>
				</paretoBarClusters>
			</xsl:if>
			<xsl:variable name="v_paretoBars">
				<xsl:call-template name="chartLevelTemplate">
					<xsl:with-param name="p_mode" select="'rowEdge'"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$v_paretoBars/*">
				<paretoBars>
					<xsl:copy-of select="$v_paretoBars"/>
				</paretoBars>
			</xsl:if>
			<xsl:call-template name="defaultMeasureTemplate">
				<xsl:with-param name="p_testByCount" select="'no'"/>
			</xsl:call-template>
			<xsl:call-template name="commonChartTemplate"/>
			<xsl:call-template name="commonChartMarkerTemplate"/>
			<xsl:call-template name="commonChartBaselineTemplate">
				<xsl:with-param name="chartType" select="'paretoChart'"/>
			</xsl:call-template>
		</paretoChart>
	</xsl:template>
	<xsl:template name="axisParetoTemplate">
		<xsl:for-each select="baltic:axis">
			<xsl:variable name="v_axisPosition" select="@axisPosition"/>
			<xsl:choose>
				<xsl:when test="$v_axisPosition = 'X'">
					<xsl:call-template name="ordinalAxis">
						<xsl:with-param name="p_gridLines" select="0"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$v_axisPosition = 'Y1'">
					<numericalAxisPareto>
						<xsl:call-template name="copyAxisAttsTemplate"/>
						<xsl:call-template name="axisTitleTemplate"/>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_chart" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</numericalAxisPareto>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
