<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<!--
*  The input is a bering report specification.  The output is a
* cleaned up bering report specification.
-->
<xsl:stylesheet version="1.0" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns:bering="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no" xalan:indent-amount="2" omit-xml-declaration="yes"/>
	<!--
 * Return the name of the query that is being used for the node. 
*
* @param p_node Node to find the enclosing query for.
-->
	<xsl:template name="getRefQuery">
		<xsl:param name="p_node"/>
		<xsl:choose>
			<xsl:when test="$p_node/@refQuery">
				<xsl:value-of select="$p_node/@refQuery"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$p_node/..">
					<xsl:call-template name="getRefQuery">
						<xsl:with-param name="p_node" select="$p_node/.."/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Check if the node or its ancestor has as a child that is an asOfTime element. 
      *   If it does, and it is attached to the same query then do not ouput the asOfTime.
      *  Otherwise output p_asOfTime.
 -->
	<xsl:template name="hasAsOfTime">
		<xsl:param name="p_node"/>
		<xsl:param name="p_refQuery"/>
		<xsl:param name="p_asOfTime"/>
		<xsl:choose>
			<xsl:when test="$p_node/bering:asOfTime">
				<xsl:variable name="v_nodeRefQuery">
					<xsl:call-template name="getRefQuery">
						<xsl:with-param name="p_node" select="$p_node/.."/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="not($v_nodeRefQuery = $p_refQuery)">
					<xsl:copy-of select="$p_asOfTime"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$p_node/..">
						<xsl:call-template name="hasAsOfTime">
							<xsl:with-param name="p_node" select="$p_node/.."/>
							<xsl:with-param name="p_refQuery" select="$p_refQuery"/>
							<xsl:with-param name="p_asOfTime" select="$p_asOfTime"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="$p_asOfTime"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
   * Check that there is not already an enclosing element that has as a child an asOfTime element. 
   -->
	<xsl:template match="bering:asOfTime">
		<xsl:comment>AsOfTime</xsl:comment>
		<xsl:variable name="v_refQuery">
			<xsl:call-template name="getRefQuery">
				<xsl:with-param name="p_node" select="."/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="hasAsOfTime">
			<xsl:with-param name="p_node" select="../.."/>
			<xsl:with-param name="p_refQuery" select="$v_refQuery"/>
			<xsl:with-param name="p_asOfTime" select="."/>
		</xsl:call-template>
	</xsl:template>
	<!-- sort the propertyItems so they compare the same
        *  in test cases. 
    -->
	<xsl:template match="bering:propertyList">
		<xsl:element name="propertyList">
			<xsl:apply-templates select="@*"/>
			<xsl:for-each select="./bering:propertyItem">
				<xsl:sort select="@refDataItem"/>
				<xsl:apply-templates select="."/>
			</xsl:for-each>
			<xsl:apply-templates select="bering:XMLAttributes"/>
			<xsl:apply-templates select="comment()"/>
		</xsl:element>
	</xsl:template>
	<!-- sort the reportVariable's so they compare the same
        *  in test cases. 
     -->
	<xsl:template match="bering:reportVariables">
		<xsl:element name="reportVariables">
			<xsl:apply-templates select="@*"/>
			<xsl:for-each select="./bering:reportVariable">
				<xsl:sort select="@name"/>
				<xsl:apply-templates select="."/>
			</xsl:for-each>
			<xsl:apply-templates select="bering:XMLAttributes"/>
			<xsl:apply-templates select="comment()"/>
		</xsl:element>
	</xsl:template>
	<!-- Remove the artificial 'originalRefQuery' attribute that does not 
		belong to the v5 report specification.
	-->
	<xsl:template match="@originalRefQuery">
	</xsl:template>
	<!-- Remove the artificial 'originalRefItem' attribute that does not 
		belong to the v5 report specification.
	-->
	<xsl:template match="@originalRefItem">
	</xsl:template>
	<!-- Remove the artifical 'originalRefLevel' attribute that does not 
		belong to the v5 report specification.
	-->
	<xsl:template match="@originalRefLevel">
	</xsl:template>
	<!-- Remove the artificial 'layoutRefQuery' attribute that does not 
		belong to the v5 report specification.
	-->
	<xsl:template match="@layoutRefQuery">
	</xsl:template>
	<!-- Remove the artificial 'querySet' element that does not 
		belong to the v5 report specification.
	-->
	<xsl:template match="baltic:querySet">
	</xsl:template>
	<!-- Remove the artificial 'ret' element that does not 
		belong to the v5 report specification.
	-->
	<xsl:template match="ret">
	</xsl:template>
	<!-- If maxCharacters is 0 then change it to have the CSS style
         * visibility: none.
         * See trakker 520732
      -->
	<xsl:template match="bering:textItem[./@maxCharacters &lt; 1 and not(./bering:style)]">
		<xsl:element name="textItem">
			<xsl:apply-templates select="@*[not(local-name()='maxCharacters')]"/>
			<xsl:element name="style">
				<xsl:element name="CSS">
					<xsl:attribute name="value">visibility:hidden</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="bering:textItem[./@maxCharacters &lt; 1 and ./bering:style]">
		<xsl:element name="textItem">
			<xsl:apply-templates select="@*[not(local-name()='maxCharacters')]"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="bering:textItem/bering:style[../@maxCharacters &lt; 1 and not(bering:CSS)]">
		<xsl:element name="style">
			<xsl:apply-templates select="@*"/>
			<xsl:element name="CSS">
				<xsl:attribute name="value">visibility:hidden</xsl:attribute>
			</xsl:element>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="bering:textItem/bering:style/bering:CSS/@value[../../../@maxCharacters &lt; 1]">
		<xsl:attribute name="value"><xsl:value-of select="."/>;visibility:hidden</xsl:attribute>
	</xsl:template>
	<!-- Copy anything that is unmatched over to output. -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
