<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="progressiveChartTemplate">
		<progressiveChart>
			<xsl:call-template name="addStyle">
				<xsl:with-param name="for" select="'chart'"/>
				<xsl:with-param name="default" select="'false'"/>
			</xsl:call-template>
			<xsl:attribute name="orientation">vertical</xsl:attribute>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<!-- <xsl:call-template name="legendTemplate"/> -->
			<xsl:call-template name="axisProgressiveTemplate"/>
			<xsl:variable name="v_refItem" select="baltic:chartLevel/baltic:chartText/baltic:queryItemRef/@refItem"/>
			<xsl:variable name="v_progressiveBars">
				<xsl:call-template name="chartLevelTemplate">
					<xsl:with-param name="p_mode" select="'columnEdge'"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$v_progressiveBars/*">
				<progressiveBars>
					<xsl:copy-of select="$v_progressiveBars"/>
				</progressiveBars>
			</xsl:if>
			<xsl:call-template name="defaultMeasureTemplate"/>
			<xsl:if test="baltic:progressiveChart/baltic:totalColumn">
				<total>
					<xsl:call-template name="addStyle">
						<xsl:with-param name="for" select="'progressiveChartTotalColumn'"/>
						<xsl:with-param name="default" select="'false'"/>
					</xsl:call-template>
					<totalColumnLabel>
						<chartContents>
							<chartTextItem>
								<dataSource>
									<staticValue>Total</staticValue>
								</dataSource>
							</chartTextItem>
						</chartContents>
					</totalColumnLabel>
					<xsl:if test="baltic:progressiveChart/baltic:columnColor[@columnType='total']/*">
						<totalColumnColor>
							<xsl:apply-templates select="baltic:progressiveChart/baltic:columnColor[@columnType='total']/*"/>
						</totalColumnColor>
					</xsl:if>
				</total>
			</xsl:if>
			<xsl:if test="baltic:progressiveChart/baltic:columnColor[@columnType='positiveValues']/*">
				<positiveColumnColor>
					<xsl:apply-templates select="baltic:progressiveChart/baltic:columnColor[@columnType='positiveValues']/*"/>
				</positiveColumnColor>
			</xsl:if>
			<xsl:if test="baltic:progressiveChart/baltic:columnColor[@columnType='negativeValues']/*">
				<negativeColumnColor>
					<xsl:apply-templates select="baltic:progressiveChart/baltic:columnColor[@columnType='negativeValues']/*"/>
				</negativeColumnColor>
			</xsl:if>
			<xsl:if test="baltic:progressiveChart/baltic:columnColor[@columnType='first']/*">
				<firstColumnColor>
					<xsl:apply-templates select="baltic:progressiveChart/baltic:columnColor[@columnType='first']/*"/>
				</firstColumnColor>
			</xsl:if>
			<xsl:call-template name="commonChartTemplate"/>
			<xsl:call-template name="commonChartMarkerTemplate"/>
			<xsl:call-template name="commonChartBaselineTemplate">
				<xsl:with-param name="chartType" select="'progressiveChart'"/>
			</xsl:call-template>
		</progressiveChart>
	</xsl:template>
	<xsl:template name="axisProgressiveTemplate">
		<xsl:for-each select="baltic:axis">
			<xsl:variable name="v_axisPosition" select="@axisPosition"/>
			<xsl:choose>
				<xsl:when test="$v_axisPosition = 'X'">
					<xsl:call-template name="ordinalAxis">
						<xsl:with-param name="p_gridLines" select="0"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$v_axisPosition = 'Y1'">
					<numericalAxisProgressive>
						<xsl:call-template name="copyAxisAttsTemplate"/>
						<xsl:call-template name="axisTitleTemplate"/>
						<xsl:call-template name="gridlinesTemplate">
							<xsl:with-param name="p_chart" select=".."/>
						</xsl:call-template>
						<xsl:call-template name="mergeStylesFromAxisAndAxisLabelsTemplate"/>
					</numericalAxisProgressive>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
