<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<!--
	* This stylesheet generates a squeleton of V5 QRD from a V5 Report Specification.
	* The QRD squeleton describes the structure of the report, down to the valueSet element.
	* This QRD is intended to be used for the implementation of WO1713 and WO1730.
	* QFW upgrades the query based on an analysis of the queries and structure of the queryResultDefinitions.
	*
	* NOTE: WO1713 and WO1730 only apply to crosstabs, so the QRD generation rules here are only implemented for crosstabs.
	*
-->
<xsl:stylesheet version="1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:v5="http://developer.cognos.com/schemas/report/2.0/" xmlns="http://developer.cognos.com/schemas/report/2.0/" exclude-result-prefixes="xsl fo xs">
	<xsl:output method="xml" encoding="utf-8"/>
	<!-- ================================================================================= -->
	<!-- Document Definition -->
	<xsl:template match="/">
		<xsl:apply-templates select="v5:report"/>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:report">
		<querySet>
			<xsl:apply-templates select="v5:modelPath"/>
			<xsl:apply-templates select="v5:queries"/>
			<queryResultDefinitions>
				<xsl:apply-templates select="v5:layouts"/>
			</queryResultDefinitions>
		</querySet>
	</xsl:template>
	<!-- ================================================================================= -->
	<!-- Build queryResultDefinition from layout -->
	<xsl:template match="v5:layout">
		<xsl:apply-templates select=".//v5:crosstab"/>
	</xsl:template>
	<!-- ================================================================================= -->
	<!-- Build crosstabResult from crosstab layout -->
	<xsl:template match="v5:crosstab">
		<queryResultDefinition name="{name()}: {@refQuery}" refQuery="{@refQuery}">
			<edges>
				
					<xsl:apply-templates select=".//v5:crosstabColumns"/>
					<xsl:apply-templates select=".//v5:crosstabRows"/>
					<xsl:apply-templates select=".//v5:defaultMeasure"/>
				
			</edges>
		</queryResultDefinition>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:crosstabColumns">
		<xsl:variable name="edgeName"><xsl:value-of select="generate-id(.)"/></xsl:variable>
		<edge edgeID="1" name="{$edgeName}">
			<edgeGroups>
				<xsl:apply-templates select="v5:crosstabNode"/>
			</edgeGroups>
		</edge>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:crosstabRows">
		<xsl:variable name="edgeName"><xsl:value-of select="generate-id(.)"/></xsl:variable>
		<edge edgeID="2" name="{$edgeName}">
			<edgeGroups>
				<xsl:apply-templates select="v5:crosstabNode"/>
			</edgeGroups>
		</edge>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:defaultMeasure">
		<xsl:variable name="edgeName"><xsl:value-of select="generate-id(.)"/></xsl:variable>
		<xsl:variable name="valueSetName"><xsl:value-of select="@name"/></xsl:variable>
		<edge edgeID="3" name="{$edgeName}">
			<edgeGroups>
				<edgeGroup>
					<valueSets>
						<valueSet name="{$valueSetName}" refDataItem="{@refDataItem}"/>
					</valueSets>
				</edgeGroup>
			</edgeGroups>
		</edge>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:crosstabNode">
		<edgeGroup>
			<xsl:apply-templates select="v5:crosstabNodeMembers"/>
			<xsl:apply-templates select="v5:crosstabNestedNodes"/>
		</edgeGroup>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:crosstabNestedNodes">
		<edgeGroups>
			<xsl:apply-templates select="v5:crosstabNode"/>
		</edgeGroups>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:crosstabNodeMembers">
		<valueSets>
			<xsl:apply-templates select="v5:crosstabNodeMember"/>
		</valueSets>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="v5:crosstabNodeMember">
		<xsl:variable name="refItem" select="@refDataItem"/>
		<xsl:variable name="valueSetName"><xsl:value-of select="@name"/></xsl:variable>
		<valueSet name="{$valueSetName}" refDataItem="{$refItem}"/>
	</xsl:template>
	<!-- ================================================================================= -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- Copy all nodes and attributes by default.                                                                               -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
