<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed Materials - Property of IBM

IBM Cognos Products: rspecupgrade

(C) Copyright IBM Corp. 2005, 2010

US Government Users Restricted Rights - Use, duplication or disclosure 
restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!-- COPYRIGHT_DATA { 'YEAR':[2005, 2009], 'RELEASE':['colorado_wave1'], 'VISIBLE':'YES', 'COMPONENT':'rspecupgrade' }-->
<!--All lines above the COPYRIGHT_DATA  line will be replaced when copyright notices are generated. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:baltic="http://developer.cognos.com/schemas/report/1/" xmlns="http://developer.cognos.com/schemas/report/2.0/" xmlns:date="http://exslt.org/dates-and-times" xmlns:exsl="http://exslt.org/common" xmlns:xalan="http://xml.apache.org/xalan" xmlns:java="http://xml.apache.org/xalan/java" extension-element-prefixes="xalan date exsl" exclude-result-prefixes="xalan java baltic date exsl">
	<xsl:template name="combinationThreeDChartTemplate">
		<threeDCombinationChart>
			<xsl:call-template name="matchSeriesColorTemplate"/>
			<xsl:call-template name="standardChartAttributesTemplate"/>
			<xsl:call-template name="generateMasterDetailLinks2">
				<xsl:with-param name="p_frame" select="."/>
			</xsl:call-template>
			<xsl:call-template name="axis3DTemplate"/>
			<threeDCombinationChartTypes>
				<xsl:apply-templates select="baltic:combinationChart/baltic:*"/>
			</threeDCombinationChartTypes>
			<xsl:call-template name="commonClustersTemplate">
				<xsl:with-param name="p_addChartContents" select="'true'"/>
			</xsl:call-template>
			<xsl:call-template name="defaultMeasureTemplate"/>
			<xsl:call-template name="commonChartTemplate"/>
			<xsl:call-template name="threeDComboBaselineTemplate">
				<xsl:with-param name="chartType" select="'combinationChart'"/>
				<xsl:with-param name="standardType" select="baltic:combinationChart/@standardType"/>
			</xsl:call-template>
		</threeDCombinationChart>
	</xsl:template>
	<xsl:template match="baltic:combinationChart[@standardType='3DAxis']/baltic:area">
		<threeDArea>
			<xsl:call-template name="processAttsTemplate"/>
			<xsl:call-template name="fillNodesTemplate">
				<xsl:with-param name="p_refQuery" select="../../@refQuery"/>
			</xsl:call-template>
		</threeDArea>
	</xsl:template>
	<xsl:template match="baltic:combinationChart[@standardType='3DAxis']/baltic:bar">
		<threeDBar>
			<xsl:call-template name="processAttsTemplate"/>
			<xsl:call-template name="fillNodesTemplate">
				<xsl:with-param name="p_refQuery" select="../../@refQuery"/>
			</xsl:call-template>
		</threeDBar>
	</xsl:template>
	<xsl:template match="baltic:combinationChart[@standardType='3DAxis']/baltic:column">
		<threeDBar>
			<xsl:call-template name="processAttsTemplate"/>
			<xsl:call-template name="fillNodesTemplate">
				<xsl:with-param name="p_refQuery" select="../../@refQuery"/>
			</xsl:call-template>
		</threeDBar>
	</xsl:template>
	<xsl:template match="baltic:combinationChart[@standardType='3DAxis']/baltic:line">
		<threeDLine>
			<xsl:call-template name="processAttsTemplate"/>
			<xsl:call-template name="fillNodesTemplate">
				<xsl:with-param name="p_refQuery" select="../../@refQuery"/>
			</xsl:call-template>
		</threeDLine>
	</xsl:template>
</xsl:stylesheet>
